/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.recordstore;

import com.hazelcast.cluster.Address;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryView;
import com.hazelcast.internal.eviction.ExpiredKey;
import com.hazelcast.internal.nearcache.impl.invalidation.InvalidationQueue;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.event.MapEventPublisher;
import com.hazelcast.map.impl.eviction.Evictor;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.AbstractRecordStore;
import com.hazelcast.map.impl.recordstore.expiry.ExpiryMetadata;
import com.hazelcast.map.impl.recordstore.expiry.ExpiryReason;
import com.hazelcast.map.impl.recordstore.expiry.ExpirySystem;
import com.hazelcast.map.impl.recordstore.expiry.ExpirySystemImpl;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.eventservice.EventService;
import com.hazelcast.spi.merge.SplitBrainMergeTypes;
import java.util.LinkedList;
import javax.annotation.Nonnull;

public abstract class AbstractEvictableRecordStore
extends AbstractRecordStore {
    protected final Address thisAddress;
    protected final EventService eventService;
    protected final MapEventPublisher mapEventPublisher;
    protected final ExpirySystem expirySystem;

    protected AbstractEvictableRecordStore(MapContainer mapContainer, int partitionId) {
        super(mapContainer, partitionId);
        NodeEngine nodeEngine = this.mapServiceContext.getNodeEngine();
        this.eventService = nodeEngine.getEventService();
        this.mapEventPublisher = this.mapServiceContext.getMapEventPublisher();
        this.thisAddress = nodeEngine.getThisAddress();
        this.expirySystem = this.createExpirySystem(mapContainer);
    }

    @Override
    public ExpirySystem getExpirySystem() {
        return this.expirySystem;
    }

    @Nonnull
    protected ExpirySystem createExpirySystem(MapContainer mapContainer) {
        return new ExpirySystemImpl(this, mapContainer, this.mapServiceContext);
    }

    @Override
    public void evictExpiredEntries(int percentage, long now, boolean backup) {
        this.expirySystem.evictExpiredEntries(percentage, now, backup);
    }

    @Override
    public boolean isExpirable() {
        return !this.expirySystem.isEmpty();
    }

    @Override
    public void evictEntries(Data excludedKey) {
        if (this.shouldEvict()) {
            this.mapContainer.getEvictor().evict(this, excludedKey);
        }
    }

    @Override
    public void sampleAndForceRemoveEntries(int entryCountToRemove) {
        Data dataKey;
        LinkedList<Data> keysToRemove = new LinkedList<Data>();
        Iterable<EntryView> sample = this.storage.getRandomSamples(entryCountToRemove);
        for (EntryView entryView : sample) {
            Data dataKey2 = this.storage.extractDataKeyFromLazy(entryView);
            keysToRemove.add(dataKey2);
        }
        while ((dataKey = (Data)keysToRemove.poll()) != null) {
            this.evict(dataKey, true);
        }
    }

    @Override
    public boolean shouldEvict() {
        Evictor evictor = this.mapContainer.getEvictor();
        return evictor != Evictor.NULL_EVICTOR && evictor.checkEvictable(this);
    }

    @Override
    public boolean evictIfExpired(Data key, long now, boolean backup) {
        ExpiryReason expiryReason = this.hasExpired(key, now, backup);
        if (expiryReason == ExpiryReason.NOT_EXPIRED) {
            return false;
        }
        this.evictExpiredEntryAndPublishExpiryEvent(key, expiryReason, backup);
        return true;
    }

    @Override
    public void evictExpiredEntryAndPublishExpiryEvent(Data key, ExpiryReason expiryReason, boolean backup) {
        Object value = this.evict(key, backup);
        if (value != null && !backup) {
            this.doPostEvictionOperations(key, value, expiryReason);
        }
    }

    @Override
    public ExpiryReason hasExpired(Data key, long now, boolean backup) {
        if (this.expirySystem.isEmpty() || this.isLocked(key)) {
            return ExpiryReason.NOT_EXPIRED;
        }
        return this.expirySystem.hasExpired(key, now, backup);
    }

    @Override
    public boolean isExpired(Data key, long now, boolean backup) {
        return this.hasExpired(key, now, backup) != ExpiryReason.NOT_EXPIRED;
    }

    @Override
    public void doPostEvictionOperations(Data dataKey, Object value, ExpiryReason expiryReason) {
        if (this.eventService.hasEventRegistration("hz:impl:mapService", this.name)) {
            EntryEventType eventType = expiryReason != ExpiryReason.NOT_EXPIRED ? EntryEventType.EXPIRED : EntryEventType.EVICTED;
            this.mapEventPublisher.publishEvent(this.thisAddress, this.name, eventType, dataKey, value, null);
        }
        if (expiryReason == ExpiryReason.MAX_IDLE_SECONDS) {
            this.expirySystem.accumulateOrSendExpiredKey(dataKey, value.hashCode());
        }
    }

    @Override
    public InvalidationQueue<ExpiredKey> getExpiredKeysQueue() {
        return this.expirySystem.getExpiredKeys();
    }

    @Override
    public void accessRecord(Data dataKey, Record record, long now) {
        record.onAccess(now);
        this.updateStatsOnGet(now);
        this.expirySystem.extendExpiryTime(dataKey, now);
    }

    public void mergeRecordExpiration(Data key, Record record, SplitBrainMergeTypes.MapMergeTypes mergingEntry, long now) {
        this.mergeRecordExpiration(record, mergingEntry.getCreationTime(), mergingEntry.getLastAccessTime(), mergingEntry.getLastUpdateTime());
        Long maxIdle = mergingEntry.getMaxIdle();
        if (maxIdle != null) {
            this.getExpirySystem().add(key, mergingEntry.getTtl(), maxIdle, mergingEntry.getExpirationTime(), mergingEntry.getLastUpdateTime(), now);
        } else {
            ExpiryMetadata expiryMetadata = this.getExpirySystem().getExpiryMetadata(key);
            this.getExpirySystem().add(key, mergingEntry.getTtl(), expiryMetadata.getMaxIdle(), mergingEntry.getExpirationTime(), mergingEntry.getLastUpdateTime(), now);
        }
    }

    private void mergeRecordExpiration(Record record, long creationTime, long lastAccessTime, long lastUpdateTime) {
        record.setCreationTime(creationTime);
        record.setLastAccessTime(lastAccessTime);
        record.setLastUpdateTime(lastUpdateTime);
    }
}

