/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.record;

import com.hazelcast.config.MapConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.hidensity.HiDensityRecordAccessor;
import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.memory.MemoryBlock;
import com.hazelcast.internal.memory.impl.ByteArrayAccessStrategy;
import com.hazelcast.internal.memory.impl.EndiannessUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.HeapData;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import com.hazelcast.internal.serialization.impl.NativeMemoryDataUtil;
import com.hazelcast.internal.tstore.hybridlog.HybridLog;
import com.hazelcast.internal.tstore.hybridlog.HybridLogReference;
import com.hazelcast.internal.util.HashUtil;
import com.hazelcast.map.impl.EnterpriseMapContainer;
import com.hazelcast.map.impl.EnterprisePartitionContainer;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.eviction.Evictor;
import com.hazelcast.map.impl.record.TieredStoreChunkAccessor;
import com.hazelcast.map.impl.record.TieredStoreRecord;
import com.hazelcast.map.impl.record.TieredStoreRecordWithStats;
import com.hazelcast.map.impl.record.TieredStoreRecordWithVersion;
import com.hazelcast.map.impl.record.TieredStoreSlotAccessor;

public class TieredStoreRecordAccessor
implements HiDensityRecordAccessor<TieredStoreRecord> {
    public static final int HEADER_OFFSET = 0;
    public static final int RECORD_LENGTH_OFFSET = 8;
    public static final int HEADER_SIZE = 12;
    public static final int KEY_OFFSET = 12;
    public static final long DUMMY_RECORD_MASK = Long.MIN_VALUE;
    public static final long LOCK_RECORD_MASK = 0x4000000000000000L;
    private static final long NEXT_ADDRESS_CLEAR_MASK = -4611686018427387904L;
    private static final long NEXT_ADDRESS_MASK = 0x3FFFFFFFFFFFFFFFL;
    private final MapContainer mapContainer;
    private final EnterpriseSerializationService ss;
    private final HybridLogReference hybridLogRef;
    private final TieredStoreSlotAccessor inMemorySlotAccessor;
    private final TieredStoreChunkAccessor inMemoryChunkAccessor;

    public TieredStoreRecordAccessor(EnterpriseSerializationService ss, EnterpriseMapContainer mapContainer, int partitionId) {
        this.ss = ss;
        this.mapContainer = mapContainer;
        MapServiceContext mapServiceContext = mapContainer.getMapServiceContext();
        EnterprisePartitionContainer partitionContainer = (EnterprisePartitionContainer)mapServiceContext.getPartitionContainer(partitionId);
        this.hybridLogRef = partitionContainer.getOrCreateHybridLogReference(mapContainer.getName());
        this.inMemorySlotAccessor = new TieredStoreSlotAccessor(this);
        this.inMemoryChunkAccessor = new TieredStoreChunkAccessor();
    }

    @Override
    public TieredStoreRecord newRecord() {
        MapConfig mapConfig = this.mapContainer.getMapConfig();
        boolean hasEviction = this.mapContainer.getEvictor() != Evictor.NULL_EVICTOR;
        boolean hasHotRestart = mapConfig.getHotRestartConfig().isEnabled();
        if (mapConfig.isPerEntryStatsEnabled()) {
            return new TieredStoreRecordWithStats(this);
        }
        if (!hasEviction && !hasHotRestart) {
            return new TieredStoreRecordWithVersion(this);
        }
        throw new IllegalStateException("No tiered-store record type found matching with the provided " + mapConfig);
    }

    public int recordSize(Data key, Data value, int metadataSize) {
        int totalKeySize = 4 + key.totalSize();
        int totalValueSize = 4 + value.totalSize();
        return 12 + totalKeySize + totalValueSize + metadataSize;
    }

    @Override
    public NativeMemoryData readData(long valueAddress) {
        if (valueAddress == 0L) {
            throw new IllegalArgumentException("Illegal memory address: " + valueAddress);
        }
        return new NativeMemoryData().reset(valueAddress);
    }

    @Override
    public long disposeData(NativeMemoryData data) {
        throw new UnsupportedOperationException("Dispose is not supported for the hybrid log");
    }

    @Override
    public long disposeData(long address) {
        throw new UnsupportedOperationException("Dispose is not supported for the hybrid log");
    }

    @Override
    public Object readValue(TieredStoreRecord record) {
        NativeMemoryData nativeMemoryData = this.readData(record.getValueAddress());
        return this.ss.toObject((Object)nativeMemoryData, this.ss.getMemoryManager());
    }

    @Override
    public long readValueAddress(TieredStoreRecord record) {
        return this.readValueAddress(record.address());
    }

    @Override
    public void setValueAddress(TieredStoreRecord record, long address) {
        NativeMemoryData value = new NativeMemoryData().reset(address);
        this.setValue(record, (Data)value);
    }

    @Override
    public void setValue(TieredStoreRecord record, Data value) {
        assert (!TieredStoreRecordAccessor.isKeyNull(record.address()));
        if (value == null) {
            TieredStoreRecordAccessor.setValueNull(record);
            return;
        }
        int dataValueSize = value.totalSize();
        int valueOffset = TieredStoreRecordAccessor.getValueOffset(record.address());
        int oldValueSize = GlobalMemoryAccessorRegistry.AMEM.getInt(record.address() + (long)valueOffset);
        long dstValueAddress = record.address() + (long)valueOffset;
        if (oldValueSize > 0 && dataValueSize != oldValueSize) {
            throw new HazelcastException("Cannot set value in TieredStoreRecord: value size mismatch");
        }
        if (value instanceof NativeMemoryData) {
            NativeMemoryData nativeValue = (NativeMemoryData)value;
            GlobalMemoryAccessorRegistry.AMEM.copyMemory(nativeValue.address(), dstValueAddress, nativeValue.size());
        } else {
            byte[] dataValue = value.toByteArray();
            GlobalMemoryAccessorRegistry.AMEM.putInt(dstValueAddress, dataValue.length);
            GlobalMemoryAccessorRegistry.AMEM.copyFromByteArray(dataValue, 0, dstValueAddress + 4L, dataValue.length);
        }
    }

    public static int readValueSize(TieredStoreRecord record) {
        int valueOffset = TieredStoreRecordAccessor.getValueOffset(record.address());
        return GlobalMemoryAccessorRegistry.AMEM.getInt(record.address() + (long)valueOffset);
    }

    @Override
    public long disposeValue(TieredStoreRecord record) {
        record.setValueAddress(0L);
        return 0L;
    }

    public int getMetadataOffset(TieredStoreRecord record) {
        int length = this.getTotalInlinedLength(record.address());
        return length - record.getMetadataSize();
    }

    @Override
    public long getSize(MemoryBlock memoryBlock) {
        if (memoryBlock == null || memoryBlock.address() == 0L) {
            return 0L;
        }
        return memoryBlock.size();
    }

    @Override
    public long getSize(long address, long expectedSize) {
        throw new UnsupportedOperationException();
    }

    public Data readKey(TieredStoreRecord record) {
        long keyAddress = TieredStoreRecordAccessor.readKeyAddress(record.address());
        if (keyAddress == 0L) {
            return null;
        }
        return new NativeMemoryData().reset(keyAddress);
    }

    public void setKey(Data key, TieredStoreRecord record) {
        long oldKeyAddress;
        int oldKeySize;
        if (key == null) {
            TieredStoreRecordAccessor.setKeyNull(record);
            return;
        }
        int keySize = key.totalSize();
        if (!TieredStoreRecordAccessor.isKeyNull(record.address()) && keySize != (oldKeySize = GlobalMemoryAccessorRegistry.AMEM.getInt(oldKeyAddress = record.address() + 12L))) {
            throw new HazelcastException("Cannot set key in TieredStoreRecord: key size mismatch");
        }
        long dstKeyAddress = record.address() + 12L;
        if (key instanceof NativeMemoryData) {
            NativeMemoryData nativeKey = (NativeMemoryData)key;
            GlobalMemoryAccessorRegistry.AMEM.copyMemory(nativeKey.address(), dstKeyAddress, nativeKey.size());
        } else {
            byte[] keyArray = key.toByteArray();
            GlobalMemoryAccessorRegistry.AMEM.putInt(dstKeyAddress, keyArray.length);
            GlobalMemoryAccessorRegistry.AMEM.copyFromByteArray(keyArray, 0, dstKeyAddress + 4L, keyArray.length);
        }
    }

    public static long readKeyAddress(long recordVAddress) {
        if (TieredStoreRecordAccessor.isKeyNull(recordVAddress)) {
            return 0L;
        }
        long keyAddress = recordVAddress + 12L;
        assert (GlobalMemoryAccessorRegistry.AMEM.getInt(keyAddress) > 0);
        return keyAddress;
    }

    @Override
    private long readValueAddress(long address) {
        if (TieredStoreRecordAccessor.isValueNull(address)) {
            return 0L;
        }
        int valueOffset = TieredStoreRecordAccessor.getValueOffset(address);
        return address + (long)valueOffset;
    }

    public boolean isDummy(TieredStoreRecord record) {
        long header = GlobalMemoryAccessorRegistry.AMEM.getLong(record.address() + 0L);
        return (header & Long.MIN_VALUE) != 0L;
    }

    public void setDummy(TieredStoreRecord record) {
        long header = GlobalMemoryAccessorRegistry.AMEM.getLong(record.address() + 0L);
        long newHeader = header | Long.MIN_VALUE;
        GlobalMemoryAccessorRegistry.AMEM.putLong(record.address() + 0L, newHeader);
    }

    public void setDummy(long logicalRecord) {
        assert (this.isInMemory(logicalRecord));
        long physicalAddress = this.asPhysicalAddress(logicalRecord);
        long header = GlobalMemoryAccessorRegistry.AMEM.getLong(physicalAddress + 0L);
        long newHeader = header | Long.MIN_VALUE;
        GlobalMemoryAccessorRegistry.AMEM.putLong(physicalAddress + 0L, newHeader);
    }

    public void setNotDummy(long logicalRecord) {
        assert (this.isInMemory(logicalRecord));
        long physicalAddress = this.asPhysicalAddress(logicalRecord);
        long header = GlobalMemoryAccessorRegistry.AMEM.getLong(physicalAddress + 0L);
        long newHeader = header & Long.MAX_VALUE;
        GlobalMemoryAccessorRegistry.AMEM.putLong(physicalAddress + 0L, newHeader);
    }

    public long getNext(TieredStoreRecord record) {
        return TieredStoreRecordAccessor.getNextRecordAddress(record.address());
    }

    public void setNext(TieredStoreRecord record, long logicalAddress) {
        TieredStoreRecordAccessor.setNextRecordAddress(record.address(), logicalAddress);
    }

    public static long getNextRecordAddress(long recordAddress) {
        long header = GlobalMemoryAccessorRegistry.AMEM.getLong(recordAddress + 0L);
        return header & 0x3FFFFFFFFFFFFFFFL;
    }

    public static long getNextRecordAddress(byte[] record) {
        long header = EndiannessUtil.readLong(ByteArrayAccessStrategy.INSTANCE, record, 0L, GlobalMemoryAccessorRegistry.AMEM.isBigEndian());
        return header & 0x3FFFFFFFFFFFFFFFL;
    }

    public static void setNextRecordAddress(long recordAddress, long nextRecordAddress) {
        long header = GlobalMemoryAccessorRegistry.AMEM.getLong(recordAddress + 0L);
        long newHeader = header & 0xC000000000000000L | nextRecordAddress;
        GlobalMemoryAccessorRegistry.AMEM.putLong(recordAddress + 0L, newHeader);
    }

    public static long keyHash64(byte[] record) {
        int keyLen = EndiannessUtil.readInt(ByteArrayAccessStrategy.INSTANCE, record, 12L, GlobalMemoryAccessorRegistry.AMEM.isBigEndian());
        return HashUtil.MurmurHash3_x64_64(record, 24, keyLen -= 8);
    }

    public static boolean keyEquals(byte[] record, Data key) {
        int keyLen = key.dataSize();
        int recordKeyLen = EndiannessUtil.readInt(ByteArrayAccessStrategy.INSTANCE, record, 12L, GlobalMemoryAccessorRegistry.AMEM.isBigEndian());
        if (keyLen != (recordKeyLen -= 8)) {
            return false;
        }
        int recordKeyOffset = 24;
        if (key instanceof HeapData) {
            byte[] keyBytes = key.toByteArray();
            int keyOffset = 8;
            for (int i = 0; i < keyLen; ++i) {
                if (keyBytes[keyOffset + i] == record[recordKeyOffset + i]) continue;
                return false;
            }
        } else {
            assert (key instanceof NativeMemoryData);
            long keyAddress = ((NativeMemoryData)key).address();
            long keyOffset = keyAddress + 12L;
            for (int i = 0; i < keyLen; ++i) {
                if (GlobalMemoryAccessorRegistry.MEM.getByte(keyOffset + (long)i) == record[recordKeyOffset + i]) continue;
                return false;
            }
        }
        return true;
    }

    public static void lockRecord(long recordPhysicalAddress) {
        long lockedHeader;
        long oldHeader;
        long unlockedHeader;
        while (!TieredStoreRecordAccessor.casHeader(recordPhysicalAddress, unlockedHeader = TieredStoreRecordAccessor.unlockedHeader(oldHeader = TieredStoreRecordAccessor.readHeader(recordPhysicalAddress)), lockedHeader = TieredStoreRecordAccessor.lockedHeader(oldHeader))) {
        }
        assert (TieredStoreRecordAccessor.isLocked(recordPhysicalAddress));
    }

    public static void unlockRecord(long recordPhysicalAddress) {
        assert (TieredStoreRecordAccessor.isLocked(recordPhysicalAddress));
        long oldHeader = TieredStoreRecordAccessor.readHeader(recordPhysicalAddress);
        long unlockedHeader = TieredStoreRecordAccessor.unlockedHeader(oldHeader);
        TieredStoreRecordAccessor.writeHeader(recordPhysicalAddress, unlockedHeader);
    }

    private static boolean casHeader(long recordPhysicalAddress, long expectedHeader, long value) {
        return GlobalMemoryAccessorRegistry.AMEM.compareAndSwapLong(recordPhysicalAddress + 0L, expectedHeader, value);
    }

    private static void writeHeader(long recordPhysicalAddress, long value) {
        GlobalMemoryAccessorRegistry.AMEM.putLongVolatile(recordPhysicalAddress + 0L, value);
    }

    private static long readHeader(long recordPhysicalAddress) {
        return GlobalMemoryAccessorRegistry.AMEM.getLongVolatile(recordPhysicalAddress + 0L);
    }

    private static boolean isLocked(long recordPhysicalAddress) {
        long header = TieredStoreRecordAccessor.readHeader(recordPhysicalAddress);
        return (header & 0x4000000000000000L) != 0L;
    }

    private static long lockedHeader(long header) {
        return header | 0x4000000000000000L;
    }

    private static long unlockedHeader(long header) {
        return header & 0xBFFFFFFFFFFFFFFFL;
    }

    public int getTotalInlinedLength(long recordAddress) {
        return GlobalMemoryAccessorRegistry.AMEM.getInt(recordAddress + 8L);
    }

    public void setTotalInlinedLength(long recordAddress, int length) {
        GlobalMemoryAccessorRegistry.AMEM.putInt(recordAddress + 8L, length);
    }

    public boolean isInMemory(TieredStoreRecord record) {
        return this.isInMemory(record.getLogicalAddress());
    }

    public boolean isInMemory(long logicalRecord) {
        return this.getHybridLog().isInMemory(logicalRecord);
    }

    public long asPhysicalAddress(long logicalAddress) {
        return this.getHybridLog().asPhysicalAddress(logicalAddress);
    }

    @Override
    public boolean isEqual(long address, TieredStoreRecord value) {
        return this.isEqual(address, value.address());
    }

    @Override
    public boolean isEqual(long vAddress1, long vAddress2) {
        long keyAddress2;
        if (vAddress1 == vAddress2) {
            return true;
        }
        if (vAddress1 == 0L || vAddress2 == 0L) {
            return false;
        }
        long keyAddress1 = TieredStoreRecordAccessor.readKeyAddress(vAddress1);
        if (NativeMemoryDataUtil.equals(keyAddress1, keyAddress2 = TieredStoreRecordAccessor.readKeyAddress(vAddress2))) {
            long valueAddress1 = this.readValueAddress(vAddress1);
            long valueAddress2 = this.readValueAddress(vAddress2);
            return NativeMemoryDataUtil.equals(valueAddress1, valueAddress2);
        }
        return false;
    }

    @Override
    public TieredStoreRecord read(long address) {
        throw new UnsupportedOperationException("Tiered store has to provide logical address");
    }

    public TieredStoreRecord read(long physicalAddress, long logicalAddress) {
        if (physicalAddress == 0L) {
            throw new IllegalArgumentException("Illegal memory address: " + physicalAddress);
        }
        TieredStoreRecord record = this.newRecord();
        record.reset(physicalAddress, logicalAddress, -1);
        return record;
    }

    @Override
    public long dispose(TieredStoreRecord record) {
        throw new UnsupportedOperationException("Hybrid log disposes records on compaction");
    }

    @Override
    public long dispose(long address) {
        throw new UnsupportedOperationException("Hybrid log disposes records on compaction");
    }

    private static boolean isValueNull(long recordVAddress) {
        int valueOffset = TieredStoreRecordAccessor.getValueOffset(recordVAddress);
        int valueSize = GlobalMemoryAccessorRegistry.AMEM.getInt(recordVAddress + (long)valueOffset);
        return valueSize == 0;
    }

    private static boolean isKeyNull(long recordVAddress) {
        int keySize = GlobalMemoryAccessorRegistry.AMEM.getInt(recordVAddress + 12L);
        return keySize == 0;
    }

    private static void setKeyNull(TieredStoreRecord record) {
        GlobalMemoryAccessorRegistry.AMEM.putInt(record.address() + 12L, 0);
    }

    private static void setValueNull(TieredStoreRecord record) {
        int valueOffset = TieredStoreRecordAccessor.getValueOffset(record.address());
        GlobalMemoryAccessorRegistry.AMEM.putInt(record.address() + (long)valueOffset, 0);
    }

    private static int getValueOffset(long recordVAddress) {
        int keySize = GlobalMemoryAccessorRegistry.AMEM.getInt(recordVAddress + 12L);
        assert (keySize > 0);
        return 16 + keySize;
    }

    public HybridLog getHybridLog() {
        return this.hybridLogRef.get();
    }

    public TieredStoreSlotAccessor getTieredStoreSlotAccessor() {
        return this.inMemorySlotAccessor;
    }

    public TieredStoreChunkAccessor getTieredStoreChunkAccessor() {
        return this.inMemoryChunkAccessor;
    }
}

