/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.record;

import com.hazelcast.internal.memory.GlobalMemoryAccessor;
import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.map.impl.record.HDRecord;
import com.hazelcast.map.impl.record.TieredStoreRecordAccessor;

public abstract class TieredStoreRecord
extends HDRecord {
    public static final int UNKNOWN_SIZE = -1;
    protected long logicalAddress;

    public TieredStoreRecord(GlobalMemoryAccessor memoryAccessor, TieredStoreRecordAccessor recordAccessor) {
        super(memoryAccessor, recordAccessor);
    }

    @Override
    TieredStoreRecordAccessor getRecordAccessor() {
        return (TieredStoreRecordAccessor)super.getRecordAccessor();
    }

    public abstract int getMetadataSize();

    protected int getMetadataOffset() {
        return this.getRecordAccessor().getMetadataOffset(this);
    }

    @Override
    public HDRecord reset(long address) {
        throw new UnsupportedOperationException("Logical address is not provided");
    }

    public TieredStoreRecord reset(long address, long logicalAddress, int size) {
        assert (size == -1 || size > 0);
        this.setAddress(address);
        this.logicalAddress = logicalAddress;
        if (size == -1) {
            this.setSize(this.getSizeInternal());
        } else {
            assert (size > 0);
            this.getRecordAccessor().setTotalInlinedLength(address, size);
            this.setSize(size);
        }
        return this;
    }

    public long getLogicalAddress() {
        return this.logicalAddress;
    }

    public Data getKey() {
        return this.getRecordAccessor().readKey(this);
    }

    public void setKey(Data key) {
        this.getRecordAccessor().setKey(key, this);
    }

    @Override
    protected int getSizeInternal() {
        return this.getRecordAccessor().getTotalInlinedLength(this.address());
    }

    public void setMetadata(TieredStoreRecord record) {
        assert (this.getClass().equals(record.getClass()));
        long srcAddress = record.address() + (long)record.getMetadataOffset();
        long dstAddress = this.address() + (long)this.getMetadataOffset();
        GlobalMemoryAccessorRegistry.AMEM.copyMemory(srcAddress, dstAddress, record.getMetadataSize());
    }

    public boolean isUpdatableInPlace(Data newValue) {
        this.getRecordAccessor();
        int oldValueSize = TieredStoreRecordAccessor.readValueSize(this);
        return oldValueSize > 0 && oldValueSize == newValue.totalSize();
    }

    public boolean isPending() {
        return false;
    }

    public final void setValueSafe(Data value) {
        this.lock();
        try {
            this.setValue(value);
        }
        finally {
            this.unlock();
        }
    }

    public void lock() {
        this.getRecordAccessor();
        TieredStoreRecordAccessor.lockRecord(this.address());
    }

    public void unlock() {
        this.getRecordAccessor();
        TieredStoreRecordAccessor.unlockRecord(this.address());
    }

    public boolean pin() {
        return this.getRecordAccessor().getHybridLog().pinAddress(this.logicalAddress);
    }

    public boolean isPinned() {
        return this.getRecordAccessor().getHybridLog().isAddressPinned(this.logicalAddress);
    }

    public void unpin() {
        this.getRecordAccessor().getHybridLog().unpinAddress(this.logicalAddress);
    }

    @Override
    public String toString() {
        String className = this.getClass().getSimpleName();
        return this.address() == 0L ? className + "{NULL}" : className + "{version: " + this.getVersion() + ", creationTime: " + this.getCreationTime() + ", lastAccessTime: " + this.getLastAccessTime() + ", lastUpdateTime: " + this.getLastUpdateTime() + ", lastStoredTime: " + this.getLastStoredTime() + ", hits: " + this.getHits() + ", sequence: " + this.getSequence() + ", logicalAddress: " + this.getLogicalAddress() + " }";
    }
}

