/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.record;

import com.hazelcast.internal.hidensity.impl.HDJsonMetadataRecordProcessor;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.DataType;
import com.hazelcast.map.impl.record.HDJsonMetadataRecord;
import com.hazelcast.map.impl.record.HDRecordFactory;
import com.hazelcast.memory.NativeOutOfMemoryError;
import com.hazelcast.query.impl.JsonMetadata;

public class HDJsonMetadataRecordFactory {
    private final HDJsonMetadataRecordProcessor recordProcessor;

    public HDJsonMetadataRecordFactory(HDJsonMetadataRecordProcessor recordProcessor) {
        this.recordProcessor = recordProcessor;
    }

    public HDJsonMetadataRecord newRecord(JsonMetadata metadata) {
        return this.newRecord(metadata, true, false);
    }

    public HDJsonMetadataRecord newRecord(Object metadataPart, boolean isKey) {
        return this.newRecord(metadataPart, false, isKey);
    }

    private HDJsonMetadataRecord newRecord(Object metadata, boolean isFullMetadata, boolean isKey) {
        Object keyMetadata;
        long address = 0L;
        Object object = isFullMetadata ? ((JsonMetadata)metadata).getKeyMetadata() : (keyMetadata = isKey ? metadata : null);
        Object valueMetadata = isFullMetadata ? ((JsonMetadata)metadata).getValueMetadata() : (isKey ? null : metadata);
        Data keyValue = null;
        Data dataValue = null;
        try {
            address = this.recordProcessor.allocate(16L);
            HDJsonMetadataRecord record = this.recordProcessor.newRecord();
            record.reset(address);
            if (keyMetadata != null) {
                keyValue = this.recordProcessor.toData(keyMetadata, DataType.NATIVE);
                record.setKey(keyValue);
            } else {
                record.setKey(null);
            }
            if (valueMetadata != null) {
                dataValue = this.recordProcessor.toData(valueMetadata, DataType.NATIVE);
                record.setValue(dataValue);
            } else {
                record.setValue(null);
            }
            return record;
        }
        catch (NativeOutOfMemoryError error) {
            if (!HDRecordFactory.isNull(keyValue)) {
                this.recordProcessor.disposeData(keyValue);
            }
            if (!HDRecordFactory.isNull(dataValue)) {
                this.recordProcessor.disposeData(dataValue);
            }
            if (address != 0L) {
                this.recordProcessor.dispose(address);
            }
            throw error;
        }
    }
}

