/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation.steps;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.mapstore.MapDataStore;
import com.hazelcast.map.impl.operation.steps.GetOpSteps;
import com.hazelcast.map.impl.operation.steps.IMapOpStep;
import com.hazelcast.map.impl.operation.steps.UtilSteps;
import com.hazelcast.map.impl.operation.steps.engine.State;
import com.hazelcast.map.impl.operation.steps.engine.Step;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.DefaultRecordStore;

public enum RemoveOpSteps implements IMapOpStep
{
    READ{

        @Override
        public void runStep(State state) {
            DefaultRecordStore recordStore = (DefaultRecordStore)state.getRecordStore();
            MapContainer mapContainer = recordStore.getMapContainer();
            MapServiceContext mapServiceContext = mapContainer.getMapServiceContext();
            GetOpSteps.READ.runStep(state);
            Object oldValue = state.getOldValue();
            if (oldValue != null) {
                oldValue = mapServiceContext.interceptRemove(mapContainer.getInterceptorRegistry(), oldValue);
                state.setOldValue(oldValue);
            }
        }

        @Override
        public Step nextStep(State state) {
            DefaultRecordStore recordStore = (DefaultRecordStore)state.getRecordStore();
            return !state.isRecordExistsInMemory() ? LOAD : (recordStore.persistenceEnabledFor(state.getCallerProvenance()) ? DELETE : UtilSteps.SEND_RESPONSE);
        }
    }
    ,
    LOAD{

        @Override
        public boolean isLoadStep() {
            return true;
        }

        @Override
        public void runStep(State state) {
            DefaultRecordStore recordStore = (DefaultRecordStore)state.getRecordStore();
            Object oldValue = recordStore.loadValueOf(state.getKey());
            state.setOldValue(oldValue);
        }

        @Override
        public Step nextStep(State state) {
            return state.getOldValue() == null ? UtilSteps.SEND_RESPONSE : DELETE;
        }
    }
    ,
    DELETE{

        @Override
        public boolean isStoreStep() {
            return true;
        }

        @Override
        public void runStep(State state) {
            Object oldValue = state.getOldValue();
            DefaultRecordStore recordStore = (DefaultRecordStore)state.getRecordStore();
            if (oldValue != null && recordStore.persistenceEnabledFor(state.getCallerProvenance())) {
                MapDataStore<Data, Object> mapDataStore = state.getRecordStore().getMapDataStore();
                mapDataStore.remove(state.getKey(), state.getNow(), state.getTxnId());
                recordStore.updateStatsOnRemove(state.getNow());
            }
        }

        public RemoveOpSteps nextStep(State state) {
            return ON_DELETE;
        }
    }
    ,
    ON_DELETE{

        @Override
        public void runStep(State state) {
            DefaultRecordStore recordStore = (DefaultRecordStore)state.getRecordStore();
            Record record = recordStore.getRecord(state.getKey());
            if (record == null) {
                return;
            }
            recordStore.removeRecord0(state.getKey(), record, false);
            recordStore.onStore(record);
        }

        @Override
        public Step nextStep(State state) {
            return UtilSteps.SEND_RESPONSE;
        }
    };

}

