/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.enterprise.wan.impl.operation.MerkleTreeNodeValueComparison;
import com.hazelcast.map.impl.EnterprisePartitionContainer;
import com.hazelcast.map.impl.operation.EnterpriseMapDataSerializerHook;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.ReadonlyOperation;
import com.hazelcast.wan.impl.merkletree.MerkleTree;
import com.hazelcast.wan.impl.merkletree.MerkleTreeUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MerkleTreeNodeCompareOperation
extends MapOperation
implements ReadonlyOperation {
    private MerkleTreeNodeValueComparison remoteNodes;
    private int[] responseDifferentNodeOrderHashPairs;

    public MerkleTreeNodeCompareOperation() {
    }

    public MerkleTreeNodeCompareOperation(String name, MerkleTreeNodeValueComparison remoteNodes) {
        super(name);
        this.remoteNodes = remoteNodes;
    }

    @Override
    protected void runInternal() {
        int[] remotePartitionNodes;
        int partitionId = this.getPartitionId();
        MerkleTree localMerkleTree = this.getMerkleTree(partitionId);
        int[] nArray = remotePartitionNodes = this.remoteNodes != null ? this.remoteNodes.getMerkleTreeNodeValues(partitionId) : new int[]{};
        if (remotePartitionNodes.length == 0) {
            int rootValue = localMerkleTree != null ? localMerkleTree.getNodeHash(0) : 0;
            this.responseDifferentNodeOrderHashPairs = new int[]{0, rootValue};
            return;
        }
        if (localMerkleTree == null) {
            this.responseDifferentNodeOrderHashPairs = null;
            return;
        }
        int localTreeDepth = localMerkleTree.depth();
        int remoteLevel = MerkleTreeUtil.getLevelOfNode(remotePartitionNodes[0]);
        if (remoteLevel > localTreeDepth - 1) {
            this.responseDifferentNodeOrderHashPairs = null;
            return;
        }
        this.responseDifferentNodeOrderHashPairs = this.compareTrees(localMerkleTree, remotePartitionNodes);
    }

    private MerkleTree getMerkleTree(int partitionId) {
        EnterprisePartitionContainer partitionContainer = (EnterprisePartitionContainer)this.mapServiceContext.getPartitionContainer(partitionId);
        return partitionContainer.getMerkleTreeOrNull(this.getName());
    }

    private int[] compareTrees(MerkleTree localMerkleTree, int[] remotePartitionNodes) {
        ArrayList<Integer> diffNodes = new ArrayList<Integer>();
        int localTreeDepth = localMerkleTree.depth();
        for (int idx = 0; idx < remotePartitionNodes.length; idx += 2) {
            int nodeOrder = remotePartitionNodes[idx];
            int nodeLevel = MerkleTreeUtil.getLevelOfNode(nodeOrder);
            int remoteNodeValue = remotePartitionNodes[idx + 1];
            int localNodeValue = localMerkleTree.getNodeHash(nodeOrder);
            if (localNodeValue == remoteNodeValue) continue;
            if (localTreeDepth - 1 == nodeLevel) {
                diffNodes.add(nodeOrder);
                diffNodes.add(localMerkleTree.getNodeHash(nodeOrder));
                continue;
            }
            int leftChildOrder = MerkleTreeUtil.getLeftChildOrder(nodeOrder);
            int rightChildOrder = MerkleTreeUtil.getRightChildOrder(nodeOrder);
            diffNodes.add(leftChildOrder);
            diffNodes.add(localMerkleTree.getNodeHash(leftChildOrder));
            diffNodes.add(rightChildOrder);
            diffNodes.add(localMerkleTree.getNodeHash(rightChildOrder));
        }
        return this.asArray(diffNodes);
    }

    private int[] asArray(List<Integer> nodeOrderHashPairs) {
        int[] nodeOrderHashPairsArr = new int[nodeOrderHashPairs.size()];
        for (int i = 0; i < nodeOrderHashPairs.size(); ++i) {
            nodeOrderHashPairsArr[i] = nodeOrderHashPairs.get(i);
        }
        return nodeOrderHashPairsArr;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public Object getResponse() {
        return this.responseDifferentNodeOrderHashPairs;
    }

    @Override
    public int getFactoryId() {
        return EnterpriseMapDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 1;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.remoteNodes);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.remoteNodes = (MerkleTreeNodeValueComparison)in.readObject();
    }
}

