/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.map.impl.EnterprisePartitionContainer;
import com.hazelcast.map.impl.operation.EnterpriseMapDataSerializerHook;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.ReadonlyOperation;
import com.hazelcast.wan.impl.merkletree.MerkleTree;
import com.hazelcast.wan.impl.merkletree.MerkleTreeUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;

public class MerkleTreeGetEntryCountOperation
extends MapOperation
implements ReadonlyOperation {
    private int[] merkleTreeNodeOrders;
    private int result;

    public MerkleTreeGetEntryCountOperation() {
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public MerkleTreeGetEntryCountOperation(String mapName, int[] merkleTreeNodeOrders) {
        super(mapName);
        this.merkleTreeNodeOrders = merkleTreeNodeOrders;
    }

    @Override
    protected void runInternal() {
        int partitionId = this.getPartitionId();
        EnterprisePartitionContainer partitionContainer = (EnterprisePartitionContainer)this.mapServiceContext.getPartitionContainer(partitionId);
        MerkleTree localMerkleTree = partitionContainer.getMerkleTreeOrNull(this.getName());
        if (localMerkleTree == null || this.merkleTreeNodeOrders == null || this.merkleTreeNodeOrders.length == 0) {
            this.result = 0;
            return;
        }
        BitSet nodeOrderBitSet = new BitSet(Arrays.stream(this.merkleTreeNodeOrders).max().getAsInt());
        for (int order : this.merkleTreeNodeOrders) {
            nodeOrderBitSet.set(order);
        }
        int levelOfRequestedNodes = MerkleTreeUtil.getLevelOfNode(this.merkleTreeNodeOrders[0]);
        this.recordStore.iterator().forEachRemaining(entry -> {
            int keyHash = ((Data)entry.getKey()).hashCode();
            int currentKeyNodeOrder = MerkleTreeUtil.getLeafOrderForHash(keyHash, levelOfRequestedNodes);
            if (nodeOrderBitSet.get(currentKeyNodeOrder)) {
                ++this.result;
            }
        });
    }

    @Override
    public Object getResponse() {
        return this.result;
    }

    @Override
    public int getFactoryId() {
        return EnterpriseMapDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 4;
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.merkleTreeNodeOrders = in.readIntArray();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeIntArray(this.merkleTreeNodeOrders);
    }
}

