/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.map.impl.EnterprisePartitionContainer;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.AllowedDuringPassiveState;
import com.hazelcast.wan.impl.merkletree.MerkleTree;
import java.io.IOException;

public class MapMerkleTreeRebuildOperation
extends MapOperation
implements AllowedDuringPassiveState {
    public MapMerkleTreeRebuildOperation() {
    }

    public MapMerkleTreeRebuildOperation(String mapName) {
        super(mapName);
    }

    @Override
    protected void runInternal() {
        ThreadUtil.assertRunningOnPartitionThread();
        int partitionId = this.getPartitionId();
        String mapName = this.getName();
        MerkleTree merkleTree = this.getMerkleTree(partitionId, mapName);
        merkleTree.clear();
        SerializationService serializationService = this.getNodeEngine().getSerializationService();
        RecordStore recordStore = this.mapServiceContext.getRecordStore(partitionId, mapName);
        recordStore.forEach((dataKey, record) -> merkleTree.updateAdd(dataKey, serializationService.toData(record.getValue())), this.getReplicaIndex() != 0);
    }

    private MerkleTree getMerkleTree(int partitionId, String mapName) {
        EnterprisePartitionContainer partitionContainer = (EnterprisePartitionContainer)this.mapServiceContext.getPartitionContainer(partitionId);
        return partitionContainer.getMerkleTreeOrNull(mapName);
    }

    @Override
    public int getFactoryId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getClassId() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        throw new UnsupportedOperationException();
    }
}

