/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.core.MemberLeftException;
import com.hazelcast.internal.merkletree.MerkleTreeCompareOperation;
import com.hazelcast.internal.partition.MigrationCycleOperation;
import com.hazelcast.internal.partition.impl.MerkleTreeComparisonResponse;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.EnterprisePartitionContainer;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.operation.EnterpriseMapDataSerializerHook;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.impl.operationservice.ExceptionAction;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.ReadonlyOperation;
import com.hazelcast.wan.impl.merkletree.MerkleTree;
import com.hazelcast.wan.impl.merkletree.MerkleTreeUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MapMerkleTreePartitionCompareOperation
extends Operation
implements ReadonlyOperation,
MigrationCycleOperation,
IdentifiedDataSerializable,
MerkleTreeCompareOperation {
    private Map<String, int[]> remoteNodes;
    private Object response;
    private transient MapService mapService;
    private transient MapServiceContext mapServiceContext;

    @Override
    public void initialize(Map<String, int[]> initialState) {
        this.remoteNodes = initialState;
    }

    @Override
    public void run() throws Exception {
        try {
            this.mapService = (MapService)this.getService();
            this.mapServiceContext = this.mapService.getMapServiceContext();
            Set<String> keySet = this.remoteNodes.keySet();
            HashMap<String, MerkleTreeComparisonResponse> map = new HashMap<String, MerkleTreeComparisonResponse>(keySet.size());
            for (String mapName : keySet) {
                map.put(mapName, this.compareSingleMap(mapName, this.mapServiceContext.getRecordStore(this.getPartitionId(), mapName)));
            }
            ILogger logger = this.getLogger();
            if (logger.isFineEnabled()) {
                logger.fine("Merkle tree comparison result is: " + map + ", partitionId=" + this.getPartitionId());
            }
            this.response = map;
        }
        catch (Throwable t) {
            this.response = t;
            throw ExceptionUtil.sneakyThrow(t);
        }
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    private MerkleTreeComparisonResponse compareSingleMap(String mapName, RecordStore recordStore) {
        int partitionId = this.getPartitionId();
        if (recordStore == null || recordStore.size() == 0) {
            this.getLogger().fine("Merkle tree comparison with empty record store: " + this.response + ", partitionId=" + this.getPartitionId());
            return new MerkleTreeComparisonResponse(true);
        }
        MerkleTree localMerkleTree = this.getMerkleTree(partitionId, mapName);
        int[] remotePartitionNodes = this.remoteNodes.get(mapName);
        if (remotePartitionNodes.length == 0) {
            int rootValue = localMerkleTree != null ? localMerkleTree.getNodeHash(0) : 0;
            this.getLogger().fine("Merkle tree comparison returned root: " + this.response + ", partitionId=" + this.getPartitionId());
            return new MerkleTreeComparisonResponse(new int[]{0, rootValue});
        }
        if (localMerkleTree == null) {
            this.getLogger().fine("Merkle tree comparison: response is null, partitionId=" + this.getPartitionId());
            return new MerkleTreeComparisonResponse(true);
        }
        int localTreeDepth = localMerkleTree.depth();
        int remoteLevel = MerkleTreeUtil.getLevelOfNode(remotePartitionNodes[0]);
        if (remoteLevel > localTreeDepth - 1) {
            this.getLogger().fine("Merkle tree comparison: response is null because the remote level is deeper than this, partitionId=" + this.getPartitionId());
            return new MerkleTreeComparisonResponse(true);
        }
        this.getLogger().fine("Merkle tree comparison result is: " + this.response + ", partitionId=" + this.getPartitionId());
        return new MerkleTreeComparisonResponse(this.compareTrees(localMerkleTree, remotePartitionNodes));
    }

    private MerkleTree getMerkleTree(int partitionId, String mapName) {
        EnterprisePartitionContainer partitionContainer = (EnterprisePartitionContainer)this.mapServiceContext.getPartitionContainer(partitionId);
        return partitionContainer.getMerkleTreeOrNull(mapName);
    }

    private int[] compareTrees(MerkleTree localMerkleTree, int[] remotePartitionNodes) {
        ArrayList<Integer> diffNodes = new ArrayList<Integer>();
        int localTreeDepth = localMerkleTree.depth();
        for (int idx = 0; idx < remotePartitionNodes.length; idx += 2) {
            int nodeOrder = remotePartitionNodes[idx];
            int nodeLevel = MerkleTreeUtil.getLevelOfNode(nodeOrder);
            int remoteNodeValue = remotePartitionNodes[idx + 1];
            int localNodeValue = localMerkleTree.getNodeHash(nodeOrder);
            if (localNodeValue == remoteNodeValue) continue;
            if (localTreeDepth - 1 == nodeLevel) {
                diffNodes.add(nodeOrder);
                diffNodes.add(localMerkleTree.getNodeHash(nodeOrder));
                continue;
            }
            int leftChildOrder = MerkleTreeUtil.getLeftChildOrder(nodeOrder);
            int rightChildOrder = MerkleTreeUtil.getRightChildOrder(nodeOrder);
            diffNodes.add(leftChildOrder);
            diffNodes.add(localMerkleTree.getNodeHash(leftChildOrder));
            diffNodes.add(rightChildOrder);
            diffNodes.add(localMerkleTree.getNodeHash(rightChildOrder));
        }
        return this.asArray(diffNodes);
    }

    private int[] asArray(List<Integer> nodeOrderHashPairs) {
        int[] nodeOrderHashPairsArr = new int[nodeOrderHashPairs.size()];
        for (int i = 0; i < nodeOrderHashPairs.size(); ++i) {
            nodeOrderHashPairsArr[i] = nodeOrderHashPairs.get(i);
        }
        return nodeOrderHashPairsArr;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        SerializationUtil.writeMap(this.remoteNodes, out);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.remoteNodes = SerializationUtil.readMap(in);
    }

    @Override
    public int getFactoryId() {
        return EnterpriseMapDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 9;
    }

    @Override
    public ExceptionAction onInvocationException(Throwable throwable) {
        if (throwable instanceof MemberLeftException || throwable instanceof TargetNotMemberException) {
            return ExceptionAction.THROW_EXCEPTION;
        }
        return super.onInvocationException(throwable);
    }
}

