/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.config.MapConfig;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.partition.ChunkSupplier;
import com.hazelcast.internal.partition.ChunkSuppliers;
import com.hazelcast.internal.partition.OffloadedReplicationPreparation;
import com.hazelcast.internal.partition.PartitionReplicationEvent;
import com.hazelcast.internal.partition.impl.MerkleTreePartitionComparisonOperation;
import com.hazelcast.internal.services.ObjectNamespace;
import com.hazelcast.internal.services.ServiceNamespace;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.EnterpriseMapChunkSupplier;
import com.hazelcast.map.impl.MapMigrationAwareService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.operation.EnterpriseMapReplicationOperation;
import com.hazelcast.map.impl.operation.MapMerkleTreePartitionCompareOperation;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nullable;

class EnterpriseMapMigrationAwareService
extends MapMigrationAwareService
implements OffloadedReplicationPreparation {
    private final ILogger logger;

    EnterpriseMapMigrationAwareService(MapServiceContext mapServiceContext) {
        super(mapServiceContext);
        this.logger = mapServiceContext.getNodeEngine().getLogger(EnterpriseMapMigrationAwareService.class);
    }

    @Override
    public ChunkSupplier newChunkSupplier(PartitionReplicationEvent event, Collection<ServiceNamespace> namespaces) {
        if (ThreadUtil.isRunningOnPartitionThread()) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest(String.format("Preparing map replication operation on partition thread cannot use differential sync, partitionId %d / replicaIndex %d", event.getPartitionId(), event.getReplicaIndex()));
            }
            return super.newChunkSupplier(event, namespaces);
        }
        Map<String, int[]> mapNamesToMerkleDiff = this.determineDiff(event, namespaces);
        if (this.logger.isFinestEnabled()) {
            this.logger.finest(String.format("Using Merkle tree diff for %s, namespaces were %s on partition ID %d,  replica index %d", mapNamesToMerkleDiff == null ? "-" : mapNamesToMerkleDiff.keySet(), namespaces, event.getPartitionId(), event.getReplicaIndex()));
        }
        ArrayList<ChunkSupplier> chain = new ArrayList<ChunkSupplier>(namespaces.size());
        for (ServiceNamespace namespace : namespaces) {
            String mapName = ((ObjectNamespace)namespace).getObjectName();
            chain.add(new EnterpriseMapChunkSupplier(this.mapServiceContext, namespace, event.getPartitionId(), event.getReplicaIndex(), mapNamesToMerkleDiff == null ? null : mapNamesToMerkleDiff.get(mapName)));
        }
        return ChunkSuppliers.newChainedChunkSupplier(chain);
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event, Collection<ServiceNamespace> namespaces) {
        assert (this.assertAllKnownNamespaces(namespaces));
        if (ThreadUtil.isRunningOnPartitionThread()) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest(String.format("Preparing map replication operation on partition thread cannot use differential sync, partitionId %d / replicaIndex %d", event.getPartitionId(), event.getReplicaIndex()));
            }
            return super.prepareReplicationOperation(event, namespaces);
        }
        if (this.mapServiceContext.getNodeEngine().getClusterService().getClusterVersion().isLessOrEqual(Versions.V4_2)) {
            return super.prepareReplicationOperation(event, namespaces);
        }
        assert (!ThreadUtil.isRunningOnPartitionThread());
        Map<String, int[]> mapNamesToMerkleDiff = this.determineDiff(event, namespaces);
        if (this.logger.isFinestEnabled()) {
            this.logger.finest(String.format("Using Merkle tree diff for %s, namespaces were %s on partition ID %d,  replica index %d", mapNamesToMerkleDiff == null ? "-" : mapNamesToMerkleDiff.keySet(), namespaces, event.getPartitionId(), event.getReplicaIndex()));
        }
        int partitionId = event.getPartitionId();
        EnterpriseMapReplicationOperation operation = new EnterpriseMapReplicationOperation(this.containers[partitionId], namespaces, partitionId, event.getReplicaIndex(), mapNamesToMerkleDiff);
        operation.setService(this.mapServiceContext.getService());
        operation.setNodeEngine(this.mapServiceContext.getNodeEngine());
        return operation;
    }

    @Override
    public boolean shouldOffload() {
        return true;
    }

    @Nullable
    private Map<String, int[]> determineDiff(PartitionReplicationEvent event, Collection<ServiceNamespace> namespaces) {
        Map<String, int[]> mapNamesToMerkleDiff = null;
        if (event.getTarget() != null) {
            HashSet<String> mapNames = new HashSet<String>();
            Collection<ServiceNamespace> namespacesWithMerkleEnabled = this.containers[event.getPartitionId()].getNamespaces(mapConfig -> this.mapServiceContext.shouldEnableMerkleTree((MapConfig)mapConfig, false), event.getReplicaIndex());
            namespacesWithMerkleEnabled.retainAll(namespaces);
            namespacesWithMerkleEnabled.forEach(namespace -> mapNames.add(((ObjectNamespace)namespace).getObjectName()));
            if (!mapNames.isEmpty()) {
                mapNamesToMerkleDiff = MerkleTreePartitionComparisonOperation.syncGetPartitionMerkleDiff(this.mapServiceContext.getNodeEngine(), this.logger, "hz:impl:mapService", event, mapNames, MapMerkleTreePartitionCompareOperation.class.getName());
            }
        }
        if (mapNamesToMerkleDiff != null && !mapNamesToMerkleDiff.isEmpty()) {
            mapNamesToMerkleDiff.entrySet().removeIf(entry -> entry.getValue() == MerkleTreePartitionComparisonOperation.FULL_SYNC);
        }
        return mapNamesToMerkleDiff;
    }
}

