/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.config.Config;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MerkleTreeConfig;
import com.hazelcast.internal.hidensity.HiDensityRecordProcessor;
import com.hazelcast.internal.hidensity.HiDensityStorageInfo;
import com.hazelcast.internal.hidensity.impl.DefaultHiDensityRecordProcessor;
import com.hazelcast.internal.hidensity.impl.TieredStoreRecordProcessor;
import com.hazelcast.internal.partition.IPartitionService;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.ConstructorFunction;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.eviction.Evictor;
import com.hazelcast.map.impl.eviction.HDEvictionChecker;
import com.hazelcast.map.impl.eviction.HDEvictorImpl;
import com.hazelcast.map.impl.record.HDMapRecordAccessor;
import com.hazelcast.map.impl.record.HDRecord;
import com.hazelcast.map.impl.record.HDRecordFactory;
import com.hazelcast.map.impl.record.RecordFactory;
import com.hazelcast.map.impl.record.RecordFactoryAttributes;
import com.hazelcast.map.impl.record.TieredStoreRecordAccessor;
import com.hazelcast.map.impl.record.TieredStoreRecordFactory;
import com.hazelcast.spi.eviction.EvictionPolicyComparator;
import com.hazelcast.spi.impl.NodeEngine;
import java.util.concurrent.atomic.AtomicBoolean;

public class EnterpriseMapContainer
extends MapContainer {
    private final AtomicBoolean implicitMerkleTreeEnableLogged = new AtomicBoolean();
    private HiDensityStorageInfo hdStorageInfo;

    EnterpriseMapContainer(String name, Config config, MapServiceContext mapServiceContext) {
        super(name, config, mapServiceContext);
        this.logMerkleTreeInfoIfEnabled();
    }

    @Override
    public void init() {
        this.hdStorageInfo = new HiDensityStorageInfo(this.name);
        super.init();
    }

    @Override
    protected Evictor newEvictor(EvictionPolicyComparator evictionPolicyComparator, int evictionBatchSize, IPartitionService partitionService) {
        if (InMemoryFormat.NATIVE == this.mapConfig.getInMemoryFormat()) {
            return new HDEvictorImpl(evictionPolicyComparator, new HDEvictionChecker(EnterpriseMapContainer.getMemoryInfoAccessor(), this.mapServiceContext), evictionBatchSize, partitionService, this.hdStorageInfo, this.mapServiceContext.getNodeEngine().getLogger(HDEvictorImpl.class));
        }
        return super.newEvictor(evictionPolicyComparator, evictionBatchSize, partitionService);
    }

    @Override
    ConstructorFunction<RecordFactoryAttributes, RecordFactory> createRecordFactoryConstructor(SerializationService serializationService) {
        if (this.mapConfig.getTieredStoreConfig().isEnabled()) {
            return arg -> new TieredStoreRecordFactory(this, this.createTieredStoreRecordProcessor((RecordFactoryAttributes)arg));
        }
        if (InMemoryFormat.NATIVE == this.mapConfig.getInMemoryFormat()) {
            return anyArg -> new HDRecordFactory(this, this.createHiDensityRecordProcessor());
        }
        return super.createRecordFactoryConstructor(serializationService);
    }

    void logMerkleTreeImplicitlyEnabled(ILogger logger) {
        if (this.implicitMerkleTreeEnableLogged.compareAndSet(false, true)) {
            logger.info("Enabling MerkleTreeConfig for map \"" + this.name + "\", as it enhances member recovery performance. Consider enabling MerkleTreeConfig explicitly in your configuration.");
        }
    }

    private void logMerkleTreeInfoIfEnabled() {
        MerkleTreeConfig mapMerkleTreeConfig = this.mapConfig.getMerkleTreeConfig();
        if (this.mapServiceContext.shouldEnableMerkleTree(this.mapConfig, false)) {
            ILogger logger = this.mapServiceContext.getNodeEngine().getLogger(EnterpriseMapContainer.class);
            logger.fine("Using Merkle trees with depth " + mapMerkleTreeConfig.getDepth() + " for map " + this.name);
        }
    }

    private TieredStoreRecordProcessor createTieredStoreRecordProcessor(RecordFactoryAttributes attributes) {
        NodeEngine nodeEngine = this.mapServiceContext.getNodeEngine();
        EnterpriseSerializationService ss = (EnterpriseSerializationService)nodeEngine.getSerializationService();
        TieredStoreRecordAccessor recordAccessor = new TieredStoreRecordAccessor(ss, this, attributes.getPartitionId());
        return new TieredStoreRecordProcessor(ss, recordAccessor, this.hdStorageInfo);
    }

    private HiDensityRecordProcessor<HDRecord> createHiDensityRecordProcessor() {
        NodeEngine nodeEngine = this.mapServiceContext.getNodeEngine();
        EnterpriseSerializationService ss = (EnterpriseSerializationService)nodeEngine.getSerializationService();
        HDMapRecordAccessor recordAccessor = new HDMapRecordAccessor(ss, this);
        return new DefaultHiDensityRecordProcessor<HDRecord>(ss, recordAccessor, ss.getMemoryManager(), this.hdStorageInfo);
    }

    public HiDensityStorageInfo getHDStorageInfo() {
        return this.hdStorageInfo;
    }

    @Override
    public void onDestroy() {
        if (this.wanReplicationDelegate != null) {
            this.wanReplicationDelegate.destroyMapData(this.name);
        }
    }
}

