/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.map.impl.EnterpriseMapServiceContext;
import com.hazelcast.map.impl.EnterprisePartitionContainer;
import com.hazelcast.map.impl.LocalMapStatsProvider;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.wan.impl.merkletree.MerkleTree;

class EnterpriseLocalMapStatsProvider
extends LocalMapStatsProvider {
    EnterpriseLocalMapStatsProvider(MapServiceContext mapServiceContext) {
        super(mapServiceContext);
    }

    @Override
    protected void addStructureStats(String mapName, LocalMapStatsProvider.LocalMapOnDemandCalculatedStats onDemandStats) {
        super.addStructureStats(mapName, onDemandStats);
        this.updateMerkleTreeStats(mapName, onDemandStats);
    }

    private void updateMerkleTreeStats(String mapName, LocalMapStatsProvider.LocalMapOnDemandCalculatedStats onDemandStats) {
        EnterpriseMapServiceContext mapServiceContext = (EnterpriseMapServiceContext)this.getMapServiceContext();
        for (PartitionContainer container : mapServiceContext.getPartitionContainers()) {
            EnterprisePartitionContainer partitionContainer = (EnterprisePartitionContainer)container;
            MerkleTree merkleTree = partitionContainer.getMerkleTreeOrNull(mapName);
            if (merkleTree == null) continue;
            onDemandStats.incrementHeapCost(merkleTree.footprint());
            onDemandStats.incrementMerkleTreesCost(merkleTree.footprint());
        }
    }
}

