/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.license.extractor;

import com.hazelcast.license.domain.Feature;
import com.hazelcast.license.domain.License;
import com.hazelcast.license.domain.LicenseType;
import com.hazelcast.license.domain.LicenseVersion;
import com.hazelcast.license.exception.InvalidLicenseException;
import com.hazelcast.license.util.LicenseHelper;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

public class LicenseExtractorV5 {
    public static final int RESERVED = 43;

    public static License extractLicense(String licenseKey) throws InvalidLicenseException {
        char r;
        if (licenseKey == null || licenseKey.isEmpty()) {
            throw new InvalidLicenseException("License key can not be empty.");
        }
        String[] keyTokens = licenseKey.split("#");
        char[] originalKey = keyTokens[keyTokens.length - 1].toCharArray();
        if (LicenseHelper.lengthV5 != originalKey.length) {
            throw new InvalidLicenseException("Invalid License Key!");
        }
        char[] key = new char[LicenseHelper.lengthV5];
        System.arraycopy(originalKey, 0, key, 0, LicenseHelper.lengthV5);
        char fp = key[42];
        key[42] = '\u0000';
        char lp = key[43];
        key[43] = '\u0000';
        char[] hash = LicenseHelper.hash(key);
        if (hash[0] != fp || hash[hash.length - 1] != lp) {
            throw new InvalidLicenseException("Invalid License Key!");
        }
        int ix = 0;
        boolean isTrial = key[LicenseExtractorV5.ix0(r = key[ix++])] == '1';
        char t = key[ix++];
        char type = key[LicenseExtractorV5.ix0(t)];
        LicenseType licenseType = null;
        switch (type) {
            case '0': {
                licenseType = LicenseType.MANAGEMENT_CENTER;
                break;
            }
            case '1': {
                licenseType = LicenseType.ENTERPRISE;
                break;
            }
            case '2': {
                licenseType = LicenseType.ENTERPRISE_SECURITY_ONLY;
                break;
            }
            case '3': {
                licenseType = LicenseType.ENTERPRISE_HD;
            }
        }
        char d0 = key[ix++];
        char d1 = key[ix++];
        int day = LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(d0)]) * 10 + LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(d1)]);
        char m0 = key[ix++];
        char m1 = key[ix++];
        int month = LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(m0)]) * 10 + LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(m1)]);
        char y0 = key[ix++];
        char y1 = key[ix++];
        int year = 2000 + LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(y0)]) * 10 + LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(y1)]);
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, day);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        Date expiryDate = cal.getTime();
        char n0 = key[ix++];
        char n1 = key[ix++];
        char n2 = key[ix++];
        char n3 = key[ix++];
        int nodes = LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(n0)]) * 1000 + LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(n1)]) * 100 + LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(n2)]) * 10 + LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(n3)]);
        char l0 = key[ix++];
        char l1 = key[ix++];
        char l2 = key[ix++];
        char l3 = key[ix++];
        int hazelcastVersion = LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(l0)]) == 1 ? LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(l1)]) * 100 + LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(l2)]) * 10 + LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(l3)]) : LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(l1)]) * 10 + LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(l2)]);
        char oem = key[ix++];
        boolean isOem = key[LicenseExtractorV5.ix0(oem)] == '1';
        char g1 = key[ix++];
        char g2 = key[ix++];
        int gracePeriod = LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(g1)]) * 10 + LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(g2)]);
        char cm1 = key[ix++];
        char cm2 = key[ix++];
        int monthDiffCreationAndExpiryDates = LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(cm1)]) * 10 + LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(cm2)]);
        Date creationDate = LicenseHelper.generateCreationDateFromExpiryDate(monthDiffCreationAndExpiryDates, expiryDate);
        char s1 = key[ix++];
        char s2 = key[ix++];
        char s3 = key[ix++];
        char s4 = key[ix++];
        char s5 = key[ix++];
        License license = new License(0, licenseKey, null, creationDate, expiryDate, isTrial, null, null, nodes, 99999999, licenseType, hazelcastVersion, isOem, gracePeriod);
        license.setVersion(LicenseVersion.V5);
        char f0 = key[ix++];
        char f1 = key[ix++];
        char f2 = key[ix++];
        char f3 = key[ix++];
        char f4 = key[ix++];
        char f5 = key[ix++];
        char f6 = key[ix++];
        char f7 = key[ix++];
        char f8 = key[ix++];
        char f9 = key[ix++];
        char f10 = key[ix++];
        char f11 = key[ix++];
        char f12 = key[ix++];
        char f13 = key[ix++];
        char f14 = key[ix++];
        char f15 = key[ix++];
        ArrayList<Feature> featureList = new ArrayList<Feature>();
        if (LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(f0)]) == 1) {
            featureList.add(Feature.MAN_CENTER);
        }
        if (LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(f1)]) == 1) {
            featureList.add(Feature.CLUSTERED_JMX);
        }
        if (LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(f2)]) == 1) {
            featureList.add(Feature.CLUSTERED_REST);
        }
        if (LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(f3)]) == 1) {
            featureList.add(Feature.SECURITY);
        }
        if (LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(f4)]) == 1) {
            featureList.add(Feature.WAN);
        }
        if (LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(f5)]) == 1) {
            featureList.add(Feature.HD_MEMORY);
        }
        if (LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(f6)]) == 1) {
            featureList.add(Feature.PERSISTENCE);
        }
        if (LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(f7)]) == 1) {
            featureList.add(Feature.ROLLING_UPGRADE);
        }
        if (LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(f8)]) == 1) {
            featureList.add(Feature.STREAMING_MAN_CENTER);
        }
        if (LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(f9)]) == 1) {
            featureList.add(Feature.STREAMING_LOSSLESS_CLUSTER_RESTART);
        }
        if (LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(f10)]) == 1) {
            featureList.add(Feature.STREAMING_JOB_UPGRADES);
        }
        if (LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(f11)]) == 1) {
            featureList.add(Feature.STREAMING_ENTERPRISE);
        }
        if (LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(f12)]) == 1) {
            featureList.add(Feature.CLIENT_FILTERING);
        }
        if (LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(f13)]) == 1) {
            featureList.add(Feature.CP_PERSISTENCE);
        }
        if (LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(f14)]) == 1) {
            featureList.add(Feature.DYNAMIC_CONFIGURATION);
        }
        license.setFeatures(featureList);
        return license;
    }

    private static int ix0(char c) {
        return LicenseExtractorV5.ix(LicenseHelper.charsV5, c);
    }

    private static int ix1(char c) {
        return LicenseExtractorV5.ix(LicenseHelper.digits, c);
    }

    private static int ix(char[] cc, char c) {
        for (int i = 0; i < cc.length; ++i) {
            if (c != cc[i]) continue;
            return i;
        }
        return -1;
    }
}

