/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.service.impl;

import com.hazelcast.config.DeviceConfig;
import com.hazelcast.config.LocalDeviceConfig;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsCollectionContext;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeUnit;
import com.hazelcast.internal.partition.InternalPartitionService;
import com.hazelcast.internal.tstore.device.DeviceMetrics;
import com.hazelcast.internal.tstore.hybridlog.impl.HybridLogImpl;
import com.hazelcast.internal.tstore.hybridlog.impl.HybridLogImplMetrics;
import com.hazelcast.map.impl.EnterpriseMapServiceContext;
import com.hazelcast.map.impl.EnterprisePartitionContainer;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.query.impl.InternalIndex;
import com.hazelcast.query.impl.TSGlobalIndexImpl;
import java.io.File;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TieredStoreServiceImplMetrics {
    private final ConcurrentMap<String, PerMapMetrics> perMapMetricsMap = new ConcurrentHashMap<String, PerMapMetrics>();
    private final ConcurrentMap<String, PerDeviceMetrics> perDeviceMetricsMap = new ConcurrentHashMap<String, PerDeviceMetrics>();
    private final PerMemberMetrics perMemberMetrics = new PerMemberMetrics();

    public PerMemberMetrics getPerMemberMetrics() {
        return this.perMemberMetrics;
    }

    void registerMap(String mapName) {
        this.perMapMetricsMap.computeIfAbsent(mapName, x$0 -> new PerMapMetrics((String)x$0));
    }

    void registerDevice(DeviceConfig deviceConfig) {
        this.perDeviceMetricsMap.computeIfAbsent(deviceConfig.getName(), k -> new PerDeviceMetrics(deviceConfig));
    }

    void clear() {
        this.perMapMetricsMap.clear();
        this.perDeviceMetricsMap.clear();
    }

    void provideDynamicMetrics(MetricDescriptor descriptor, MetricsCollectionContext context, Node node) {
        this.perMapMetricsMap.keySet().forEach(k -> this.provideMapHybridLogMetrics(descriptor, context, (String)k, node));
        this.perDeviceMetricsMap.values().forEach(m -> ((PerDeviceMetrics)m).collect(descriptor, context));
        this.perMemberMetrics.collect(descriptor, context);
    }

    private void provideMapHybridLogMetrics(MetricDescriptor descriptor, MetricsCollectionContext context, String mapName, Node node) {
        if (!node.isRunning()) {
            return;
        }
        String deviceName = node.getConfig().getMapConfigs().get(mapName).getTieredStoreConfig().getDiskTierConfig().getDeviceName();
        InternalPartitionService partitionService = node.getNodeEngine().getPartitionService();
        MapService mapService = (MapService)node.getNodeEngine().getService("hz:impl:mapService");
        MapContainer mapContainer = mapService.getMapServiceContext().getMapContainer(mapName);
        EnterpriseMapServiceContext mapServiceContext = (EnterpriseMapServiceContext)mapService.getMapServiceContext();
        PerDeviceMetrics perDeviceMetrics = (PerDeviceMetrics)this.perDeviceMetricsMap.get(deviceName);
        PerMapMetrics perMapMetrics = (PerMapMetrics)this.perMapMetricsMap.get(mapName);
        TieredStoreServiceImplMetrics.provideFromPartitions(mapName, descriptor, context, perMapMetrics, partitionService, mapServiceContext);
        TieredStoreServiceImplMetrics.provideFromIndexes(mapName, descriptor, context, perMapMetrics, mapContainer);
        perMapMetrics.collect(descriptor, context, this.perMemberMetrics, perDeviceMetrics);
    }

    private static void provideFromPartitions(String mapName, MetricDescriptor descriptor, MetricsCollectionContext context, PerMapMetrics metric, InternalPartitionService partitionService, EnterpriseMapServiceContext mapServiceContext) {
        for (int partition = 0; partition < partitionService.getPartitionCount(); ++partition) {
            EnterprisePartitionContainer partitionContainer = (EnterprisePartitionContainer)mapServiceContext.getPartitionContainer(partition);
            HybridLogImpl hybridLog = (HybridLogImpl)partitionContainer.getHybridLogOrNull(mapName);
            if (hybridLog == null) continue;
            HybridLogImplMetrics hybridLogMetrics = hybridLog.getMetrics();
            DeviceMetrics deviceMetrics = hybridLog.getDevice().getMetrics();
            metric.aggregate(deviceMetrics.getDeviceUsage(), hybridLogMetrics.getHybridLogLengthTotal() - deviceMetrics.getDeletedSizeTotal());
            if (!partitionService.isPartitionOwner(partition)) continue;
            MetricDescriptor descriptorCopy = descriptor.copy().withDiscriminator("name", mapName).withPrefix("map").withTag("partition", Integer.toString(partition));
            context.collect(descriptorCopy, hybridLogMetrics);
        }
    }

    private static void provideFromIndexes(String mapName, MetricDescriptor descriptor, MetricsCollectionContext context, PerMapMetrics metric, MapContainer mapContainer) {
        for (InternalIndex index : mapContainer.getIndexes().getIndexes()) {
            TSGlobalIndexImpl tsIndex = (TSGlobalIndexImpl)index;
            String indexName = tsIndex.getName();
            HybridLogImpl hybridLog = (HybridLogImpl)tsIndex.getGlobalIndexHybridLog();
            HybridLogImplMetrics hybridLogMetrics = hybridLog.getMetrics();
            DeviceMetrics deviceMetrics = hybridLog.getDevice().getMetrics();
            metric.aggregate(deviceMetrics.getDeviceUsage(), hybridLogMetrics.getHybridLogLengthTotal() - deviceMetrics.getDeletedSizeTotal());
            MetricDescriptor descriptorCopy = descriptor.copy().withDiscriminator("name", mapName).withPrefix("map").withTag("index", indexName);
            context.collect(descriptorCopy, hybridLogMetrics);
        }
    }

    public static final class PerMemberMetrics {
        @Probe(name="tstore.device.usage", unit=ProbeUnit.BYTES)
        private volatile long deviceUsage;
        @Probe(name="tstore.hlog.length", unit=ProbeUnit.BYTES)
        private volatile long hlogLength;
        private volatile long hlogLengthExposer;

        private PerMemberMetrics() {
        }

        private void aggregate(long deviceUsage, long logLength) {
            this.deviceUsage += deviceUsage;
            this.hlogLength += logLength;
        }

        private void collect(MetricDescriptor descriptor, MetricsCollectionContext context) {
            context.collect(descriptor.copy(), this);
            this.hlogLengthExposer = this.hlogLength;
            this.deviceUsage = 0L;
            this.hlogLength = 0L;
        }

        public long getHlogLengthExposer() {
            return this.hlogLengthExposer;
        }
    }

    public static final class PerDeviceMetrics {
        private final DeviceConfig deviceConfig;
        @Probe(name="tstore.device.usedSpace", unit=ProbeUnit.BYTES)
        private volatile long usedSpace;
        @Probe(name="tstore.device.freeSpace", unit=ProbeUnit.BYTES)
        private volatile long freeSpace;
        @Probe(name="tstore.device.maxSpace", unit=ProbeUnit.BYTES)
        private volatile long maxSpace;
        @Probe(name="tstore.device.usage", unit=ProbeUnit.BYTES)
        private volatile long deviceUsage;

        private PerDeviceMetrics(DeviceConfig deviceConfig) {
            this.deviceConfig = deviceConfig;
        }

        private void aggregate(long deviceUsage) {
            this.deviceUsage += deviceUsage;
        }

        private void collect(MetricDescriptor descriptor, MetricsCollectionContext context) {
            this.updateSystemMetrics();
            MetricDescriptor withDiscriminator = descriptor.copy().withDiscriminator("name", this.deviceConfig.getName());
            context.collect(withDiscriminator, this);
            this.deviceUsage = 0L;
        }

        private void updateSystemMetrics() {
            File baseDir;
            if (!this.deviceConfig.isLocal()) {
                return;
            }
            LocalDeviceConfig localDeviceConfig = (LocalDeviceConfig)this.deviceConfig;
            for (baseDir = localDeviceConfig.getBaseDir(); baseDir != null && !baseDir.exists(); baseDir = baseDir.getParentFile()) {
            }
            if (baseDir == null || !baseDir.exists()) {
                return;
            }
            long usableSpace = baseDir.getUsableSpace();
            long totalSpace = baseDir.getTotalSpace();
            this.usedSpace = totalSpace - usableSpace;
            this.freeSpace = usableSpace;
            this.maxSpace = totalSpace;
        }
    }

    public static final class PerMapMetrics {
        private final String mapName;
        @Probe(name="tstore.device.usage", unit=ProbeUnit.BYTES)
        private volatile long deviceUsage;
        @Probe(name="tstore.hlog.length", unit=ProbeUnit.BYTES)
        private volatile long logLength;

        private PerMapMetrics(String mapName) {
            this.mapName = mapName;
        }

        private void aggregate(long deviceUsage, long logLength) {
            this.deviceUsage += deviceUsage;
            this.logLength += logLength;
        }

        private void collect(MetricDescriptor descriptor, MetricsCollectionContext context, PerMemberMetrics perMemberMetrics, PerDeviceMetrics sharedDeviceMetrics) {
            MetricDescriptor descriptorCopy = descriptor.copy().withDiscriminator("name", this.mapName).withPrefix("map");
            context.collect(descriptorCopy, this);
            perMemberMetrics.aggregate(this.deviceUsage, this.logLength);
            sharedDeviceMetrics.aggregate(this.deviceUsage);
            this.deviceUsage = 0L;
            this.logLength = 0L;
        }
    }
}

