/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.hybridlog.impl;

import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.tstore.Epoch;
import com.hazelcast.internal.tstore.TStoreException;
import com.hazelcast.internal.tstore.device.ChunkAccessor;
import com.hazelcast.internal.tstore.device.Device;
import com.hazelcast.internal.tstore.hybridlog.AddressRemapper;
import com.hazelcast.internal.tstore.hybridlog.EvictorDevice;
import com.hazelcast.internal.tstore.hybridlog.HybridLog;
import com.hazelcast.internal.tstore.hybridlog.HybridLogConfiguration;
import com.hazelcast.internal.tstore.hybridlog.HybridLogIteratorConfigurator;
import com.hazelcast.internal.tstore.hybridlog.HybridLogRegion;
import com.hazelcast.internal.tstore.hybridlog.InMemorySlotAccessor;
import com.hazelcast.internal.tstore.hybridlog.impl.FutureSafeHeadAddressesList;
import com.hazelcast.internal.tstore.hybridlog.impl.HybridLogImplMetrics;
import com.hazelcast.internal.tstore.hybridlog.impl.HybridLogIteratorConfiguratorImpl;
import com.hazelcast.internal.tstore.hybridlog.impl.HybridLogSlotAllocator;
import com.hazelcast.internal.tstore.hybridlog.impl.PagePool;
import com.hazelcast.internal.tstore.hybridlog.impl.PageStateMachine;
import com.hazelcast.internal.tstore.hybridlog.impl.Pager;
import com.hazelcast.internal.tstore.hybridlog.impl.TStoreUtil;
import com.hazelcast.internal.tstore.hybridlog.impl.TieredStoreWorkingSetImpl;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.QuickMath;
import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.Arrays;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.LongConsumer;

public class HybridLogImpl
implements HybridLog {
    private static final AtomicLongFieldUpdater<HybridLogImpl> HEAD_ADDRESS_UPDATER = AtomicLongFieldUpdater.newUpdater(HybridLogImpl.class, "headAddress");
    private static final AtomicLongFieldUpdater<HybridLogImpl> SAFE_HEAD_ADDRESS_UPDATER = AtomicLongFieldUpdater.newUpdater(HybridLogImpl.class, "safeHeadAddress");
    private static final AtomicLongFieldUpdater<HybridLogImpl> READONLY_ADDRESS_UPDATER = AtomicLongFieldUpdater.newUpdater(HybridLogImpl.class, "readOnlyAddress");
    private static final AtomicLongFieldUpdater<HybridLogImpl> SAFE_READONLY_ADDRESS_UPDATER = AtomicLongFieldUpdater.newUpdater(HybridLogImpl.class, "safeReadOnlyAddress");
    private static final AtomicLongFieldUpdater<HybridLogImpl> LAST_ALLOCATED_ADDRESS_UPDATER = AtomicLongFieldUpdater.newUpdater(HybridLogImpl.class, "lastAllocatedAddress");
    private static final AtomicIntegerFieldUpdater<HybridLogImpl> DISPOSED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(HybridLogImpl.class, "disposed");
    private static final long ALLOCATOR_STUCK_TRY_COUNT_MASK = 1048575L;
    private static final long BEYOND_READ_ONLY_ADDRESS = -1L;
    final Pager pager;
    final Epoch epoch;
    final PagePool pagePool;
    private final HybridLogSlotAllocator slotAllocator;
    private final ILogger logger = Logger.getLogger(HybridLogImpl.class);
    private final Device device;
    private final long firstValidLogicalAddress;
    private final String id;
    private final TieredStoreWorkingSetImpl defaultWorkingSet;
    private final FutureSafeHeadAddressesList futureSafeHeadAddresses;
    private volatile long headAddress;
    private volatile long safeHeadAddress;
    private volatile long safeReadOnlyAddress;
    private volatile long readOnlyAddress;
    private volatile long lastAllocatedAddress;
    private volatile int disposed;
    private final long headLagOffset;
    private final long readOnlyLagOffset;
    private final HybridLogImplMetrics metrics = new HybridLogImplMetrics();
    private final Queue<DeferredHeadAdvancementTask> deferredHeadAdvancementTasks = new ConcurrentLinkedQueue<DeferredHeadAdvancementTask>();
    private final AtomicBoolean deferredHeadAdvancementTasksConsumerLock = new AtomicBoolean();

    HybridLogImpl(HybridLogConfiguration config, Epoch epoch, PagePool pagePool, Device device) {
        this(UuidUtil.newUnsecureUuidString(), config, epoch, pagePool, device);
    }

    public HybridLogImpl(String id, HybridLogConfiguration config, Epoch epoch, PagePool pagePool, Device device) {
        this.validateConfig(config);
        this.id = id;
        this.epoch = epoch;
        this.pagePool = pagePool;
        this.device = device;
        this.firstValidLogicalAddress = config.getPageSize();
        this.pager = new Pager(id, pagePool, config);
        this.slotAllocator = new HybridLogSlotAllocator(id, this.pager, this::prepareForAdvancingToNewPage, this.firstValidLogicalAddress, this.metrics);
        this.headAddress = this.firstValidLogicalAddress;
        this.safeHeadAddress = this.firstValidLogicalAddress;
        this.readOnlyAddress = this.firstValidLogicalAddress;
        this.safeReadOnlyAddress = this.firstValidLogicalAddress;
        this.headLagOffset = (long)this.pager.totalPages * (long)this.pager.pageSize;
        this.readOnlyLagOffset = (long)this.pager.mutablePages * (long)this.pager.pageSize;
        this.pager.flushedUntilPage = this.pager.page(this.headAddress);
        this.pager.closedUntilPage = this.pager.page(this.headAddress);
        this.lastAllocatedAddress = this.firstValidLogicalAddress;
        this.defaultWorkingSet = new TieredStoreWorkingSetImpl(this);
        this.futureSafeHeadAddresses = new FutureSafeHeadAddressesList(this);
        this.logSetup();
    }

    private void logSetup() {
        if (this.logger.isFineEnabled()) {
            long maxFootPrint = (long)this.pager.totalPages * (long)this.pager.pageSize;
            this.logger.fine("HybridLog created with parameters:\n - Hybrid log ID: " + this.id + "\n - Max in-memory footprint: " + maxFootPrint + " bytes\n - Page size: " + this.pager.pageSize + " bytes\n - Readonly pages: " + this.pager.readOnlyPages + '\n' + " - Mutable pages: " + this.pager.mutablePages + '\n' + " - First valid logical address: " + this.pager.prettyFormat(this.firstValidLogicalAddress) + '\n' + " - Slot allocator: " + this.slotAllocator.debugInfo() + '\n' + " - Device: " + this.device.debugInfo() + '\n');
        }
    }

    private void validateConfig(HybridLogConfiguration config) {
        Preconditions.checkTrue(QuickMath.isPowerOfTwo(config.getPageSize()), "Page size must be a power of two");
        if (config.getReadOnlyPages() <= 0) {
            throw new IllegalArgumentException("The number of read-only pages should be a positive integer");
        }
        if (config.getMutablePages() <= 0) {
            throw new IllegalArgumentException("The number of mutable pages should be a positive integer");
        }
    }

    public long headAddress() {
        return this.headAddress;
    }

    long safeHeadAddress() {
        return this.safeHeadAddress;
    }

    long lastAllocatedAddress() {
        return this.lastAllocatedAddress;
    }

    boolean advanceHeadAddress(long desiredHeadAddress, boolean retried) {
        long lastPageAddress;
        long newHeadAddress;
        long newHeadAddressCandidate = Math.min(desiredHeadAddress, this.pager.pageStartLogicalAddress(this.pager.flushedUntilPage + 1));
        long oldHeadAddress = this.headAddress;
        int oldHeadPage = this.pager.page(oldHeadAddress);
        int newHeadPageCandidate = this.pager.page(newHeadAddressCandidate);
        if (!retried) {
            this.cleanUpDeferredHeadAdvancementTasks(newHeadAddressCandidate);
        }
        if (oldHeadPage >= newHeadPageCandidate) {
            return false;
        }
        int lastPage = 0;
        int page = oldHeadPage;
        while (page < newHeadPageCandidate) {
            if (!this.pager.markPageReleasable(page)) {
                if (retried) break;
                this.deferredHeadAdvancementTasks.offer(new DeferredHeadAdvancementTask(desiredHeadAddress));
                break;
            }
            if (this.defaultWorkingSet.isPagePinned(page)) {
                throw new IllegalStateException(String.format("Marked pinned page %d RELEASABLE", page));
            }
            lastPage = page++;
        }
        if ((newHeadAddress = Math.min(lastPageAddress = this.pager.asLogicalAddress(lastPage + 1, 0), newHeadAddressCandidate)) == oldHeadAddress) {
            return false;
        }
        return TStoreUtil.monotonicUpdate(this, HEAD_ADDRESS_UPDATER, newHeadAddress, (oldHeadAddressValue, newHeadAddressValue) -> {
            if (this.logger.isFineEnabled()) {
                this.logger.fine(String.format("%s - Advanced head address: %s -> %s", this.debugHybridLogId(), this.pager.prettyFormat(oldHeadAddressValue), this.pager.prettyFormat(newHeadAddressValue)));
            }
            MultiStageEpochActionSWSR epochAction = new MultiStageEpochActionSWSR(safeEpochIgnored -> this.onPagesClosed(newHeadAddressValue));
            long desiredReadOnlyAddress = this.pager.asLogicalAddress(this.pager.page(newHeadAddressValue) + this.pager.readOnlyPages, 0);
            this.advanceReadOnlyAddress(desiredReadOnlyAddress, epochAction);
            epochAction.addStage(this.futureSafeHeadAddresses::cleanUpToEpoch);
            this.futureSafeHeadAddresses.prepare(newHeadAddressValue);
            this.epoch.bump(this.epoch.getCurrentThreadIndex(), epochAction, futureSafeEpoch -> this.futureSafeHeadAddresses.finalizeWithEpoch(futureSafeEpoch, newHeadAddressValue));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeDeferredHeadAdvancementTasksIfNotInProgress() {
        if (this.deferredHeadAdvancementTasksConsumerLock.compareAndSet(false, true)) {
            try {
                DeferredHeadAdvancementTask task = this.deferredHeadAdvancementTasks.peek();
                boolean deferredTaskCompleted = false;
                while (task != null && task.run()) {
                    this.deferredHeadAdvancementTasks.poll();
                    deferredTaskCompleted = true;
                    task = this.deferredHeadAdvancementTasks.peek();
                }
                if (deferredTaskCompleted) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception ex) {
                this.logger.warning(String.format("%s - Executing deferred task encountered a failure: %s", this.debugHybridLogId(), ex.getMessage()), ex);
            }
            finally {
                this.deferredHeadAdvancementTasksConsumerLock.set(false);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpDeferredHeadAdvancementTasks(long newDesiredHeadAddress) {
        if (!this.deferredHeadAdvancementTasksConsumerLock.compareAndSet(false, true)) {
            return;
        }
        try {
            DeferredHeadAdvancementTask task = this.deferredHeadAdvancementTasks.peek();
            while (task != null && task.desiredHeadAddress < newDesiredHeadAddress) {
                this.deferredHeadAdvancementTasks.poll();
                task = this.deferredHeadAdvancementTasks.peek();
            }
        }
        finally {
            this.deferredHeadAdvancementTasksConsumerLock.set(false);
        }
    }

    private boolean advanceReadOnlyAddress(long desiredReadOnlyAddress, MultiStageEpochActionSWSR epochAction) {
        long newReadOnlyAddress = this.determineNewReadOnlyAddress(desiredReadOnlyAddress);
        if (newReadOnlyAddress == -1L) {
            return false;
        }
        return TStoreUtil.monotonicUpdate(this, READONLY_ADDRESS_UPDATER, newReadOnlyAddress, (oldReadOnlyAddressValue, newReadOnlyAddressValue) -> {
            epochAction.addStage(safeEpochIgnored -> TStoreUtil.monotonicUpdate(this, HybridLogImpl.SAFE_READONLY_ADDRESS_UPDATER, newReadOnlyAddressValue, (oldSafeReadOnlyAddressValue, newSafeReadOnlyAddressValue) -> {
                if (this.logger.isFineEnabled()) {
                    this.logger.fine(String.format("%s - Advanced safe read-only address: %s -> %s", this.debugHybridLogId(), this.pager.prettyFormat(oldSafeReadOnlyAddressValue), this.pager.prettyFormat(newSafeReadOnlyAddressValue)));
                }
                this.onPageMarkedReadOnly(newReadOnlyAddressValue);
            }));
            if (this.logger.isFineEnabled()) {
                this.logger.fine(String.format("%s - Advanced read-only address: %s -> %s", this.debugHybridLogId(), this.pager.prettyFormat(oldReadOnlyAddressValue), this.pager.prettyFormat(newReadOnlyAddressValue)));
            }
        });
    }

    private long determineNewReadOnlyAddress(long desiredReadOnlyAddress) {
        int readOnlyPageHMW;
        long readOnlyAddressCopy;
        if (this.logger.isFineEnabled()) {
            this.logger.fine(String.format("%s - Attempting to set new read-only address: %s", this.debugHybridLogId(), this.pager.prettyFormat(desiredReadOnlyAddress)));
        }
        int newReadOnlyPage = this.pager.page(desiredReadOnlyAddress);
        do {
            if ((readOnlyAddressCopy = this.readOnlyAddress) >= desiredReadOnlyAddress) {
                return -1L;
            }
            readOnlyPageHMW = this.pager.page(readOnlyAddressCopy) - 1;
            int p = readOnlyPageHMW + 1;
            while (p < newReadOnlyPage && this.pager.markPageReadOnly(p)) {
                readOnlyPageHMW = p++;
            }
        } while (this.readOnlyAddress != readOnlyAddressCopy);
        long determinedReadOnlyAddress = this.pager.asLogicalAddress(readOnlyPageHMW + 1, 0);
        assert (determinedReadOnlyAddress <= desiredReadOnlyAddress) : String.format("determinedReadOnlyAddress: %s, desiredReadOnlyAddress: %s", this.pager.prettyFormat(determinedReadOnlyAddress), this.pager.prettyFormat(desiredReadOnlyAddress));
        return determinedReadOnlyAddress;
    }

    private void onPagesClosed(long newSafeHeadAddress) {
        assert (this.epoch.inEpochAction());
        TStoreUtil.monotonicUpdate(this, SAFE_HEAD_ADDRESS_UPDATER, newSafeHeadAddress, (oldSafeHeadAddressValue, newSafeHeadAddressValue) -> {
            if (this.logger.isFineEnabled()) {
                this.logger.fine(String.format("%s - Advanced safe head address: %s -> %s", this.debugHybridLogId(), this.pager.prettyFormat(oldSafeHeadAddressValue), this.pager.prettyFormat(newSafeHeadAddressValue)));
            }
            int firstPageRecycle = this.pager.page(oldSafeHeadAddressValue);
            int lastPageRecycle = this.pager.page(newSafeHeadAddressValue);
            if (this.logger.isFineEnabled()) {
                this.logger.fine(String.format("%s - Freeing pages between %d and %d", this.debugHybridLogId(), firstPageRecycle, lastPageRecycle));
            }
            for (int page = firstPageRecycle; page < lastPageRecycle; ++page) {
                this.recyclePage(page);
            }
            this.pager.closedUntilPage = this.pager.page(newSafeHeadAddressValue);
        });
    }

    private void onPageMarkedReadOnly(long newReadonlyAddress) {
        int flushedUntilPage = this.pager.flushedUntilPage;
        int newReadonlyPage = this.pager.page(newReadonlyAddress);
        for (int page = flushedUntilPage; page < newReadonlyPage; ++page) {
            if (!Pager.FLUSHING_UNTIL_PAGE_UPDATER.compareAndSet(this.pager, page - 1, page)) continue;
            this.flushPage(page);
        }
    }

    private void recyclePage(int page) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine(String.format("%s - Recycling page %d", this.debugHybridLogId(), page));
        }
        this.pager.recyclePage(page);
    }

    @Override
    public boolean isInMemory(long logicalAddress) {
        this.throwExceptionOnInvalidAddress(logicalAddress);
        if (logicalAddress >= this.headAddress) {
            return true;
        }
        int threadIndex = this.epoch.getCurrentThreadIndex();
        long currentEpoch = this.epoch.getThreadEpoch(threadIndex);
        this.futureSafeHeadAddresses.waitUntilPreparationsDrainedFor(logicalAddress);
        long safeHeadAddressForCurrentEpoch = this.getSafeHeadAddressForEpoch(currentEpoch);
        if (safeHeadAddressForCurrentEpoch == -1L) {
            safeHeadAddressForCurrentEpoch = this.safeHeadAddress;
        }
        return logicalAddress >= safeHeadAddressForCurrentEpoch;
    }

    long getSafeHeadAddressForEpoch(long currentEpoch) {
        return this.futureSafeHeadAddresses.getSafeHeadAddressForEpoch(currentEpoch);
    }

    @Override
    public boolean isMutable(long logicalAddress) {
        this.throwExceptionOnInvalidAddress(logicalAddress);
        return logicalAddress >= this.readOnlyAddress;
    }

    @Override
    public boolean isValidAddress(long logicalAddress) {
        return logicalAddress > 0L && logicalAddress <= this.lastAllocatedAddress() && this.pager.offset(logicalAddress) >= 8 && (logicalAddress >= this.safeHeadAddress || this.device.containsLogicalAddress(logicalAddress));
    }

    @Override
    public long asPhysicalAddress(long logicalAddress) {
        if (!this.isValidAddress(logicalAddress)) {
            return -1L;
        }
        if (logicalAddress < this.safeHeadAddress) {
            return 0L;
        }
        long physicalAddress = this.pager.asPhysicalAddress(logicalAddress);
        if (logicalAddress < this.safeHeadAddress) {
            return 0L;
        }
        return physicalAddress;
    }

    private void throwExceptionOnInvalidAddress(long logicalAddress) {
        if (!this.isValidAddress(logicalAddress)) {
            throw new TStoreException(String.format("%s - Invalid address: %s, headAddress=%s, lastAllocatedAddress=%s", this.debugHybridLogId(), this.pager.prettyFormat(logicalAddress), this.pager.prettyFormat(this.headAddress), this.pager.prettyFormat(this.lastAllocatedAddress)));
        }
    }

    @Override
    public long tryAllocate(long size) {
        this.checkDisposed();
        long logicalAddress = this.slotAllocator.tryAllocate((int)size);
        boolean validLogicalAddress = this.isValidLogicalAddress(logicalAddress);
        if (this.logger.isFinestEnabled()) {
            if (validLogicalAddress) {
                long physicalAddress = this.pager.asPhysicalAddress(logicalAddress);
                this.logger.finest(String.format("%s - Allocated slot at %s -> %s", this.debugHybridLogId(), this.slotAllocator.pager.prettyFormat(logicalAddress), TStoreUtil.prettyFormatPhysical(physicalAddress)));
            } else if (-2L == logicalAddress) {
                this.logger.finest(this.debugHybridLogId() + " - Unsuccessful allocation, waiting for page flush: the allocator should return later");
            } else if (-1L == logicalAddress) {
                this.logger.finest(this.debugHybridLogId() + " - Unsuccessful allocation, waiting for page close: the allocator should return immediately");
            }
        }
        this.advanceReadOnlyAddressIfNeeded(logicalAddress);
        if (validLogicalAddress) {
            TStoreUtil.monotonicUpdate(this, LAST_ALLOCATED_ADDRESS_UPDATER, logicalAddress);
            if (this.logger.isFineEnabled()) {
                this.logger.fine(this.debugRegions());
            }
        }
        return logicalAddress;
    }

    @Override
    public long allocate(long size) {
        long logicalAddress = this.tryAllocate(size);
        long tryCount = 0L;
        boolean logged = false;
        long stallStartedNs = 0L;
        int currentThreadIndex = Integer.MIN_VALUE;
        while (!this.isValidAddress(logicalAddress) && !Thread.currentThread().isInterrupted()) {
            if (tryCount++ == 0L && logicalAddress == -1L) {
                logicalAddress = this.tryAllocate(size);
                continue;
            }
            if (this.executeDeferredHeadAdvancementTasksIfNotInProgress()) continue;
            if ((tryCount & 0xFFFFFL) == 0L) {
                this.warnAllocatorStuck(tryCount);
            }
            if (!logged) {
                logged = true;
                stallStartedNs = System.nanoTime();
            }
            Thread.yield();
            if (currentThreadIndex == Integer.MIN_VALUE) {
                currentThreadIndex = this.epoch.getCurrentThreadIndex();
            }
            this.epoch.refresh(currentThreadIndex);
            logicalAddress = this.tryAllocate(size);
        }
        if (logged) {
            this.metrics.onAllocationStall(stallStartedNs);
        }
        if (Thread.currentThread().isInterrupted()) {
            throw ExceptionUtil.rethrow(new InterruptedException());
        }
        return logicalAddress;
    }

    private void advanceReadOnlyAddressIfNeeded(long logicalAddress) {
        long desiredReadOnlyAddress = (logicalAddress - this.readOnlyLagOffset & (long)this.pager.pageMask) + this.firstValidLogicalAddress;
        if (desiredReadOnlyAddress > this.readOnlyAddress) {
            MultiStageEpochActionSWSR epochAction = new MultiStageEpochActionSWSR();
            this.advanceReadOnlyAddress(desiredReadOnlyAddress, epochAction);
            this.epoch.bump(this.epoch.getCurrentThreadIndex(), epochAction);
        }
    }

    private boolean isValidLogicalAddress(long logicalAddress) {
        return logicalAddress >= this.firstValidLogicalAddress;
    }

    @Override
    public long reallocate(long address, long currentSize, long newSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void free(long address, long size) {
        throw new UnsupportedOperationException();
    }

    private void flushPage(int page) {
        int oldFlushedUntilPage = this.pager.flushedUntilPage;
        long physicalPageStart = this.pagePhysicalAddressStart(page);
        long physicalPageEnd = this.pagePhysicalAddressEnd(page);
        long pageLogicalAddress = this.pager.pageStartLogicalAddress(page);
        int writeLength = this.pager.pageSize;
        if (this.logger.isFineEnabled()) {
            String physicalStartStr = TStoreUtil.prettyFormatPhysical(physicalPageStart);
            String physicalEndStr = TStoreUtil.prettyFormatPhysical(physicalPageEnd);
            StringBuilder sb = new StringBuilder().append(this.debugHybridLogId()).append(" - ").append("Trigger page flushing").append('\n').append("  - Hybrid log: ").append(this.id).append('\n').append("  - Device: ").append(this.device.debugInfo()).append('\n').append("  - Page: ").append(page).append('\n').append("  - Logical address range: ").append(this.pager.prettyFormat(pageLogicalAddress)).append(" - ").append(this.pager.prettyFormat(this.pager.pageEndLogicalAddress(page))).append('\n').append("  - Physical address range: ").append(physicalStartStr).append(" - ").append(physicalEndStr);
            this.logger.fine(sb.toString());
        }
        long startPageWriteNs = System.nanoTime();
        this.pager.markPageFlushing(page);
        try {
            this.device.writeAsync(pageLogicalAddress, physicalPageStart, writeLength).whenComplete((unused, throwable) -> this.finalizePageFlush(page, oldFlushedUntilPage, pageLogicalAddress, (Throwable)throwable, startPageWriteNs));
        }
        catch (Throwable throwable2) {
            this.finalizePageFlush(page, oldFlushedUntilPage, pageLogicalAddress, throwable2, startPageWriteNs);
        }
    }

    private void finalizePageFlush(int page, int oldFlushedUntilPage, long pageLogicalAddress, Throwable throwable, long startPageWriteNs) {
        if (throwable != null) {
            this.logger.severe(String.format("%s - Flushing page %d to the device '%s' has failed. All data in the (%s - %s) address range are lost.", this.debugHybridLogId(), page, this.device.deviceName(), this.pager.prettyFormat(pageLogicalAddress), this.pager.prettyFormat(this.pager.pageEndLogicalAddress(page))), throwable);
        }
        this.metrics.onPageWritten(startPageWriteNs);
        this.pager.markPageFlushed(page);
        int newFlushedUntilPage = this.pager.flushedUntilPage;
        int p = this.pager.flushedUntilPage;
        while (PageStateMachine.PageState.FLUSHED == this.pager.pageState(p) || PageStateMachine.PageState.PINNED_FLUSHED == this.pager.pageState(p)) {
            newFlushedUntilPage = p + 1;
            ++p;
        }
        if (TStoreUtil.monotonicUpdate(this.pager, Pager.FLUSHED_UNTIL_PAGE_UPDATER, newFlushedUntilPage) && this.logger.isFineEnabled()) {
            this.logger.fine(String.format("%s - Advanced flushed until page: %d -> %d", this.debugHybridLogId(), oldFlushedUntilPage, newFlushedUntilPage));
        }
    }

    @Override
    public <P, T> T readRecordForReadOnly(long logicalAddress, InMemorySlotAccessor<P, T> slotAccessor, AddressRemapper<T> addressRemapper, byte[] buf) {
        return this.readRecord(logicalAddress, slotAccessor, addressRemapper, buf, false);
    }

    @Override
    public <P, T> T readRecordForUpdate(long logicalAddress, InMemorySlotAccessor<P, T> slotAccessor, AddressRemapper<T> addressRemapper, byte[] buf) {
        return this.readRecord(logicalAddress, slotAccessor, addressRemapper, buf, true);
    }

    private <P, T> T readRecord(long logicalAddress, InMemorySlotAccessor<P, T> slotAccessor, AddressRemapper<T> addressRemapper, byte[] buf, boolean readForUpdate) {
        this.checkAddress(logicalAddress);
        if (this.isInMemory(logicalAddress)) {
            this.metrics.onReadRecordHit();
            if (!readForUpdate || this.isMutable(logicalAddress)) {
                return slotAccessor.asEntry(slotAccessor.prepare(logicalAddress, this));
            }
            long newLogicalAddress = this.copyForUpdate(logicalAddress, slotAccessor, addressRemapper);
            return slotAccessor.asEntry(slotAccessor.prepare(newLogicalAddress, this));
        }
        this.metrics.onReadRecordMiss();
        long startNs = System.nanoTime();
        byte[] bytes = this.device.readRecord(logicalAddress, buf, slotAccessor);
        this.metrics.onRecordReadFromDeviceCompleted(startNs);
        long newLogicalAddressCandidate = this.addReadRecordToLog(bytes);
        T entry = slotAccessor.asEntry(slotAccessor.prepare(newLogicalAddressCandidate, this));
        addressRemapper.remap(entry, logicalAddress, newLogicalAddressCandidate);
        this.device.stats().markRecordAsUnreachable(logicalAddress, bytes.length);
        return entry;
    }

    @Override
    public <P, T> T readRecordForReadOnly(long logicalAddress, InMemorySlotAccessor<P, T> slotAccessor, AddressRemapper<T> addressRemapper) {
        return this.readRecord(logicalAddress, slotAccessor, addressRemapper, false);
    }

    @Override
    public <P, T> T readRecordForUpdate(long logicalAddress, InMemorySlotAccessor<P, T> slotAccessor, AddressRemapper<T> addressRemapper) {
        return this.readRecord(logicalAddress, slotAccessor, addressRemapper, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <P, T> T readRecord(long logicalAddress, InMemorySlotAccessor<P, T> slotAccessor, AddressRemapper<T> addressRemapper, boolean readForUpdate) {
        T entry;
        long newLogicalAddressCandidate;
        this.checkAddress(logicalAddress);
        if (this.isInMemory(logicalAddress)) {
            this.metrics.onReadRecordHit();
            if (!readForUpdate || this.isMutable(logicalAddress)) {
                return slotAccessor.asEntry(slotAccessor.prepare(logicalAddress, this));
            }
            long newLogicalAddress = this.copyForUpdate(logicalAddress, slotAccessor, addressRemapper);
            return slotAccessor.asEntry(slotAccessor.prepare(newLogicalAddress, this));
        }
        this.metrics.onReadRecordMiss();
        long startNs = System.nanoTime();
        byte[] bytes = this.device.readRecord(logicalAddress, slotAccessor);
        this.metrics.onRecordReadFromDeviceCompleted(startNs);
        while (!this.pinAddressForUpdate(newLogicalAddressCandidate = this.addReadRecordToLog(bytes))) {
        }
        try {
            entry = slotAccessor.asEntry(slotAccessor.prepare(newLogicalAddressCandidate, this));
            addressRemapper.remap(entry, logicalAddress, newLogicalAddressCandidate);
        }
        finally {
            this.unpinAddress(newLogicalAddressCandidate);
        }
        this.device.stats().markRecordAsUnreachable(logicalAddress, bytes.length);
        return entry;
    }

    @Override
    public <P, T> byte[] readRecordFromDevice(long logicalAddress, InMemorySlotAccessor<P, T> slotAccessor) {
        this.checkAddress(logicalAddress);
        if (this.isInMemory(logicalAddress)) {
            throw new IllegalArgumentException(String.format("%s - The requested logical address %s is not on device", this.debugHybridLogId(), this.pager.prettyFormat(logicalAddress)));
        }
        return this.device.readRecord(logicalAddress, slotAccessor);
    }

    @Override
    public <P, T> Data readRecordValue(long logicalAddress, InMemorySlotAccessor<P, T> slotAccessor) {
        this.checkAddress(logicalAddress);
        if (this.isInMemory(logicalAddress)) {
            throw new IllegalArgumentException(String.format("%s - The requested logical address %s is not on device", this.debugHybridLogId(), this.pager.prettyFormat(logicalAddress)));
        }
        byte[] record = this.device.readRecord(logicalAddress, slotAccessor);
        return slotAccessor.readValue(record);
    }

    @Override
    public byte[] readChunk(long logicalAddress, byte[] buf, ChunkAccessor chunkAccessor) {
        this.checkAddress(logicalAddress);
        if (this.isInMemory(logicalAddress)) {
            throw new IllegalArgumentException(String.format("%s - The requested logical address %s is not on device", this.debugHybridLogId(), this.pager.prettyFormat(logicalAddress)));
        }
        return this.device.readChunk(logicalAddress, buf, chunkAccessor);
    }

    private void checkAddress(long logicalAddress) {
        if (!this.isValidAddress(logicalAddress)) {
            throw new IllegalArgumentException(String.format("%s - Invalid logical address: %s. Valid addresses are within the range defined by and lastAllocatedAddress=%s", this.debugHybridLogId(), this.pager.prettyFormat(logicalAddress), this.pager.prettyFormat(this.lastAllocatedAddress)));
        }
    }

    private <P, T> long copyForUpdate(long oldLogicalAddress, InMemorySlotAccessor<P, T> slotAccessor, AddressRemapper<T> addressRemapper) {
        long oldPhysicalAddress = this.asPhysicalAddress(oldLogicalAddress);
        P preparedSlot = slotAccessor.prepare(oldLogicalAddress, this);
        int size = slotAccessor.size(preparedSlot);
        T entry = slotAccessor.asEntry(preparedSlot);
        byte[] tmp = new byte[size];
        assert (this.pager.verifyAccess(this.pager.page(oldLogicalAddress), oldPhysicalAddress));
        GlobalMemoryAccessorRegistry.AMEM.copyToByteArray(oldPhysicalAddress, tmp, 0, size);
        long newLogicalAddressCandidate = this.allocate(size);
        long newPhysicalAddress = this.asPhysicalAddress(newLogicalAddressCandidate);
        assert (this.pager.verifyAccess(this.pager.page(newLogicalAddressCandidate), newPhysicalAddress));
        GlobalMemoryAccessorRegistry.AMEM.copyFromByteArray(tmp, 0, newPhysicalAddress, size);
        return addressRemapper.remap(entry, oldLogicalAddress, newLogicalAddressCandidate);
    }

    @Override
    public <P, T> CompletableFuture<T> readRecordAsync(long logicalAddress, InMemorySlotAccessor<P, T> slotAccessor, AddressRemapper<T> addressRemapper) {
        return this.readRecordAsync(logicalAddress, slotAccessor, addressRemapper, false);
    }

    @Override
    public <P, T> CompletableFuture<T> readRecordAsyncForUpdate(long logicalAddress, InMemorySlotAccessor<P, T> slotAccessor, AddressRemapper<T> addressRemapper) {
        return this.readRecordAsync(logicalAddress, slotAccessor, addressRemapper, true);
    }

    private <P, T> CompletableFuture<T> readRecordAsync(long logicalAddress, InMemorySlotAccessor<P, T> slotAccessor, AddressRemapper<T> addressRemapper, boolean readForUpdate) {
        this.checkAddress(logicalAddress);
        CompletableFuture future = new CompletableFuture();
        if (this.isInMemory(logicalAddress)) {
            this.metrics.onReadRecordHit();
            if (!readForUpdate || this.isMutable(logicalAddress)) {
                T entry = slotAccessor.asEntry(slotAccessor.prepare(logicalAddress, this));
                future.complete(entry);
                return future;
            }
            long newLogicalAddress = this.copyForUpdate(logicalAddress, slotAccessor, addressRemapper);
            T entry = slotAccessor.asEntry(slotAccessor.prepare(newLogicalAddress, this));
            future.complete(entry);
            return future;
        }
        this.metrics.onReadRecordMiss();
        long readStartNs = System.nanoTime();
        this.device.readRecordAsync(logicalAddress, slotAccessor).whenComplete((bytes, ex) -> {
            if (ex != null) {
                future.completeExceptionally((Throwable)ex);
                return;
            }
            try {
                long newLogicalAddressCandidate = this.allocate(((byte[])bytes).length);
                long physicalAddress = this.asPhysicalAddress(newLogicalAddressCandidate);
                GlobalMemoryAccessorRegistry.AMEM.copyFromByteArray((byte[])bytes, 0, physicalAddress, ((byte[])bytes).length);
                Object entry = slotAccessor.asEntry(slotAccessor.prepare(newLogicalAddressCandidate, this));
                addressRemapper.remap(entry, logicalAddress, newLogicalAddressCandidate);
                future.complete(entry);
                this.metrics.onRecordReadFromDeviceCompleted(readStartNs);
                this.device.stats().markRecordAsUnreachable(logicalAddress, ((byte[])bytes).length);
            }
            catch (Exception ex2) {
                future.completeExceptionally(ex2);
            }
        });
        return future;
    }

    void prepareForAdvancingToNewPage(int page) {
        long pageEndLogicalAddress = this.pager.pageEndLogicalAddress(page);
        long flushedUntilLogicalAddress = this.pager.pageStartLogicalAddress(this.pager.flushedUntilPage);
        long desiredHeadAddress = Math.min(pageEndLogicalAddress - this.headLagOffset + 1L, flushedUntilLogicalAddress);
        long desiredReadOnlyAddress = Math.min(pageEndLogicalAddress - this.readOnlyLagOffset + 1L, flushedUntilLogicalAddress);
        if (this.logger.isFinestEnabled()) {
            this.logger.finest(String.format("%s - Preparing for page %d by advancing\n  - headAddress to %s \n  - readOnlyAddress to %s", this.debugHybridLogId(), page, this.pager.prettyFormat(desiredHeadAddress), this.pager.prettyFormat(desiredReadOnlyAddress)));
        }
        this.advanceHeadAddress(desiredHeadAddress, false);
    }

    void fetchPage(int page, byte[] buffer) {
        if (buffer.length < this.pager.pageSize) {
            throw new IllegalArgumentException(this.debugHybridLogId() + " - The provided buffer is smaller than the size of a page");
        }
        long pageAddress = this.pager.asLogicalAddress(page, 0);
        this.device.read(pageAddress, buffer);
    }

    private long addReadRecordToLog(byte[] bytes) {
        assert (bytes.length > 0) : Arrays.toString(bytes);
        long newLogicalAddress = this.allocate(bytes.length);
        long physicalAddress = this.asPhysicalAddress(newLogicalAddress);
        assert (physicalAddress != 0L) : "newLogicalAddress=" + newLogicalAddress;
        GlobalMemoryAccessorRegistry.AMEM.copyFromByteArray(bytes, 0, physicalAddress, bytes.length);
        return newLogicalAddress;
    }

    private long pagePhysicalAddressStart(int page) {
        long pageHeadLogicalAddress = this.pager.asLogicalAddress(page, 0);
        if (pageHeadLogicalAddress < this.headAddress) {
            throw new IllegalArgumentException(String.format("%s - Page %d is not in the memory", this.debugHybridLogId(), page));
        }
        return this.pager.asPhysicalAddress(pageHeadLogicalAddress);
    }

    private long pagePhysicalAddressEnd(int page) {
        long pageHeadLogicalAddress = this.pager.asLogicalAddress(page, 0);
        if (pageHeadLogicalAddress < this.headAddress) {
            throw new IllegalArgumentException(String.format("%s - Page %d is not in the memory", this.debugHybridLogId(), page));
        }
        return this.pager.asPhysicalAddress(pageHeadLogicalAddress) + (long)this.pager.pageSize - 1L;
    }

    @Override
    public void dispose() {
        if (!DISPOSED_UPDATER.compareAndSet(this, 0, 1)) {
            return;
        }
        this.pager.dispose();
        this.device.dispose();
    }

    private void checkDisposed() {
        if (DISPOSED_UPDATER.get(this) != 0) {
            throw new IllegalStateException(String.format("%s %s", this.debugHybridLogId(), " has been disposed. It is no longer safe to issue invocations on it."));
        }
    }

    public String getId() {
        return this.id;
    }

    String debugHybridLogId() {
        return TStoreUtil.hybridLogStr(this.id);
    }

    String debugAddresses() {
        int threadIndex = this.epoch.getCurrentThreadIndex();
        long currentEpoch = this.epoch.getThreadEpoch(threadIndex);
        long safeFutureHeadAddress = this.getSafeHeadAddressForEpoch(currentEpoch);
        return this.debugHybridLogId() + " addresses:\n  - safeHeadAddress:      " + this.pager.prettyFormat(this.safeHeadAddress) + " might update to (" + this.pager.prettyFormat(safeFutureHeadAddress) + ")" + '\n' + "  - headAddress:          " + this.pager.prettyFormat(this.headAddress) + '\n' + "  - safeReadOnlyAddress:  " + this.pager.prettyFormat(this.safeReadOnlyAddress) + '\n' + "  - readOnlyAddress:      " + this.pager.prettyFormat(this.readOnlyAddress) + '\n';
    }

    String debugRegions() {
        return this.debugHybridLogId() + " regions:     \n  - Read-only: " + this.debugRegion(this.headAddress, Math.min(this.readOnlyAddress, this.safeReadOnlyAddress) - 1L) + '\n' + "  - Fuzzy:     " + this.debugRegion(Math.min(this.readOnlyAddress, this.safeReadOnlyAddress), this.readOnlyAddress - 1L) + '\n' + "  - Mutable:   " + this.debugRegion(Math.max(this.readOnlyAddress, this.safeReadOnlyAddress), this.pager.pageEndLogicalAddress(this.pager.page(this.lastAllocatedAddress))) + '\n';
    }

    private String debugRegion(long regionStartAddress, long regionEndAddress) {
        if (regionEndAddress > regionStartAddress) {
            return this.pager.prettyFormat(regionStartAddress) + " - " + this.pager.prettyFormat(regionEndAddress);
        }
        return "N/A";
    }

    String debugFutureSafeHeadAddresses() {
        return this.futureSafeHeadAddresses.debugInfo();
    }

    HybridLogRegion regionOf(long logicalAddress) {
        if (logicalAddress < this.headAddress) {
            return this.device instanceof EvictorDevice ? HybridLogRegion.NIRVANA : HybridLogRegion.STABLE;
        }
        if (logicalAddress < this.safeReadOnlyAddress) {
            return HybridLogRegion.READ_ONLY;
        }
        if (logicalAddress < this.readOnlyAddress) {
            return HybridLogRegion.FUZZY;
        }
        return HybridLogRegion.MUTABLE;
    }

    long align(long logicalAddress) {
        return TStoreUtil.align8Bytes(logicalAddress);
    }

    @Override
    public <P, T> HybridLogIteratorConfigurator<P, T> iterators(Class<T> clazz) {
        return new HybridLogIteratorConfiguratorImpl(this);
    }

    @Override
    public <P, T> HybridLogIteratorConfigurator<P, T> iterators() {
        return new HybridLogIteratorConfiguratorImpl(this);
    }

    @Override
    public boolean pinAddress(long logicalAddress) {
        this.validateAddressIsInMemory(logicalAddress);
        int page = this.pager.page(logicalAddress);
        return this.defaultWorkingSet.pin(logicalAddress, () -> this.pager.pinPage(page));
    }

    @Override
    public boolean pinAddressForUpdate(long logicalAddress) {
        this.validateAddressIsInMemory(logicalAddress);
        int page = this.pager.page(logicalAddress);
        return this.defaultWorkingSet.pin(logicalAddress, () -> this.pager.pinPageForUpdate(page));
    }

    @Override
    public void unpinAddress(long logicalAddress) {
        this.validateAddressIsInMemory(logicalAddress);
        int page = this.pager.page(logicalAddress);
        this.defaultWorkingSet.unpin(logicalAddress, () -> this.pager.unpinPage(page));
    }

    @Override
    public boolean isAddressPinned(long logicalAddress) {
        return this.isAddressPinned(logicalAddress, true);
    }

    boolean isAddressPinned(long logicalAddress, boolean validate) {
        if (validate) {
            this.validateAddressIsInMemory(logicalAddress);
        }
        return this.defaultWorkingSet.isLogicalAddressPinned(logicalAddress);
    }

    private void validateAddressIsInMemory(long logicalAddress) {
        if (!this.isInMemory(logicalAddress)) {
            throw new IllegalArgumentException(String.format("%s - Logical address %s is not in the memory", this.debugHybridLogId(), this.pager.prettyFormat(logicalAddress)));
        }
    }

    private void warnAllocatorStuck(long tryCount) {
        String ln = System.lineSeparator();
        String s = "stuck in the allocate of HybridLog with id=" + this.getId() + ln + "tryCount=" + tryCount + ln + this.epoch.debugInfo() + ln + "headAddress page is " + this.pager.page(this.headAddress) + ln + "headAddress page is pinned? - " + this.defaultWorkingSet.isPagePinned(this.pager.page(this.headAddress)) + ln + this.debugAddresses() + ln + this.pager.debugInfo() + ln + this.pagePool.debugInfo() + ln + this.slotAllocator.debugInfo();
        this.logger.warning(s);
    }

    public Device getDevice() {
        return this.device;
    }

    public HybridLogImplMetrics getMetrics() {
        return this.metrics;
    }

    public long getFirstValidLogicalAddress() {
        return this.firstValidLogicalAddress;
    }

    public long firstEntry(int segmentNo) {
        if (segmentNo == 0) {
            return this.firstValidLogicalAddress + 8L;
        }
        return this.device.segmentFirstLogicalAddress(segmentNo) + 8L;
    }

    public int getReadonlyPageCount() {
        return this.pager.readOnlyPages;
    }

    public int getMutablePageCount() {
        return this.pager.mutablePages;
    }

    private final class DeferredHeadAdvancementTask {
        private final long desiredHeadAddress;

        private DeferredHeadAdvancementTask(long desiredHeadAddress) {
            this.desiredHeadAddress = desiredHeadAddress;
        }

        private boolean run() {
            HybridLogImpl.this.advanceHeadAddress(this.desiredHeadAddress, true);
            return HybridLogImpl.this.headAddress >= this.desiredHeadAddress;
        }
    }

    private static final class MultiStageEpochActionSWSR
    implements Epoch.Action {
        private volatile Node node;

        MultiStageEpochActionSWSR() {
        }

        MultiStageEpochActionSWSR(LongConsumer firstStage) {
            this.node = new Node(firstStage, null);
        }

        private void addStage(LongConsumer stage) {
            this.node = new Node(stage, this.node);
        }

        @Override
        public void run(int threadIndex, long actionEpoch) {
            Node n = this.node;
            if (n == null) {
                return;
            }
            this.node = null;
            while (n.next != null) {
                n.next.prev = n;
                n = n.next;
            }
            while (n != null) {
                n.stage.accept(actionEpoch);
                n = n.prev;
            }
        }

        private static class Node {
            final LongConsumer stage;
            final Node next;
            Node prev;

            Node(LongConsumer stage, Node next) {
                this.stage = stage;
                this.next = next;
            }
        }
    }
}

