/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.device.local;

import com.hazelcast.internal.tstore.device.DeviceMetrics;
import java.util.concurrent.atomic.AtomicLong;

class LocalStorageDeviceMetrics
implements DeviceMetrics {
    private final AtomicLong deviceUsage = new AtomicLong();
    private final AtomicLong deletedSizeTotal = new AtomicLong();

    LocalStorageDeviceMetrics() {
    }

    void onWrite(int writeLength) {
        this.deviceUsage.addAndGet(writeLength);
    }

    void onDelete(long fileSize) {
        this.deviceUsage.addAndGet(-fileSize);
        this.deletedSizeTotal.addAndGet(fileSize);
    }

    @Override
    public long getDeviceUsage() {
        return this.deviceUsage.get();
    }

    @Override
    public long getDeletedSizeTotal() {
        return this.deletedSizeTotal.get();
    }
}

