/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.device;

import com.hazelcast.internal.tstore.Invariants;
import com.hazelcast.internal.tstore.device.DeviceException;
import com.hazelcast.internal.tstore.device.HybridLogFileHandle;
import com.hazelcast.internal.tstore.device.HybridLogFileHandlePool;
import com.hazelcast.internal.tstore.device.HybridLogFileHandleProvider;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantLock;

public class HybridLogFileHandlePoolImpl
implements HybridLogFileHandlePool {
    static final int MAX_DESIRED_OPEN_LOG_HANDLES = 32;
    private final TreeMap<Integer, HybridLogFileHandleList> poolMap = new TreeMap();
    private final Map<Integer, Integer> lruMap = new LinkedHashMap<Integer, Integer>(32, 0.75f, true);
    private int openHandlesCount;
    private final ReentrantLock poolLock = new ReentrantLock();
    private final int storeId;
    private boolean closed;

    public HybridLogFileHandlePoolImpl(int storeId) {
        this.storeId = storeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HybridLogFileHandle getHandle(int fileno, HybridLogFileHandleProvider handleProvider) {
        assert (fileno >= 0);
        HybridLogFileHandle handle = null;
        this.poolLock.lock();
        this.checkClosed();
        try {
            HybridLogFileHandleList handleList = this.poolMap.get(fileno);
            if (handleList != null) {
                assert (handleList.validateSize());
                handle = handleList.poll();
                if (handle != null) {
                    this.updateLruMap(fileno);
                    HybridLogFileHandle hybridLogFileHandle = handle;
                    return hybridLogFileHandle;
                }
                handleList.increaseTotal();
                this.updateLruMap(fileno);
            } else {
                handleList = new HybridLogFileHandleList();
                this.poolMap.put(fileno, handleList);
                this.addToLruMap(fileno);
            }
            ++this.openHandlesCount;
            assert (handleList.getAvailable() == 0);
        }
        finally {
            this.poolLock.unlock();
        }
        assert (handle == null);
        return handleProvider.createHybridLogFileHandle(this.storeId, fileno);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseHandle(HybridLogFileHandle handle) {
        this.poolLock.lock();
        int fileno = handle.getFileno();
        HybridLogFileHandle coldHandle = null;
        try {
            if (this.closeHandleIfPoolIsClosed(handle)) {
                return;
            }
            HybridLogFileHandleList handleList = this.poolMap.get(fileno);
            assert (handleList != null && handleList.validateSize());
            if (this.openHandlesCount <= 32) {
                handleList.put(handle);
                assert (handleList.validateSize());
            } else {
                HybridLogFileHandleList coldHandleList = null;
                int coldFileno2 = -1;
                for (int coldFileno2 : this.lruMap.keySet()) {
                    if (coldFileno2 == fileno) continue;
                    coldHandleList = this.poolMap.get(coldFileno2);
                    assert (coldHandleList != null && coldHandleList.validateSize());
                    if (coldHandleList.getAvailable() == 0) continue;
                    coldHandle = coldHandleList.remove();
                    break;
                }
                if (coldHandle == null) {
                    handleList.decreaseTotal();
                    coldFileno2 = fileno;
                    coldHandleList = handleList;
                    coldHandle = handle;
                } else {
                    handleList.put(handle);
                }
                assert (coldFileno2 >= 0);
                assert (coldHandleList != null);
                assert (coldHandle != null);
                if (coldHandleList.getTotal() == 0) {
                    this.poolMap.remove(coldFileno2);
                    this.removeFromLruList(coldFileno2);
                }
                --this.openHandlesCount;
                assert (this.openHandlesCount > 0);
            }
        }
        finally {
            this.poolLock.unlock();
        }
        if (coldHandle != null) {
            coldHandle.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearHandles(int fromFileNo, int toFileNoInclusive) {
        Invariants.nonNegative(fromFileNo);
        Invariants.lessThanOrEqual(fromFileNo, toFileNoInclusive);
        LinkedList toRemove = new LinkedList();
        this.poolLock.lock();
        this.checkClosed();
        try {
            SortedMap<Integer, HybridLogFileHandleList> range = toFileNoInclusive == Integer.MAX_VALUE ? this.poolMap.tailMap(fromFileNo) : this.poolMap.subMap(fromFileNo, toFileNoInclusive + 1);
            range.forEach((fileNo, handleList) -> {
                Invariants.inRange(fromFileNo, fileNo, toFileNoInclusive);
                assert (handleList.getTotal() == handleList.getAvailable());
                int total = handleList.getTotal();
                if (total == 0) {
                    assert (!this.lruMap.containsKey(fileNo));
                    assert (handleList.getAvailable() == 0);
                } else {
                    toRemove.addAll(handleList.removeAll());
                    this.removeFromLruList((int)fileNo);
                    this.openHandlesCount -= total;
                    Invariants.nonNegative(this.openHandlesCount);
                }
            });
            range.clear();
        }
        finally {
            this.poolLock.unlock();
            for (HybridLogFileHandle handle : toRemove) {
                handle.close();
            }
        }
    }

    @Override
    public void clearHandles(int upToFileno) {
        this.clearHandles(0, upToFileno);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.poolLock.lock();
        if (this.closed) {
            this.poolLock.unlock();
            return;
        }
        try {
            for (HybridLogFileHandleList handleList : this.poolMap.values()) {
                while (handleList.getAvailable() > 0) {
                    HybridLogFileHandle handle = handleList.remove();
                    handle.close();
                }
            }
            this.closed = true;
        }
        finally {
            this.poolLock.unlock();
        }
    }

    private boolean closeHandleIfPoolIsClosed(HybridLogFileHandle handle) {
        assert (this.poolLock.isHeldByCurrentThread());
        if (this.closed) {
            handle.close();
            return true;
        }
        return false;
    }

    int getOpenHandlesCount() {
        this.poolLock.lock();
        try {
            int n = this.openHandlesCount;
            return n;
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getCachedFreeHandlesCount() {
        int count = 0;
        this.poolLock.lock();
        try {
            for (HybridLogFileHandleList handleList : this.poolMap.values()) {
                count += handleList.getAvailable();
            }
        }
        finally {
            this.poolLock.unlock();
        }
        return count;
    }

    private void updateLruMap(int fileno) {
        Integer value = this.lruMap.get(fileno);
        assert (value != null);
    }

    private void addToLruMap(int fileno) {
        assert (!this.lruMap.containsKey(fileno));
        this.lruMap.put(fileno, fileno);
    }

    private void removeFromLruList(int fileno) {
        Integer value = this.lruMap.remove(fileno);
        assert (value != null);
    }

    private void checkClosed() {
        assert (this.poolLock.isHeldByCurrentThread());
        if (this.closed) {
            this.poolLock.unlock();
            throw new DeviceException(String.format("HybridLog handles pool is closed for store %d", this.storeId));
        }
    }

    private class HybridLogFileHandleList {
        private int total = 1;
        private final LinkedList<HybridLogFileHandle> handleList = new LinkedList();

        private HybridLogFileHandleList() {
        }

        boolean validateSize() {
            assert (HybridLogFileHandlePoolImpl.this.poolLock.isHeldByCurrentThread());
            assert (this.total > 0 && this.total >= this.handleList.size() && HybridLogFileHandlePoolImpl.this.openHandlesCount >= this.total) : "total=" + this.total + ", handleList.size()=" + this.handleList.size() + ", openHandlesCount=" + HybridLogFileHandlePoolImpl.access$200(HybridLogFileHandlePoolImpl.this);
            return true;
        }

        int getAvailable() {
            assert (HybridLogFileHandlePoolImpl.this.poolLock.isHeldByCurrentThread());
            return this.handleList.size();
        }

        int getTotal() {
            assert (HybridLogFileHandlePoolImpl.this.poolLock.isHeldByCurrentThread());
            return this.total;
        }

        HybridLogFileHandle poll() {
            assert (HybridLogFileHandlePoolImpl.this.poolLock.isHeldByCurrentThread());
            return this.handleList.size() > 0 ? this.handleList.poll() : null;
        }

        HybridLogFileHandle remove() {
            assert (HybridLogFileHandlePoolImpl.this.poolLock.isHeldByCurrentThread());
            assert (this.total > 0 && this.handleList.size() > 0);
            HybridLogFileHandle handle = this.handleList.poll();
            --this.total;
            return handle;
        }

        Collection<HybridLogFileHandle> removeAll() {
            assert (HybridLogFileHandlePoolImpl.this.poolLock.isHeldByCurrentThread());
            assert (this.total > 0 && this.total == this.handleList.size());
            this.total = 0;
            return this.handleList;
        }

        void increaseTotal() {
            assert (HybridLogFileHandlePoolImpl.this.poolLock.isHeldByCurrentThread());
            ++this.total;
        }

        void decreaseTotal() {
            assert (HybridLogFileHandlePoolImpl.this.poolLock.isHeldByCurrentThread());
            assert (this.total > 0);
            --this.total;
        }

        void put(HybridLogFileHandle handle) {
            assert (HybridLogFileHandlePoolImpl.this.poolLock.isHeldByCurrentThread());
            this.handleList.add(handle);
        }
    }
}

