/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.device;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class HybridLogFileHandle {
    private static final ILogger LOGGER = Logger.getLogger(HybridLogFileHandle.class);
    private final File file;
    private final RandomAccessFile raf;
    private final int storeId;
    private final int fileno;

    public HybridLogFileHandle(File file, RandomAccessFile raf, int storeId, int fileno) {
        this.file = file;
        this.raf = raf;
        this.storeId = storeId;
        this.fileno = fileno;
    }

    public RandomAccessFile getRaf() {
        return this.raf;
    }

    public int getFileno() {
        return this.fileno;
    }

    public int getStoreId() {
        return this.storeId;
    }

    File getFile() {
        return this.file;
    }

    void close() {
        try {
            this.raf.close();
        }
        catch (IOException ioe) {
            LOGGER.warning(String.format("Close failed for log file %s", this.file.getPath()), ioe);
        }
    }

    public String toString() {
        return "HybridLogHandle(" + this.storeId + ", " + this.fileno + ")";
    }
}

