/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.compaction;

import com.hazelcast.internal.tstore.compaction.Compactor;
import com.hazelcast.internal.tstore.compaction.CompactorExecutor;
import com.hazelcast.internal.tstore.compaction.CompactorFutureTask;
import com.hazelcast.internal.tstore.compaction.CompactorScheduler;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

class CompactorSchedulerImpl
implements CompactorScheduler {
    private static final ILogger LOGGER = Logger.getLogger(CompactorSchedulerImpl.class);
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition notEmpty = this.lock.newCondition();
    private final Queue<CompactorFutureTask>[] queues;
    private final CompactorExecutor executor;
    private final SchedulerThread thread;
    private volatile boolean isTerminated;

    CompactorSchedulerImpl(CompactorExecutor executor) {
        this.executor = executor;
        Queue[] qs = new Queue[CompactorScheduler.Priority.values().length];
        for (int i = 0; i < qs.length; ++i) {
            qs[i] = new LinkedList();
        }
        this.queues = qs;
        this.thread = new SchedulerThread();
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> schedule(Compactor<?> compactor, CompactorScheduler.Priority priority) {
        if (this.isTerminated) {
            throw new IllegalStateException("the scheduler has been terminated");
        }
        this.lock.lock();
        try {
            int idx = this.idxInQueues(priority);
            CompactorFutureTask task = new CompactorFutureTask(compactor);
            compactor.register();
            this.queues[idx].offer(task);
            this.notEmpty.signal();
            CompactorFutureTask compactorFutureTask = task;
            return compactorFutureTask;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void terminate() {
        this.checkTerminated();
        this.isTerminated = true;
        this.thread.interrupt();
        this.executor.terminate();
    }

    private void checkTerminated() {
        if (this.isTerminated) {
            throw new IllegalStateException("the scheduler has already been terminated");
        }
    }

    private int idxInQueues(CompactorScheduler.Priority priority) {
        return this.queues.length - 1 - priority.ordinal();
    }

    private class SchedulerThread
    extends Thread {
        SchedulerThread() {
            super("compactor-scheduler-thread");
        }

        @Override
        public void run() {
            try {
                while (!this.isInterrupted()) {
                    this.run0();
                }
            }
            catch (InterruptedException ie) {
                this.interrupt();
            }
            catch (Throwable ignored) {
                LOGGER.warning(ignored);
            }
        }

        private void run0() throws InterruptedException {
            CompactorFutureTask task;
            CompactorSchedulerImpl.this.lock.lock();
            try {
                while ((task = this.takeNext()) == null && !this.isInterrupted()) {
                    CompactorSchedulerImpl.this.notEmpty.await();
                }
            }
            finally {
                CompactorSchedulerImpl.this.lock.unlock();
            }
            if (task != null) {
                this.schedule(task);
            }
        }

        private CompactorFutureTask takeNext() {
            assert (CompactorSchedulerImpl.this.lock.isHeldByCurrentThread());
            for (Queue q : CompactorSchedulerImpl.this.queues) {
                if (q.isEmpty()) continue;
                return (CompactorFutureTask)q.poll();
            }
            return null;
        }

        public void terminate() {
            this.interrupt();
        }

        private void schedule(CompactorFutureTask task) throws InterruptedException {
            CompactorSchedulerImpl.this.executor.submit(task);
        }
    }
}

