/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl;

import com.hazelcast.config.SerializationConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ManagedContext;
import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.memory.HazelcastMemoryManager;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.InputOutputFactory;
import com.hazelcast.internal.serialization.SerializationServiceBuilder;
import com.hazelcast.internal.serialization.impl.DefaultSerializationServiceBuilder;
import com.hazelcast.internal.serialization.impl.EnterpriseBufferPoolFactory;
import com.hazelcast.internal.serialization.impl.EnterpriseByteArrayInputOutputFactory;
import com.hazelcast.internal.serialization.impl.EnterpriseClusterVersionAware;
import com.hazelcast.internal.serialization.impl.EnterpriseSerializationServiceV1;
import com.hazelcast.internal.serialization.impl.EnterpriseUnsafeInputOutputFactory;
import com.hazelcast.internal.serialization.impl.bufferpool.BufferPoolFactory;
import com.hazelcast.internal.serialization.impl.compact.SchemaService;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.DataSerializableFactory;
import com.hazelcast.nio.serialization.PortableFactory;
import com.hazelcast.partition.PartitioningStrategy;
import java.nio.ByteOrder;
import java.util.function.Supplier;

public class EnterpriseSerializationServiceBuilder
extends DefaultSerializationServiceBuilder
implements SerializationServiceBuilder {
    private HazelcastMemoryManager memoryManager;
    private BufferPoolFactory bufferPoolFactory = new EnterpriseBufferPoolFactory();
    private EnterpriseClusterVersionAware clusterVersionAware;
    private boolean versionedSerializationEnabled;
    private boolean isCompatibility;

    public EnterpriseSerializationServiceBuilder setMemoryManager(HazelcastMemoryManager memoryManager) {
        this.memoryManager = memoryManager;
        return this;
    }

    @Override
    public EnterpriseSerializationServiceBuilder setVersion(byte version) {
        return (EnterpriseSerializationServiceBuilder)super.setVersion(version);
    }

    @Override
    public EnterpriseSerializationServiceBuilder setPortableVersion(int portableVersion) {
        return (EnterpriseSerializationServiceBuilder)super.setPortableVersion(portableVersion);
    }

    @Override
    public EnterpriseSerializationServiceBuilder setClassLoader(ClassLoader classLoader) {
        return (EnterpriseSerializationServiceBuilder)super.setClassLoader(classLoader);
    }

    @Override
    public EnterpriseSerializationServiceBuilder setConfig(SerializationConfig config) {
        return (EnterpriseSerializationServiceBuilder)super.setConfig(config);
    }

    @Override
    public EnterpriseSerializationServiceBuilder addDataSerializableFactory(int id, DataSerializableFactory factory) {
        return (EnterpriseSerializationServiceBuilder)super.addDataSerializableFactory(id, factory);
    }

    @Override
    public EnterpriseSerializationServiceBuilder addPortableFactory(int id, PortableFactory factory) {
        return (EnterpriseSerializationServiceBuilder)super.addPortableFactory(id, factory);
    }

    @Override
    public EnterpriseSerializationServiceBuilder addClassDefinition(ClassDefinition cd) {
        return (EnterpriseSerializationServiceBuilder)super.addClassDefinition(cd);
    }

    @Override
    public EnterpriseSerializationServiceBuilder setCheckClassDefErrors(boolean checkClassDefErrors) {
        return (EnterpriseSerializationServiceBuilder)super.setCheckClassDefErrors(checkClassDefErrors);
    }

    @Override
    public EnterpriseSerializationServiceBuilder setManagedContext(ManagedContext managedContext) {
        return (EnterpriseSerializationServiceBuilder)super.setManagedContext(managedContext);
    }

    @Override
    public EnterpriseSerializationServiceBuilder setUseNativeByteOrder(boolean useNativeByteOrder) {
        return (EnterpriseSerializationServiceBuilder)super.setUseNativeByteOrder(useNativeByteOrder);
    }

    @Override
    public EnterpriseSerializationServiceBuilder setByteOrder(ByteOrder byteOrder) {
        return (EnterpriseSerializationServiceBuilder)super.setByteOrder(byteOrder);
    }

    @Override
    public EnterpriseSerializationServiceBuilder setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        return (EnterpriseSerializationServiceBuilder)super.setHazelcastInstance(hazelcastInstance);
    }

    @Override
    public EnterpriseSerializationServiceBuilder setEnableCompression(boolean enableCompression) {
        return (EnterpriseSerializationServiceBuilder)super.setEnableCompression(enableCompression);
    }

    @Override
    public EnterpriseSerializationServiceBuilder setEnableSharedObject(boolean enableSharedObject) {
        return (EnterpriseSerializationServiceBuilder)super.setEnableSharedObject(enableSharedObject);
    }

    @Override
    public EnterpriseSerializationServiceBuilder setAllowUnsafe(boolean allowUnsafe) {
        return (EnterpriseSerializationServiceBuilder)super.setAllowUnsafe(allowUnsafe);
    }

    @Override
    public EnterpriseSerializationServiceBuilder setPartitioningStrategy(PartitioningStrategy partitionStrategy) {
        return (EnterpriseSerializationServiceBuilder)super.setPartitioningStrategy(partitionStrategy);
    }

    @Override
    public EnterpriseSerializationServiceBuilder setInitialOutputBufferSize(int initialOutputBufferSize) {
        return (EnterpriseSerializationServiceBuilder)super.setInitialOutputBufferSize(initialOutputBufferSize);
    }

    @Override
    public EnterpriseSerializationServiceBuilder setSchemaService(SchemaService schemaService) {
        return (EnterpriseSerializationServiceBuilder)super.setSchemaService(schemaService);
    }

    public EnterpriseSerializationServiceBuilder setClusterVersionAware(EnterpriseClusterVersionAware clusterVersionAware) {
        this.clusterVersionAware = clusterVersionAware;
        return this;
    }

    public EnterpriseSerializationServiceBuilder setVersionedSerializationEnabled(boolean versionedSerializationEnabled) {
        this.versionedSerializationEnabled = versionedSerializationEnabled;
        return this;
    }

    @Override
    public EnterpriseSerializationServiceBuilder isCompatibility(boolean isCompatibility) {
        this.isCompatibility = isCompatibility;
        return this;
    }

    @Override
    public EnterpriseSerializationService build() {
        return (EnterpriseSerializationService)super.build();
    }

    @Override
    protected EnterpriseSerializationServiceV1 createSerializationService(InputOutputFactory inputOutputFactory, Supplier<RuntimeException> notActiveExceptionSupplier) {
        switch (this.version) {
            case 1: {
                EnterpriseSerializationServiceV1 serializationServiceV1 = ((EnterpriseSerializationServiceV1.Builder)((EnterpriseSerializationServiceV1.Builder)((EnterpriseSerializationServiceV1.Builder)((EnterpriseSerializationServiceV1.Builder)((EnterpriseSerializationServiceV1.Builder)((EnterpriseSerializationServiceV1.Builder)((EnterpriseSerializationServiceV1.Builder)((EnterpriseSerializationServiceV1.Builder)((EnterpriseSerializationServiceV1.Builder)((EnterpriseSerializationServiceV1.Builder)((EnterpriseSerializationServiceV1.Builder)((EnterpriseSerializationServiceV1.Builder)((EnterpriseSerializationServiceV1.Builder)((EnterpriseSerializationServiceV1.Builder)((EnterpriseSerializationServiceV1.Builder)((EnterpriseSerializationServiceV1.Builder)((EnterpriseSerializationServiceV1.Builder)((EnterpriseSerializationServiceV1.Builder)((EnterpriseSerializationServiceV1.Builder)EnterpriseSerializationServiceV1.enterpriseBuilder().withInputOutputFactory(inputOutputFactory)).withVersion(this.version)).withPortableVersion(this.portableVersion)).withClassLoader(this.classLoader)).withDataSerializableFactories(this.dataSerializableFactories)).withPortableFactories(this.portableFactories)).withManagedContext(this.managedContext)).withGlobalPartitionStrategy(this.partitioningStrategy)).withInitialOutputBufferSize(this.initialOutputBufferSize)).withBufferPoolFactory(this.bufferPoolFactory)).withMemoryManager(this.memoryManager).withEnableCompression(this.enableCompression)).withEnableSharedObject(this.enableSharedObject)).withClusterVersionAware(this.clusterVersionAware).withVersionedSerializationEnabled(this.versionedSerializationEnabled).withCompatibility(this.isCompatibility)).withNotActiveExceptionSupplier(notActiveExceptionSupplier)).withClassNameFilter(this.classNameFilter)).withCheckClassDefErrors(this.checkClassDefErrors)).withAllowOverrideDefaultSerializers(this.allowOverrideDefaultSerializers)).withCompactSerializationConfig(this.compactSerializationConfig)).withSchemaService(this.schemaService)).build();
                serializationServiceV1.registerClassDefinitions(this.classDefinitions);
                return serializationServiceV1;
            }
        }
        throw new IllegalArgumentException("Serialization version is not supported!");
    }

    @Override
    protected InputOutputFactory createInputOutputFactory() {
        this.overrideByteOrder();
        if (this.byteOrder == null) {
            this.byteOrder = ByteOrder.BIG_ENDIAN;
        }
        if (this.useNativeByteOrder || this.byteOrder == ByteOrder.nativeOrder()) {
            this.byteOrder = ByteOrder.nativeOrder();
            if (this.allowUnsafe && GlobalMemoryAccessorRegistry.MEM_AVAILABLE) {
                return new EnterpriseUnsafeInputOutputFactory();
            }
        }
        return new EnterpriseByteArrayInputOutputFactory(this.byteOrder);
    }
}

