/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.monitor.impl.jmx;

import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.jmx.HazelcastMBean;
import com.hazelcast.internal.jmx.ManagedAnnotation;
import com.hazelcast.internal.jmx.ManagedDescription;
import com.hazelcast.internal.jmx.ManagementService;
import com.hazelcast.internal.monitor.LicenseInfo;
import com.hazelcast.internal.util.MapUtil;
import java.util.Map;

@ManagedDescription(value="HazelcastInstance.LicenseInfo")
public class LicenseInfoMBean
extends HazelcastMBean<LicenseInfo> {
    public LicenseInfoMBean(LicenseInfo licenseInfo, Node node, ManagementService service) {
        super(licenseInfo, service);
        Map<String, String> properties = MapUtil.createHashMap(2);
        properties.put("type", ManagementService.quote("HazelcastInstance.LicenseInfo"));
        properties.put("name", ManagementService.quote("node" + node.address));
        properties.put("instance", ManagementService.quote(node.nodeEngine.getHazelcastInstance().getName()));
        this.setObjectName(properties);
    }

    @ManagedAnnotation(value="maxNodeCountAllowed")
    @ManagedDescription(value="Maximum nodes allowed to form a cluster under the current license")
    public String getMaxNodeCountAllowed() {
        return String.valueOf(((LicenseInfo)this.managedObject).getMaxNodeCountAllowed());
    }

    @ManagedAnnotation(value="expiryDate")
    @ManagedDescription(value="The expiry date of the current license")
    public String getExpiryDate() {
        return String.valueOf(((LicenseInfo)this.managedObject).getExpirationTime());
    }

    @ManagedAnnotation(value="typeCode")
    @ManagedDescription(value="The type code of the current license")
    public String getTypeCode() {
        if (((LicenseInfo)this.managedObject).getType() != null) {
            return String.valueOf(((LicenseInfo)this.managedObject).getType().getCode());
        }
        return String.valueOf(-1);
    }

    @ManagedAnnotation(value="type")
    @ManagedDescription(value="The type of the current license")
    public String getType() {
        if (((LicenseInfo)this.managedObject).getType() != null) {
            return ((LicenseInfo)this.managedObject).getType().getText();
        }
        return "null";
    }

    @ManagedAnnotation(value="ownerEmail")
    @ManagedDescription(value="The email of the owner on the current license")
    public String getOwnerEmail() {
        return ((LicenseInfo)this.managedObject).getOwnerEmail();
    }

    @ManagedAnnotation(value="companyName")
    @ManagedDescription(value="The name of the company on the current license")
    public String getCompanyName() {
        return ((LicenseInfo)this.managedObject).getCompanyName();
    }

    @ManagedAnnotation(value="keyHash")
    @ManagedDescription(value="SHA-256 hash of license key of the current license as a Base64 encoded string")
    public String getKeyHash() {
        return ((LicenseInfo)this.managedObject).getKeyHash();
    }
}

