/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.memory.impl;

import com.hazelcast.config.NativeMemoryConfig;
import com.hazelcast.config.PersistentMemoryConfig;
import com.hazelcast.config.PersistentMemoryMode;
import com.hazelcast.internal.memory.impl.MemkindKind;

public final class MemkindUtil {
    public static final String HD_MEMKIND = "hazelcast.hd.memkind";
    public static final String HD_MEMKIND_HUGEPAGES = "hazelcast.hd.memkind.hugepages";

    private MemkindUtil() {
    }

    public static boolean shouldUseMemkindMalloc(NativeMemoryConfig config) {
        PersistentMemoryConfig pmemConfig = config.getPersistentMemoryConfig();
        return pmemConfig.isEnabled() || MemkindUtil.useMemkind();
    }

    static boolean useMemkind() {
        return "true".equalsIgnoreCase(System.getProperty(HD_MEMKIND));
    }

    static boolean useMemkindHugePages() {
        return "true".equalsIgnoreCase(System.getProperty(HD_MEMKIND_HUGEPAGES));
    }

    static MemkindKind configuredKindForMemkindMalloc(PersistentMemoryConfig pmemConfig) {
        if (!MemkindUtil.useMemkind() && pmemConfig.isEnabled() && PersistentMemoryMode.SYSTEM_MEMORY == pmemConfig.getMode()) {
            return MemkindKind.PMEM_DAX_KMEM;
        }
        if (MemkindUtil.useMemkind()) {
            if (MemkindUtil.useMemkindHugePages()) {
                return MemkindKind.DRAM_HUGEPAGES;
            }
            return MemkindKind.DRAM;
        }
        throw new IllegalStateException("Could not determine the Memkind kind");
    }
}

