/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.memory.impl;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.memory.impl.MemkindKind;
import com.hazelcast.internal.memory.impl.MemkindPmemMalloc;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class MemkindHeap {
    public static final String PERSISTENT_MEMORY_CHECK_DISABLED_PROPERTY = "hazelcast.persistent.memory.check.disable";
    private static final String LIB_PATH = "libhazelcast-pmem/linux-x86_64/";
    private static final String LIBHAZELCAST_PMEM_SO = "libhazelcast-pmem.so";
    private static final String[] LIBS = new String[]{"libhazelcast-pmem.so", "libmemkind.so.0", "libnuma.so.1", "libpmem.so.1"};
    private static final ILogger LOGGER = Logger.getLogger(MemkindHeap.class);
    private final int numaNode;
    private final Object closeHeapLock = new Object();
    private final long handle;
    private final String name;
    private boolean isPoolOpen;

    protected MemkindHeap(long handle, int numaNode, String name) {
        this.handle = handle;
        this.numaNode = numaNode;
        this.name = name;
        this.isPoolOpen = true;
    }

    static synchronized MemkindHeap createPmemHeap(String path, long size, int numaNode) {
        long heapHandle;
        Path pmemFilePath = Paths.get(path, new String[0]);
        String pmemDir = MemkindHeap.parentIfExists(MemkindHeap.parentIfExists(pmemFilePath)).toString();
        try {
            heapHandle = MemkindHeap.createPmemHeap0(path, size);
        }
        catch (IOException e) {
            LOGGER.severe("Unable to create persistent memory heap at " + pmemDir, e);
            MemkindHeap.deleteFile(pmemFilePath);
            throw new HazelcastException("Unable to create persistent memory heap at " + pmemDir, e);
        }
        if (MemkindHeap.isPersistentMemoryCheckEnabled() && !MemkindHeap.isPmem0(heapHandle)) {
            LOGGER.severe(pmemDir + " is not a persistent memory. Check persistent-memory-directory configuration and restart member again.");
            MemkindHeap.closeHeap(heapHandle, pmemDir);
            MemkindHeap.deleteFile(pmemFilePath);
            throw new HazelcastException(pmemFilePath.toAbsolutePath() + " is not a persistent memory");
        }
        return new MemkindHeap(heapHandle, numaNode, pmemDir);
    }

    private static boolean isPersistentMemoryCheckEnabled() {
        return !"true".equalsIgnoreCase(System.getProperty(PERSISTENT_MEMORY_CHECK_DISABLED_PROPERTY, "false"));
    }

    private static Path parentIfExists(Path path) {
        return path.getParent() != null ? path.getParent() : path;
    }

    static synchronized MemkindHeap createHeap(MemkindKind kind, long size) {
        long heapHandle = MemkindHeap.createHeap0(kind.ordinal(), size);
        if (heapHandle == 0L) {
            LOGGER.severe("Unable to create heap with the requested kind " + (Object)((Object)kind));
            throw new HazelcastException("Unable to create heap with the requested kind " + (Object)((Object)kind));
        }
        return new MemkindHeap(heapHandle, -1, kind.name());
    }

    private static void closeHeap(long heapHandle, String name) {
        try {
            MemkindHeap.closeHeap0(heapHandle);
            LOGGER.fine("Closed heap " + name);
        }
        catch (RuntimeException e) {
            LOGGER.fine("Unable to close heap " + name);
        }
    }

    private static void deleteFile(Path filePath) {
        try {
            Files.deleteIfExists(filePath);
        }
        catch (IOException e1) {
            LOGGER.fine("Unable to delete " + filePath);
        }
    }

    private static String extractBundledLib() {
        try {
            Path tmpDir = Files.createTempDirectory("hz_", new FileAttribute[0]).toAbsolutePath();
            tmpDir.toFile().deleteOnExit();
            String tmpDirStr = tmpDir.toString();
            for (String lib : LIBS) {
                String libraryPath = LIB_PATH + lib;
                try (InputStream src = MemkindHeap.class.getClassLoader().getResourceAsStream(libraryPath);){
                    if (src == null) {
                        throw new RuntimeException("Cannot find native library at : " + libraryPath);
                    }
                    Path destPath = Paths.get(tmpDirStr, lib);
                    LOGGER.fine(String.format("Copying %s to the temporary directory %s", libraryPath, destPath));
                    Files.copy(src, destPath, new CopyOption[0]);
                    destPath.toFile().deleteOnExit();
                }
                catch (Throwable t) {
                    throw ExceptionUtil.rethrow(t);
                }
            }
            return Paths.get(tmpDirStr, LIBHAZELCAST_PMEM_SO).toAbsolutePath().toString();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    private static native void init0();

    private static native long createPmemHeap0(String var0, long var1) throws IOException;

    private static native long createHeap0(int var0, long var1);

    private static native void closeHeap0(long var0);

    private static native boolean isPmem0(long var0);

    private static native long alloc0(long var0, long var2);

    private static native long realloc0(long var0, long var2);

    private static native void free0(long var0);

    String getName() {
        return this.name;
    }

    int getNumaNode() {
        return this.numaNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        Object object = this.closeHeapLock;
        synchronized (object) {
            if (this.isPoolOpen) {
                MemkindHeap.closeHeap(this.handle, this.name);
                this.isPoolOpen = false;
            }
        }
    }

    long allocate(long size) {
        return MemkindHeap.alloc0(this.handle, size);
    }

    long realloc(long address, long size) {
        if (address == 0L) {
            return this.allocate(size);
        }
        return MemkindHeap.realloc0(address, size);
    }

    void free(long address) {
        MemkindHeap.free0(address);
    }

    public String toString() {
        return "MemkindHeap{name='" + this.name + '\'' + ", numaNode=" + this.numaNode + ", handle=" + this.handle + ", isPoolOpen=" + this.isPoolOpen + '}';
    }

    static {
        MemkindPmemMalloc.checkPlatform();
        System.load(MemkindHeap.extractBundledLib());
        try {
            MemkindHeap.init0();
        }
        catch (Exception ex) {
            throw new HazelcastException("Could not initialize properly", ex);
        }
    }
}

