/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.memory;

import com.hazelcast.internal.memory.GlobalMemoryAccessor;
import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.memory.HeapMemoryAccessor;

public class MemoryBlock {
    protected long address = 0L;
    protected int size;
    private final GlobalMemoryAccessor memoryAccessor;

    public MemoryBlock() {
        this.memoryAccessor = GlobalMemoryAccessorRegistry.MEM;
    }

    public MemoryBlock(GlobalMemoryAccessor memoryAccessor) {
        this.memoryAccessor = memoryAccessor;
    }

    public MemoryBlock(long address, int size) {
        this.memoryAccessor = GlobalMemoryAccessorRegistry.MEM;
        this.address = address;
        this.size = size;
    }

    protected MemoryBlock(GlobalMemoryAccessor memoryAccessor, long address, int size) {
        this.memoryAccessor = memoryAccessor;
        this.address = address;
        this.size = size;
    }

    public final byte readByte(long offset) {
        if (offset >= (long)this.size || offset < 0L) {
            throw new IndexOutOfBoundsException("Size: " + this.size + ", Offset: " + offset + ", Length: " + 1);
        }
        return this.memoryAccessor.getByte(this.address + offset);
    }

    public final void writeByte(long offset, byte value) {
        if (offset >= (long)this.size || offset < 0L) {
            throw new IndexOutOfBoundsException("Size: " + this.size + ", Offset: " + offset + ", Length: " + 1);
        }
        this.memoryAccessor.putByte(this.address + offset, value);
    }

    public final int readInt(long offset) {
        if (offset + 4L > (long)this.size || offset < 0L) {
            throw new IndexOutOfBoundsException("Size: " + this.size + ", Offset: " + offset + ", Length: " + 4);
        }
        return this.memoryAccessor.getInt(this.address + offset);
    }

    public final void writeInt(long offset, int value) {
        if (offset + 4L > (long)this.size || offset < 0L) {
            throw new IndexOutOfBoundsException("Size: " + this.size + ", Offset: " + offset + ", Length: " + 4);
        }
        this.memoryAccessor.putInt(this.address + offset, value);
    }

    public final long readLong(long offset) {
        if (offset + 8L > (long)this.size || offset < 0L) {
            throw new IndexOutOfBoundsException("Size: " + this.size + ", Offset: " + offset + ", Length: " + 8);
        }
        return this.memoryAccessor.getLong(this.address + offset);
    }

    public final void writeLong(long offset, long value) {
        if (offset + 8L > (long)this.size || offset < 0L) {
            throw new IndexOutOfBoundsException("Size: " + this.size + ", Offset: " + offset + ", Length: " + 8);
        }
        this.memoryAccessor.putLong(this.address + offset, value);
    }

    public final char readChar(long offset) {
        if (offset + 2L > (long)this.size || offset < 0L) {
            throw new IndexOutOfBoundsException("Size: " + this.size + ", Offset: " + offset + ", Length: " + 2);
        }
        return this.memoryAccessor.getChar(this.address + offset);
    }

    public final void writeChar(long offset, char value) {
        if (offset + 2L > (long)this.size || offset < 0L) {
            throw new IndexOutOfBoundsException("Size: " + this.size + ", Offset: " + offset + ", Length: " + 2);
        }
        this.memoryAccessor.putChar(this.address + offset, value);
    }

    public final double readDouble(long offset) {
        if (offset + 8L > (long)this.size || offset < 0L) {
            throw new IndexOutOfBoundsException("Size: " + this.size + ", Offset: " + offset + ", Length: " + 8);
        }
        return this.memoryAccessor.getDouble(this.address + offset);
    }

    public final void writeDouble(long offset, double value) {
        if (offset + 8L > (long)this.size || offset < 0L) {
            throw new IndexOutOfBoundsException("Size: " + this.size + ", Offset: " + offset + ", Length: " + 8);
        }
        this.memoryAccessor.putDouble(this.address + offset, value);
    }

    public final float readFloat(long offset) {
        if (offset + 4L > (long)this.size || offset < 0L) {
            throw new IndexOutOfBoundsException("Size: " + this.size + ", Offset: " + offset + ", Length: " + 4);
        }
        return this.memoryAccessor.getFloat(this.address + offset);
    }

    public final void writeFloat(long offset, float value) {
        if (offset + 4L > (long)this.size || offset < 0L) {
            throw new IndexOutOfBoundsException("Size: " + this.size + ", Offset: " + offset + ", Length: " + 4);
        }
        this.memoryAccessor.putFloat(this.address + offset, value);
    }

    public final short readShort(long offset) {
        if (offset + 2L > (long)this.size || offset < 0L) {
            throw new IndexOutOfBoundsException("Size: " + this.size + ", Offset: " + offset + ", Length: " + 2);
        }
        return this.memoryAccessor.getShort(this.address + offset);
    }

    public final void writeShort(long offset, short value) {
        if (offset + 2L > (long)this.size || offset < 0L) {
            throw new IndexOutOfBoundsException("Size: " + this.size + ", Offset: " + offset + ", Length: " + 2);
        }
        this.memoryAccessor.putShort(this.address + offset, value);
    }

    public final void copyFromByteArray(long destinationOffset, byte[] source, int offset, int length) {
        this.copyFrom(destinationOffset, source, HeapMemoryAccessor.ARRAY_BYTE_BASE_OFFSET + offset, length);
    }

    public final void copyFrom(long destinationOffset, Object source, long offset, int length) {
        if (destinationOffset + (long)length > (long)this.size || destinationOffset < 0L || offset < 0L) {
            throw new IndexOutOfBoundsException("Destination offset: " + destinationOffset + ", length: " + length + ", size: " + this.size);
        }
        long realAddress = this.address + destinationOffset;
        while (length > 0) {
            int chunk = Math.min(length, 0x100000);
            this.memoryAccessor.copyMemory(source, offset, null, realAddress, chunk);
            length -= chunk;
            offset += (long)chunk;
            realAddress += (long)chunk;
        }
    }

    public final void copyToByteArray(long sourceOffset, byte[] destination, int offset, int length) {
        this.copyTo(sourceOffset, destination, HeapMemoryAccessor.ARRAY_BYTE_BASE_OFFSET + offset, length);
    }

    public final void copyTo(long sourceOffset, Object destination, long offset, int length) {
        if (sourceOffset + (long)length > (long)this.size || sourceOffset < 0L || offset < 0L) {
            throw new IndexOutOfBoundsException("Source offset: " + sourceOffset + ", length: " + length + ", size: " + this.size);
        }
        long realAddress = this.address + sourceOffset;
        while (length > 0) {
            int chunk = Math.min(length, 0x100000);
            this.memoryAccessor.copyMemory(null, realAddress, destination, offset, chunk);
            length -= chunk;
            offset += (long)chunk;
            realAddress += (long)chunk;
        }
    }

    public final void zero() {
        this.memoryAccessor.setMemory(this.address, this.size, (byte)0);
    }

    public final long address() {
        return this.address;
    }

    public final int size() {
        return this.size;
    }

    protected final void setAddress(long address) {
        this.address = address;
    }

    protected final void setSize(int size) {
        this.size = size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemoryBlock block = (MemoryBlock)o;
        return this.address == block.address && this.size == block.size;
    }

    public int hashCode() {
        int result = (int)(this.address ^ this.address >>> 32);
        result = 31 * result + this.size;
        return result;
    }

    public String toString() {
        return "MemoryBlock{address=" + this.address + ", size=" + this.size + '}';
    }
}

