/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.io;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.hotrestart.HotRestartException;
import com.hazelcast.internal.hotrestart.impl.encryption.EncryptionManager;
import com.hazelcast.internal.hotrestart.impl.io.ChunkFileOut;
import com.hazelcast.internal.memory.impl.UnsafeUtil;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.JVMUtil;
import com.hazelcast.logging.Logger;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;

public class TombFileAccessor
implements Closeable {
    private static final MethodHandle BUFFER_CLEANER_MH = TombFileAccessor.getCleanerMethodHandle();
    private static final int SKIP_BUFFER_SIZE = 1024;
    private AccessorImpl accessorImpl;
    private long recordSeq;
    private long keyPrefix;
    private int recordSize;

    public TombFileAccessor(File tombFile, EncryptionManager encryptionMgr) {
        this.accessorImpl = encryptionMgr.isEncryptionEnabled() ? new EncryptedAccessor(tombFile, encryptionMgr) : new MemoryMappedAccessor(tombFile);
    }

    public int loadAndCopyTombstone(int pos, ChunkFileOut out) throws IOException {
        assert (this.accessorImpl != null) : "Accessor has been closed";
        return this.accessorImpl.loadAndCopyTombstone(pos, out);
    }

    public final long recordSeq() {
        return this.recordSeq;
    }

    public final long keyPrefix() {
        return this.keyPrefix;
    }

    public final int recordSize() {
        return this.recordSize;
    }

    @Override
    public final void close() {
        this.accessorImpl.close();
        this.accessorImpl = null;
    }

    private static MethodHandle getCleanerMethodHandle() {
        MappedByteBuffer buf = TombFileAccessor.initTmpBuffer();
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodType cleanerMethodType = MethodType.methodType(Void.TYPE, ByteBuffer.class);
        try {
            MethodHandle invokeCleanerHandler = lookup.findVirtual(UnsafeUtil.UNSAFE.getClass(), "invokeCleaner", cleanerMethodType).bindTo(UnsafeUtil.UNSAFE);
            invokeCleanerHandler.invokeExact(buf);
            return invokeCleanerHandler;
        }
        catch (Throwable t) {
            try {
                Class<?> bufferClass = buf.getClass();
                JDK8CleanerAdapter legacyCleaner = new JDK8CleanerAdapter(bufferClass);
                MethodHandle invokeCleanerHandler = lookup.findVirtual(JDK8CleanerAdapter.class, "clean", cleanerMethodType).bindTo(legacyCleaner);
                invokeCleanerHandler.invokeExact(buf);
                return invokeCleanerHandler;
            }
            catch (Throwable tt) {
                throw new HazelcastException("Unable to find a suitable strategy for cleaning direct ByteBuffers. This is unexpected. Please open a support ticket and include your JVM version.");
            }
        }
    }

    private static MappedByteBuffer initTmpBuffer() {
        MappedByteBuffer buf;
        File file;
        FileOutputStream fos = null;
        try {
            file = File.createTempFile("hzhr", ".tmp");
            fos = new FileOutputStream(file, true);
            fos.write("hz".getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            try {
                throw ExceptionUtil.rethrow(e);
            }
            catch (Throwable throwable) {
                IOUtil.closeResource(fos);
                throw throwable;
            }
        }
        IOUtil.closeResource(fos);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            buf = fis.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, 2L);
        }
        catch (IOException e) {
            try {
                throw ExceptionUtil.rethrow(e);
            }
            catch (Throwable throwable) {
                IOUtil.closeResource(fis);
                throw throwable;
            }
        }
        IOUtil.closeResource(fis);
        if (!file.delete()) {
            Logger.getLogger(TombFileAccessor.class).warning("Unable to remove a temporary file " + file.getAbsolutePath() + ", you can remove it manually.");
        }
        return buf;
    }

    private static class PositionAwareInputStream
    extends FilterInputStream {
        private long pos;
        private long mark;

        PositionAwareInputStream(InputStream in) {
            super(in);
        }

        public long position() {
            return this.pos;
        }

        @Override
        public int read() throws IOException {
            int b = super.read();
            if (b >= 0) {
                ++this.pos;
            }
            return b;
        }

        @Override
        public int read(@Nonnull byte[] b, int off, int len) throws IOException {
            int n = super.read(b, off, len);
            if (n > 0) {
                this.pos += (long)n;
            }
            return n;
        }

        @Override
        public long skip(long skip) throws IOException {
            long n = super.skip(skip);
            if (n > 0L) {
                this.pos += n;
            }
            return n;
        }

        @Override
        public void mark(int readlimit) {
            super.mark(readlimit);
            this.mark = this.pos;
        }

        @Override
        public void reset() throws IOException {
            super.reset();
            this.pos = this.mark;
        }
    }

    private final class EncryptedAccessor
    extends MemoryMappedAccessor {
        private byte[] skipBuffer;
        private PositionAwareInputStream in;
        private DataInputStream dataIn;

        EncryptedAccessor(File tombFile, EncryptionManager encryptionMgr) {
            super(tombFile);
            this.skipBuffer = new byte[1024];
            if (this.buf != null) {
                InputStream bbis = IOUtil.newInputStream(this.buf);
                this.in = new PositionAwareInputStream(encryptionMgr.wrap(bbis, tombFile.getParent()));
                this.dataIn = new DataInputStream(this.in);
            }
        }

        @Override
        public void close() {
            super.close();
            this.in = null;
            this.dataIn = null;
        }

        @Override
        public int loadAndCopyTombstone(int pos, ChunkFileOut out) throws IOException {
            assert (this.in != null) : "Tombstone chunk is empty or accessor has been closed";
            long n = (long)pos - this.in.position();
            if (n < 0L) {
                throw new HotRestartException("Tomb position not increasing monotonically");
            }
            this.skip(this.in, n);
            TombFileAccessor.this.recordSeq = this.dataIn.readLong();
            TombFileAccessor.this.keyPrefix = this.dataIn.readLong();
            int keySize = this.dataIn.readInt();
            out.writeTombstone(TombFileAccessor.this.recordSeq, TombFileAccessor.this.keyPrefix, this.in, keySize);
            TombFileAccessor.this.recordSize = (int)this.in.position() - pos;
            return TombFileAccessor.this.recordSize;
        }

        private void skip(InputStream in, long n) throws IOException {
            long remaining;
            int read;
            if ((long)in.available() >= n) {
                long skipped = in.skip(n);
                if (skipped == n) {
                    return;
                }
                n -= skipped;
            }
            if (n == 0L) {
                return;
            }
            for (remaining = n; remaining > 0L && (read = in.read(this.skipBuffer, 0, (int)Math.min(1024L, remaining))) >= 0; remaining -= (long)read) {
            }
            if (remaining > 0L) {
                throw new HotRestartException("Partial stream skip: " + (n - remaining) + ", requested: " + n);
            }
        }
    }

    private class MemoryMappedAccessor
    implements AccessorImpl {
        MappedByteBuffer buf;

        MemoryMappedAccessor(File tombFile) {
            FileChannel chan = null;
            try {
                chan = new FileInputStream(tombFile).getChannel();
                long size = chan.size();
                this.buf = size > 0L ? chan.map(FileChannel.MapMode.READ_ONLY, 0L, size) : null;
            }
            catch (IOException e) {
                try {
                    throw new HotRestartException("Failed to create tombstone file accessor", e);
                }
                catch (Throwable throwable) {
                    IOUtil.closeResource(chan);
                    throw throwable;
                }
            }
            IOUtil.closeResource(chan);
        }

        @Override
        public int loadAndCopyTombstone(int pos, ChunkFileOut out) throws IOException {
            assert (this.buf != null) : "Tombstone chunk is empty or accessor has been closed";
            JVMUtil.upcast(this.buf).position(pos);
            TombFileAccessor.this.recordSeq = this.buf.getLong();
            TombFileAccessor.this.keyPrefix = this.buf.getLong();
            int keySize = this.buf.getInt();
            out.writeTombstone(TombFileAccessor.this.recordSeq, TombFileAccessor.this.keyPrefix, this.buf, keySize);
            TombFileAccessor.this.recordSize = this.buf.position() - pos;
            return TombFileAccessor.this.recordSize;
        }

        @Override
        public void close() {
            if (this.buf != null) {
                try {
                    BUFFER_CLEANER_MH.invokeExact(this.buf);
                }
                catch (Throwable e) {
                    throw ExceptionUtil.rethrow(e);
                }
            }
            this.buf = null;
        }
    }

    private static interface AccessorImpl {
        public void close();

        public int loadAndCopyTombstone(int var1, ChunkFileOut var2) throws IOException;
    }

    static final class JDK8CleanerAdapter {
        private final Method getCleanerMethod;
        private final Method cleanMethod;

        JDK8CleanerAdapter(Class<?> bufferClass) throws NoSuchMethodException {
            Class<?> cleanerType;
            Method cleanMethod;
            Method getCleanerMethod = bufferClass.getMethod("cleaner", new Class[0]);
            if (!getCleanerMethod.isAccessible()) {
                getCleanerMethod.setAccessible(true);
            }
            if (!(cleanMethod = (cleanerType = getCleanerMethod.getReturnType()).getDeclaredMethod("clean", new Class[0])).isAccessible()) {
                cleanMethod.setAccessible(true);
            }
            this.getCleanerMethod = getCleanerMethod;
            this.cleanMethod = cleanMethod;
        }

        void clean(ByteBuffer buffer) throws InvocationTargetException, IllegalAccessException {
            Object jdkCleaner = this.getCleanerMethod.invoke((Object)buffer, new Object[0]);
            this.cleanMethod.invoke(jdkCleaner, new Object[0]);
        }
    }
}

