/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.io;

import com.hazelcast.hotrestart.HotRestartException;
import com.hazelcast.internal.hotrestart.impl.encryption.EncryptionManager;
import com.hazelcast.internal.hotrestart.impl.io.ChunkFileOut;
import com.hazelcast.internal.hotrestart.impl.io.ChunkFileRecord;
import com.hazelcast.internal.hotrestart.impl.io.ChunkFilesetCursor;
import com.hazelcast.internal.hotrestart.impl.io.EncryptedChunkFileOut;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.util.BufferingInputStream;
import com.hazelcast.internal.util.JVMUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;

public abstract class ChunkFileCursor
implements ChunkFileRecord {
    final ByteBuffer headerBuf;
    byte[] key;
    int truncationPoint;
    long seq;
    long prefix;
    private final File chunkFile;
    private final long chunkSeq;
    private InputStream in;
    private final EncryptionManager encryptionMgr;

    ChunkFileCursor(int headerSize, File chunkFile, EncryptionManager encryptionMgr) {
        this.chunkFile = chunkFile;
        this.headerBuf = ByteBuffer.allocate(headerSize);
        this.chunkSeq = ChunkFilesetCursor.seq(chunkFile);
        this.in = ChunkFileCursor.openChunkFile(chunkFile, encryptionMgr);
        this.encryptionMgr = encryptionMgr;
    }

    private static InputStream openChunkFile(File chunkFile, EncryptionManager encryptionMgr) {
        try {
            FileInputStream is = new FileInputStream(chunkFile);
            return encryptionMgr.wrap(new BufferingInputStream(is, 65536), chunkFile.getParent());
        }
        catch (FileNotFoundException e) {
            throw new HotRestartException("Failed to open chunk file " + chunkFile);
        }
    }

    public final boolean advance() {
        try {
            try {
                JVMUtil.upcast(this.headerBuf).clear();
                if (IOUtil.readFullyOrNothing(this.in, this.headerBuf.array())) {
                    this.loadRecord();
                    this.truncationPoint += this.size();
                    return true;
                }
                return false;
            }
            catch (EOFException e) {
                if (this.removeBrokenTailOfActiveFile()) {
                    return false;
                }
                throw e;
            }
        }
        catch (IOException e) {
            throw new HotRestartException(e);
        }
    }

    public final void close() {
        try {
            this.in.close();
        }
        catch (IOException e) {
            throw new HotRestartException("Failed to close chunk file " + this.chunkFile, e);
        }
        if (ChunkFilesetCursor.isActiveChunkFile(this.chunkFile) && this.chunkFile.exists()) {
            ChunkFilesetCursor.removeActiveSuffix(this.chunkFile);
        }
    }

    @Override
    public final long chunkSeq() {
        return this.chunkSeq;
    }

    @Override
    public final long recordSeq() {
        return this.seq;
    }

    @Override
    public final long prefix() {
        return this.prefix;
    }

    @Override
    public int size() {
        return this.headerBuf.capacity() + this.key.length;
    }

    @Override
    @SuppressFBWarnings(value={"EI"}, justification="Returned array is never modified")
    public byte[] key() {
        return this.key;
    }

    abstract void loadRecord() throws IOException;

    void loadCommonHeader() throws IOException {
        this.seq = this.headerBuf.getLong();
        this.prefix = this.headerBuf.getLong();
    }

    final byte[] readPayload(int size) throws EOFException {
        byte[] payload = new byte[size];
        try {
            IOUtil.readFully(this.in, payload);
            return payload;
        }
        catch (EOFException e) {
            throw e;
        }
        catch (IOException e) {
            throw new HotRestartException("Failed to read payload", e);
        }
    }

    private boolean removeBrokenTailOfActiveFile() {
        if (!ChunkFilesetCursor.isActiveChunkFile(this.chunkFile)) {
            return false;
        }
        if (this.encryptionMgr.isEncryptionEnabled()) {
            this.removeBrokenTailOfEncryptedChunk();
        } else {
            this.removeBrokenTail();
        }
        return true;
    }

    private void removeBrokenTail() {
        RandomAccessFile raf = null;
        try {
            this.in.close();
            raf = new RandomAccessFile(this.chunkFile, "rw");
            raf.setLength(this.truncationPoint);
            raf.getFD().sync();
        }
        catch (IOException e) {
            try {
                throw new HotRestartException(e);
            }
            catch (Throwable throwable) {
                IOUtil.closeResource(raf);
                throw throwable;
            }
        }
        IOUtil.closeResource(raf);
    }

    private void removeBrokenTailOfEncryptedChunk() {
        EncryptedChunkFileOut out = null;
        try {
            this.in.close();
            this.in = ChunkFileCursor.openChunkFile(this.chunkFile, this.encryptionMgr);
            File tmpFile = File.createTempFile(this.chunkFile.getName(), null, this.chunkFile.getParentFile());
            out = new EncryptedChunkFileOut(tmpFile, null, this.encryptionMgr.newWriteCipher(tmpFile.getParent()));
            for (int pos = 0; pos < this.truncationPoint; pos += this.size()) {
                JVMUtil.upcast(this.headerBuf).clear();
                IOUtil.readFully(this.in, this.headerBuf.array());
                this.loadRecord();
                this.writeRecord(out);
            }
            out.close();
            this.in.close();
            IOUtil.rename(tmpFile, this.chunkFile);
        }
        catch (IOException e) {
            try {
                throw new HotRestartException(e);
            }
            catch (Throwable throwable) {
                IOUtil.closeResource(out);
                IOUtil.closeResource(this.in);
                throw throwable;
            }
        }
        IOUtil.closeResource(out);
        IOUtil.closeResource(this.in);
    }

    abstract void writeRecord(ChunkFileOut var1);

    static final class Val
    extends ChunkFileCursor {
        private byte[] value;

        Val(File chunkFile, EncryptionManager encryptionMgr) {
            super(24, chunkFile, encryptionMgr);
        }

        @Override
        void loadRecord() throws IOException {
            this.loadCommonHeader();
            int keySize = this.headerBuf.getInt();
            int valueSize = this.headerBuf.getInt();
            this.key = this.readPayload(keySize);
            this.value = this.readPayload(valueSize);
        }

        @Override
        public byte[] value() {
            return this.value;
        }

        @Override
        public int filePos() {
            return 0;
        }

        @Override
        public int size() {
            return super.size() + this.value.length;
        }

        @Override
        void writeRecord(ChunkFileOut out) {
            out.writeValueRecord(this.seq, this.prefix, this.key, this.value);
        }
    }

    public static final class Tomb
    extends ChunkFileCursor {
        public Tomb(File chunkFile, EncryptionManager encryptionMgr) {
            super(20, chunkFile, encryptionMgr);
        }

        @Override
        void loadRecord() throws IOException {
            this.loadCommonHeader();
            this.key = this.readPayload(this.headerBuf.getInt());
        }

        @Override
        public int filePos() {
            return this.truncationPoint - this.size();
        }

        @Override
        public byte[] value() {
            return null;
        }

        @Override
        void writeRecord(ChunkFileOut out) {
            out.writeTombstone(this.seq, this.prefix, this.key);
        }
    }
}

