/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.gc.tracker;

import com.hazelcast.internal.hotrestart.impl.gc.tracker.Tracker;
import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;

final class TrackerOffHeap
extends Tracker {
    static final int SIZE = 16;
    private static final int CHUNK_SEQ_OFFSET = 0;
    private static final int GARBAGE_COUNT_OFFSET = 8;
    long address = 0L;

    TrackerOffHeap() {
    }

    @Override
    public long rawChunkSeq() {
        return GlobalMemoryAccessorRegistry.AMEM.getLong(this.address + 0L);
    }

    @Override
    public void setRawChunkSeq(long rawChunkSeqValue) {
        GlobalMemoryAccessorRegistry.AMEM.putLong(this.address + 0L, rawChunkSeqValue);
    }

    @Override
    public long garbageCount() {
        return GlobalMemoryAccessorRegistry.AMEM.getLong(this.address + 8L);
    }

    @Override
    public void setGarbageCount(long garbageCount) {
        GlobalMemoryAccessorRegistry.AMEM.putLong(this.address + 8L, garbageCount);
    }

    public String toString() {
        if (this.address == 0L) {
            return "(NULL)";
        }
        return "(" + this.chunkSeq() + ',' + this.isTombstone() + ',' + this.garbageCount() + ')';
    }
}

