/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.gc.tracker;

import com.hazelcast.internal.hotrestart.impl.gc.tracker.TrackerMap;
import com.hazelcast.internal.hotrestart.impl.gc.tracker.TrackerMapBase;

public abstract class Tracker {
    public final boolean isAlive() {
        return this.rawChunkSeq() != 0L;
    }

    public final long chunkSeq() {
        return this.isTombstone() ? -this.rawChunkSeq() : this.rawChunkSeq();
    }

    public final boolean isTombstone() {
        return this.rawChunkSeq() < 0L;
    }

    public final void moveToChunk(long destChunkSeq) {
        this.setLiveState(destChunkSeq, this.isTombstone());
    }

    public final void newLiveRecord(long chunkSeq, boolean freshIsTombstone, TrackerMap owner, boolean restarting) {
        TrackerMapBase ownr = (TrackerMapBase)owner;
        if (this.isAlive()) {
            boolean staleIsTombstone = this.isTombstone();
            if (staleIsTombstone) {
                if (!freshIsTombstone) {
                    ownr.replacedTombstoneWithValue();
                } else assert (restarting) : "Attempted to replace a tombstone with another tombstone";
            } else {
                this.incrementGarbageCount();
                if (freshIsTombstone) {
                    ownr.replacedValueWithTombstone();
                }
            }
        } else {
            ownr.added(freshIsTombstone);
        }
        this.setLiveState(chunkSeq, freshIsTombstone);
    }

    public final void retire(TrackerMap owner) {
        ((TrackerMapBase)owner).retired(this.isTombstone());
        this.setRawChunkSeq(0L);
    }

    public final void incrementGarbageCount() {
        this.setGarbageCount(this.garbageCount() + 1L);
    }

    public final boolean reduceGarbageCount(int amount) {
        this.setGarbageCount(this.garbageCount() - (long)amount);
        assert (this.garbageCount() >= 0L) : String.format("Global garbage count went below zero after decrementing by %,d:  %,d", amount, this.garbageCount());
        return this.garbageCount() == 0L;
    }

    final void resetGarbageCount() {
        this.setGarbageCount(0L);
    }

    final void setLiveState(long chunkSeq, boolean isTombstone) {
        assert (chunkSeq != 0L) : "Attempt to move a record to chunk zero";
        this.setRawChunkSeq(isTombstone ? -chunkSeq : chunkSeq);
    }

    public abstract long garbageCount();

    abstract void setGarbageCount(long var1);

    abstract long rawChunkSeq();

    abstract void setRawChunkSeq(long var1);
}

