/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.gc.record;

import com.hazelcast.internal.elastic.LongArray;
import com.hazelcast.internal.hotrestart.KeyHandleOffHeap;
import com.hazelcast.internal.hotrestart.impl.SortedBySeqRecordCursor;
import com.hazelcast.internal.hotrestart.impl.gc.MutatorCatchup;
import com.hazelcast.internal.hotrestart.impl.gc.record.Record;
import com.hazelcast.internal.hotrestart.impl.gc.record.RecordOffHeap;
import com.hazelcast.internal.memory.MemoryAccessor;
import com.hazelcast.internal.memory.MemoryManager;
import com.hazelcast.internal.util.hashslot.impl.HashSlotArray16byteKeyImpl;

final class SortedBySeqRecordCursorOffHeap
implements SortedBySeqRecordCursor,
KeyHandleOffHeap {
    private final LongArray seqsAndSlotBases;
    private final int size;
    private final RecordOffHeap r = new RecordOffHeap();
    private final MemoryAccessor mem;
    private int position = -1;

    SortedBySeqRecordCursorOffHeap(LongArray seqsAndSlotBases, int actualSize, MemoryManager memMgr, MutatorCatchup mc) {
        this.size = actualSize;
        this.mem = memMgr.getAccessor();
        this.seqsAndSlotBases = SortedBySeqRecordCursorOffHeap.sortedByRecordSeq(seqsAndSlotBases, actualSize, memMgr, mc);
    }

    @Override
    public boolean advance() {
        if (this.position != this.size - 1) {
            this.position += 2;
            this.r.address = HashSlotArray16byteKeyImpl.addrOfValueAt(this.seqsAndSlotBases.get(this.position));
            return true;
        }
        this.r.address = 0L;
        return false;
    }

    @Override
    public Record asRecord() {
        return this.r;
    }

    @Override
    public KeyHandleOffHeap asKeyHandle() {
        assert (this.r.address != 0L) : "Invalid cursor state";
        return this;
    }

    @Override
    public long address() {
        assert (this.r.address != 0L) : "Invalid cursor state";
        return this.mem.getLong(HashSlotArray16byteKeyImpl.addrOfKey1At(this.seqsAndSlotBases.get(this.position)));
    }

    @Override
    public long sequenceId() {
        assert (this.r.address != 0L) : "Invalid cursor state";
        return this.mem.getLong(HashSlotArray16byteKeyImpl.addrOfKey2At(this.seqsAndSlotBases.get(this.position)));
    }

    @Override
    public void dispose() {
        this.seqsAndSlotBases.dispose();
    }

    private static LongArray sortedByRecordSeq(LongArray seqsAndSlotBases, int size, MemoryManager memMgr, MutatorCatchup mc) {
        LongArray from = seqsAndSlotBases;
        LongArray to = new LongArray(memMgr, size);
        mc.catchupNow();
        for (int width = 2; width < size; width *= 2) {
            for (int i = 0; i < size; i += 2 * width) {
                SortedBySeqRecordCursorOffHeap.bottomUpMerge(from, i, Math.min(i + width, size), Math.min(i + 2 * width, size), to, mc);
            }
            LongArray fromBackup = from;
            from = to;
            to = fromBackup;
        }
        to.dispose();
        return from;
    }

    private static void bottomUpMerge(LongArray from, int leftStart, int rightStart, int rightEnd, LongArray to, MutatorCatchup mc) {
        int currLeft = leftStart;
        int currRight = rightStart;
        for (int i = leftStart; i < rightEnd; i += 2) {
            if (currLeft < rightStart && (currRight >= rightEnd || from.get(currLeft) <= from.get(currRight))) {
                to.set(i, from.get(currLeft));
                to.set(i + 1, from.get(currLeft + 1));
                currLeft += 2;
            } else {
                to.set(i, from.get(currRight));
                to.set(i + 1, from.get(currRight + 1));
                currRight += 2;
            }
            mc.catchupAsNeeded();
        }
    }
}

