/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.gc.record;

import com.hazelcast.internal.hotrestart.KeyHandle;
import com.hazelcast.internal.hotrestart.impl.gc.record.Record;
import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;

public final class RecordOffHeap
extends Record {
    public static final int VALUE_RECORD_SIZE = 24;
    public static final int TOMBSTONE_SIZE = 16;
    private static final int SEQ_OFFSET = 0;
    private static final int SIZE_OFFSET = 8;
    private static final int ADDITIONAL_INT_OFFSET = 12;
    private static final int KEY_PREFIX_OFFSET = 16;
    long address = 0L;

    @Override
    public long rawSeqValue() {
        return GlobalMemoryAccessorRegistry.AMEM.getLong(this.address + 0L);
    }

    @Override
    public int rawSizeValue() {
        return GlobalMemoryAccessorRegistry.AMEM.getInt(this.address + 8L);
    }

    @Override
    public long keyPrefix(KeyHandle ignored) {
        assert (!this.isTombstone()) : "Attempt to access key prefix of a tombstone";
        return GlobalMemoryAccessorRegistry.AMEM.getLong(this.address + 16L);
    }

    void setKeyPrefix(long prefix) {
        assert (!this.isTombstone()) : "Attempt to set key prefix on a tombstone";
        GlobalMemoryAccessorRegistry.AMEM.putLong(this.address + 16L, prefix);
    }

    @Override
    public int additionalInt() {
        return GlobalMemoryAccessorRegistry.AMEM.getInt(this.address + 12L);
    }

    @Override
    public void setAdditionalInt(int value) {
        GlobalMemoryAccessorRegistry.AMEM.putInt(this.address + 12L, value);
    }

    @Override
    public void negateSeq() {
        GlobalMemoryAccessorRegistry.AMEM.putLong(this.address + 0L, -GlobalMemoryAccessorRegistry.AMEM.getLong(this.address + 0L));
    }

    @Override
    public int decrementGarbageCount() {
        int newCount = this.garbageCount() - 1;
        this.setGarbageCount(newCount);
        return newCount;
    }

    @Override
    public void incrementGarbageCount() {
        this.setGarbageCount(this.garbageCount() + 1);
    }

    @Override
    public void setRawSeqSize(long rawSeqValue, int rawSizeValue) {
        GlobalMemoryAccessorRegistry.AMEM.putLong(this.address + 0L, rawSeqValue);
        GlobalMemoryAccessorRegistry.AMEM.putInt(this.address + 8L, rawSizeValue);
    }
}

