/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.gc.record;

import com.hazelcast.internal.hotrestart.KeyHandle;
import com.hazelcast.internal.hotrestart.impl.SortedBySeqRecordCursor;
import com.hazelcast.internal.hotrestart.impl.gc.MutatorCatchup;
import com.hazelcast.internal.hotrestart.impl.gc.record.Record;
import com.hazelcast.internal.hotrestart.impl.gc.record.RecordMap;
import com.hazelcast.internal.hotrestart.impl.gc.record.RecordOnHeap;
import com.hazelcast.internal.hotrestart.impl.gc.record.SortedBySeqRecordCursorOnHeap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class RecordMapOnHeap
implements RecordMap {
    private final Map<KeyHandle, Record> records = new HashMap<KeyHandle, Record>();

    @Override
    public Record putIfAbsent(long ignored, KeyHandle kh, long seq, int size, boolean isTombstone, int additionalInt) {
        Record rec = this.records.get(kh);
        if (rec != null) {
            return rec;
        }
        this.records.put(kh, new RecordOnHeap(seq, size, isTombstone, additionalInt));
        return null;
    }

    @Override
    public Record get(KeyHandle kh) {
        return this.records.get(kh);
    }

    @Override
    public int size() {
        return this.records.size();
    }

    @Override
    public SortedBySeqRecordCursor sortedBySeqCursor(int liveRecordCount, RecordMap[] recordMaps, MutatorCatchup mc) {
        ArrayList<KeyHandle> khs = new ArrayList<KeyHandle>(liveRecordCount);
        ArrayList<Record> recs = new ArrayList<Record>(liveRecordCount);
        for (RecordMap map : recordMaps) {
            RecordMap.Cursor c = map.cursor();
            while (c.advance()) {
                Record r = c.asRecord();
                if (!r.isAlive()) continue;
                khs.add(c.toKeyHandle());
                recs.add(r);
            }
        }
        mc.catchupNow();
        return new SortedBySeqRecordCursorOnHeap(khs, recs, mc);
    }

    @Override
    public RecordMap.Cursor cursor() {
        return new HeapCursor();
    }

    @Override
    public RecordMap toStable() {
        return this;
    }

    @Override
    public void dispose() {
    }

    private final class HeapCursor
    implements RecordMap.Cursor {
        private final Iterator<Map.Entry<KeyHandle, Record>> iter;
        private Map.Entry<KeyHandle, Record> current;

        private HeapCursor() {
            this.iter = RecordMapOnHeap.this.records.entrySet().iterator();
        }

        @Override
        public boolean advance() {
            if (!this.iter.hasNext()) {
                return false;
            }
            this.current = this.iter.next();
            return true;
        }

        @Override
        public KeyHandle toKeyHandle() {
            return this.current.getKey();
        }

        @Override
        public Record asRecord() {
            return this.current.getValue();
        }
    }
}

