/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.gc.record;

import com.hazelcast.internal.elastic.LongArray;
import com.hazelcast.internal.hotrestart.KeyHandle;
import com.hazelcast.internal.hotrestart.KeyHandleOffHeap;
import com.hazelcast.internal.hotrestart.impl.SimpleHandleOffHeap;
import com.hazelcast.internal.hotrestart.impl.SortedBySeqRecordCursor;
import com.hazelcast.internal.hotrestart.impl.gc.MutatorCatchup;
import com.hazelcast.internal.hotrestart.impl.gc.record.Record;
import com.hazelcast.internal.hotrestart.impl.gc.record.RecordMap;
import com.hazelcast.internal.hotrestart.impl.gc.record.RecordOffHeap;
import com.hazelcast.internal.hotrestart.impl.gc.record.SortedBySeqRecordCursorOffHeap;
import com.hazelcast.internal.memory.MemoryManager;
import com.hazelcast.internal.util.hashslot.HashSlotCursor16byteKey;
import com.hazelcast.internal.util.hashslot.SlotAssignmentResult;
import com.hazelcast.internal.util.hashslot.impl.HashSlotArray16byteKeyImpl;

public final class RecordMapOffHeap
implements RecordMap {
    private static final int DEFAULT_INITIAL_CAPACITY = 256;
    private final MemoryManager memMgr;
    private final MemoryManager stableMemMgr;
    private final boolean isTombstoneMap;
    private HashSlotArray16byteKeyImpl hsa;
    private final RecordOffHeap rec = new RecordOffHeap();

    private RecordMapOffHeap(MemoryManager memMgr, MemoryManager stableMemMgr, boolean isTombstoneMap, int initialCapacity) {
        this.memMgr = memMgr;
        this.stableMemMgr = stableMemMgr;
        this.isTombstoneMap = isTombstoneMap;
        this.hsa = new HashSlotArray16byteKeyImpl(0L, memMgr, isTombstoneMap ? 16 : 24, initialCapacity, 0.6f);
        this.hsa.gotoNew();
    }

    private RecordMapOffHeap(RecordMapOffHeap growing) {
        this.memMgr = growing.stableMemMgr;
        this.stableMemMgr = null;
        this.isTombstoneMap = growing.isTombstoneMap;
        this.hsa = growing.hsa;
        this.hsa.migrateTo(this.memMgr.getAllocator());
    }

    public static RecordMapOffHeap newRecordMapOffHeap(MemoryManager memMgr, MemoryManager stableMemMgr) {
        return new RecordMapOffHeap(memMgr, stableMemMgr, false, 256);
    }

    public static RecordMapOffHeap newTombstoneMapOffHeap(MemoryManager memMgr) {
        return new RecordMapOffHeap(memMgr, null, true, 256);
    }

    @Override
    public Record putIfAbsent(long prefix, KeyHandle kh, long seq, int size, boolean isTombstone, int additionalInt) {
        KeyHandleOffHeap ohk = (KeyHandleOffHeap)kh;
        SlotAssignmentResult slot = this.hsa.ensure(ohk.address(), ohk.sequenceId());
        this.rec.address = slot.address();
        if (!slot.isNew()) {
            return this.rec;
        }
        if (!this.isTombstoneMap) {
            this.rec.setKeyPrefix(prefix);
        }
        this.rec.setRawSeqSize(seq, Record.toRawSizeValue(size, isTombstone));
        this.rec.setAdditionalInt(additionalInt);
        return null;
    }

    @Override
    public RecordOffHeap get(KeyHandle kh) {
        KeyHandleOffHeap handle = (KeyHandleOffHeap)kh;
        long addr = this.hsa.get(handle.address(), handle.sequenceId());
        if (addr == 0L) {
            return null;
        }
        this.rec.address = addr;
        return this.rec;
    }

    @Override
    public int size() {
        return (int)this.hsa.size();
    }

    @Override
    public SortedBySeqRecordCursor sortedBySeqCursor(int liveRecordCount, RecordMap[] recordMaps, MutatorCatchup mc) {
        LongArray seqsAndSlotBases = new LongArray(this.memMgr, 2L * (long)liveRecordCount);
        RecordOffHeap r = new RecordOffHeap();
        mc.catchupNow();
        int i = 0;
        for (RecordMap map : recordMaps) {
            HashSlotCursor16byteKey cursor = ((RecordMapOffHeap)map).hsa.cursor();
            while (cursor.advance()) {
                r.address = cursor.valueAddress();
                if (r.isAlive()) {
                    seqsAndSlotBases.set(i++, r.liveSeq());
                    seqsAndSlotBases.set(i++, HashSlotArray16byteKeyImpl.valueAddr2slotBase(r.address));
                }
                mc.catchupAsNeeded();
            }
        }
        return new SortedBySeqRecordCursorOffHeap(seqsAndSlotBases, i, this.memMgr, mc);
    }

    @Override
    public CursorOffHeap cursor() {
        return new CursorOffHeap();
    }

    @Override
    public RecordMap toStable() {
        return this.stableMemMgr != null ? new RecordMapOffHeap(this) : this;
    }

    @Override
    public void dispose() {
        this.hsa.dispose();
    }

    final class CursorOffHeap
    implements RecordMap.Cursor {
        private final HashSlotCursor16byteKey c;
        private final RecordOffHeap r;

        CursorOffHeap() {
            this.c = RecordMapOffHeap.this.hsa.cursor();
            this.r = new RecordOffHeap();
        }

        @Override
        public boolean advance() {
            if (!this.c.advance()) {
                return false;
            }
            this.r.address = this.c.valueAddress();
            return true;
        }

        @Override
        public KeyHandleOffHeap toKeyHandle() {
            return new SimpleHandleOffHeap(this.c.key1(), this.c.key2());
        }

        @Override
        public Record asRecord() {
            return this.r;
        }
    }
}

