/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.gc.chunk;

import com.hazelcast.hotrestart.HotRestartException;
import com.hazelcast.internal.hotrestart.KeyHandle;
import com.hazelcast.internal.hotrestart.impl.gc.GcHelper;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.ActiveChunk;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.StableTombChunk;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.WriteThroughChunk;
import com.hazelcast.internal.hotrestart.impl.gc.record.RecordMap;
import com.hazelcast.internal.hotrestart.impl.io.ChunkFileOut;
import com.hazelcast.internal.hotrestart.impl.io.TombFileAccessor;
import java.io.IOException;

public class WriteThroughTombChunk
extends WriteThroughChunk
implements ActiveChunk {
    public WriteThroughTombChunk(long seq, String suffix, RecordMap records, ChunkFileOut out, GcHelper gcHelper) {
        super(seq, suffix, records, out, gcHelper);
    }

    @Override
    public boolean addStep1(long recordSeq, long keyPrefix, byte[] keyBytes, byte[] ignored) {
        assert (this.hasRoom());
        this.out.writeTombstone(recordSeq, keyPrefix, keyBytes);
        this.grow(20 + keyBytes.length);
        return this.full();
    }

    public boolean addStep1(TombFileAccessor tfa, int filePos) {
        assert (this.hasRoom());
        try {
            this.grow(tfa.loadAndCopyTombstone(filePos, this.out));
            return this.full();
        }
        catch (IOException e) {
            throw new HotRestartException("Failed to copy tombstone", e);
        }
    }

    @Override
    public void insertOrUpdate(long recordSeq, long keyPrefix, KeyHandle kh, int filePos, int size) {
        this.insertOrUpdateTombstone(recordSeq, keyPrefix, kh, filePos, size);
    }

    @Override
    protected int determineSizeLimit() {
        return WriteThroughTombChunk.tombChunkSizeLimit();
    }

    @Override
    public void needsDismissing(boolean needsDismissing) {
    }

    @Override
    public String base() {
        return "tombstone";
    }

    @Override
    public StableTombChunk toStableChunk() {
        return new StableTombChunk(this);
    }
}

