/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.gc;

import com.hazelcast.internal.hotrestart.impl.di.Inject;
import com.hazelcast.internal.hotrestart.impl.di.Name;
import com.hazelcast.internal.hotrestart.impl.gc.GcLogger;
import com.hazelcast.internal.hotrestart.impl.gc.Snapshotter;
import com.hazelcast.internal.util.concurrent.ConcurrentConveyor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MutatorCatchup {
    public static final int DEFAULT_CATCHUP_INTERVAL_LOG2 = 10;
    private static final int LATE_CATCHUP_THRESHOLD_MILLIS = 10;
    private static final int LATE_CATCHUP_CUTOFF_MILLIS = 300;
    boolean askedToStop;
    private final ConcurrentConveyor<Runnable> conveyor;
    private final Snapshotter snapshotter;
    private final ArrayList<Runnable> workDrain = new ArrayList(1024);
    private final GcLogger logger;
    private long i;
    private long lastCaughtUp = -1L;

    @Inject
    private MutatorCatchup(GcLogger logger, @Name(value="gcConveyor") ConcurrentConveyor<Runnable> conveyor, Snapshotter snapshotter) {
        this.logger = logger;
        this.conveyor = conveyor;
        this.snapshotter = snapshotter;
    }

    public int catchupAsNeeded() {
        return this.catchupAsNeeded(10);
    }

    final int catchupAsNeeded(int power) {
        return (this.i++ & (long)((1 << power) - 1)) == 0L ? this.catchUpWithMutator() : 0;
    }

    public int catchupNow() {
        this.i = 1L;
        return this.catchUpWithMutator();
    }

    public boolean shutdownRequested() {
        return this.askedToStop;
    }

    private int catchUpWithMutator() {
        int workCount = this.conveyor.drainTo(this.workDrain);
        if (this.lastCaughtUp >= 0L) {
            this.lastCaughtUp = MutatorCatchup.diagnoseLateCatchup("Collector", this.lastCaughtUp, this.logger);
        }
        if (this.snapshotter.enabled) {
            this.snapshotter.takeChunkSnapshotAsNeeded();
        }
        if (workCount == 0) {
            return 0;
        }
        for (Runnable op : this.workDrain) {
            op.run();
        }
        this.workDrain.clear();
        return workCount;
    }

    public static long diagnoseLateCatchup(String name, long lastCaughtUp, GcLogger logger) {
        long now = System.nanoTime();
        long sinceLastCatchup = now - lastCaughtUp;
        if (sinceLastCatchup <= TimeUnit.MILLISECONDS.toNanos(10L) || sinceLastCatchup >= TimeUnit.MILLISECONDS.toNanos(300L)) {
            return now;
        }
        StringWriter sw = new StringWriter(512);
        PrintWriter w = new PrintWriter(sw);
        new Exception().printStackTrace(w);
        String trace = sw.toString();
        Matcher m = Pattern.compile("\n.*?\n.*?\n.*?(\n.*?\n.*?)\n").matcher(trace);
        m.find();
        logger.finest("%s didn't catch up for %d ms%s", name, TimeUnit.NANOSECONDS.toMillis(sinceLastCatchup), m.group(1));
        return now;
    }

    public static interface CatchupRunnable {
        public void run(MutatorCatchup var1);
    }
}

