/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.gc;

import com.hazelcast.internal.hotrestart.impl.di.Inject;
import com.hazelcast.internal.hotrestart.impl.di.Name;
import com.hazelcast.internal.hotrestart.impl.gc.ChunkManager;
import com.hazelcast.internal.hotrestart.impl.gc.GcLogger;
import com.hazelcast.internal.hotrestart.impl.gc.GcParams;
import com.hazelcast.internal.hotrestart.impl.gc.MutatorCatchup;
import com.hazelcast.internal.hotrestart.impl.gc.PrefixTombstoneManager;
import com.hazelcast.internal.util.concurrent.ConcurrentConveyor;

public final class GcMainLoop
implements Runnable {
    private final ChunkManager chunkMgr;
    private final MutatorCatchup mc;
    private final PrefixTombstoneManager pfixTombstoMgr;
    private final ConcurrentConveyor<Runnable> gcConveyor;
    private final ConcurrentConveyor<?> persistenceConveyor;
    private final GcLogger logger;
    private final Object testGcMutex;

    @Inject
    private GcMainLoop(ChunkManager chunkMgr, MutatorCatchup mc, PrefixTombstoneManager pfixTombstoMgr, @Name(value="persistenceConveyor") ConcurrentConveyor<?> persistenceConveyor, @Name(value="gcConveyor") ConcurrentConveyor<Runnable> gcConveyor, GcLogger logger, @Name(value="testGcMutex") Object testGcMutex) {
        this.chunkMgr = chunkMgr;
        this.mc = mc;
        this.pfixTombstoMgr = pfixTombstoMgr;
        this.persistenceConveyor = persistenceConveyor;
        this.gcConveyor = gcConveyor;
        this.logger = logger;
        this.testGcMutex = testGcMutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            long idleCount = 0L;
            boolean didWork = false;
            while (!this.mc.askedToStop && !Thread.interrupted()) {
                int workCount;
                Object object = this.testGcMutex;
                synchronized (object) {
                    workCount = this.mc.catchupNow();
                    if (!this.pfixTombstoMgr.sweepingInProgress()) {
                        GcParams gcp = workCount > 0 || didWork ? this.chunkMgr.gcParams() : GcParams.ZERO;
                        boolean bl = didWork = gcp.forceGc ? this.runForcedGC(gcp) : this.chunkMgr.valueGc(gcp, this.mc);
                        if (didWork) {
                            this.mc.catchupNow();
                            this.chunkMgr.tombGc(this.mc);
                        }
                    }
                }
                if (didWork |= this.pfixTombstoMgr.sweepAsNeeded()) {
                    Thread.yield();
                }
                if (workCount > 0 || didWork) {
                    idleCount = 0L;
                    continue;
                }
                ConcurrentConveyor.SUBMIT_IDLER.idle(idleCount++);
            }
            this.gcConveyor.drainerDone();
            this.logger.fine("GC thread done. ");
        }
        catch (Throwable t) {
            this.gcConveyor.drainerFailed(t);
            this.logger.severe("GC thread terminated by exception", t);
        }
        finally {
            this.mc.askedToStop = true;
        }
    }

    private boolean runForcedGC(GcParams gcp) {
        this.persistenceConveyor.backpressureOn();
        try {
            boolean bl = this.chunkMgr.valueGc(gcp, this.mc);
            return bl;
        }
        finally {
            this.persistenceConveyor.backpressureOff();
        }
    }
}

