/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.gc;

import com.hazelcast.internal.hotrestart.impl.di.Inject;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.properties.HazelcastProperty;

public class GcLogger {
    public static final String PROPERTY_VERBOSE_FINEST_LOGGING = "hazelcast.hotrestart.gc.verboseFinestLogging";
    public static final HazelcastProperty VERBOSE_FINEST_LOGGING = new HazelcastProperty("hazelcast.hotrestart.gc.verboseFinestLogging", false);
    private final ILogger logger;
    private final boolean finestVerboseEnabled;

    GcLogger(ILogger logger) {
        this.logger = logger;
        this.finestVerboseEnabled = Boolean.getBoolean(PROPERTY_VERBOSE_FINEST_LOGGING);
    }

    @Inject
    GcLogger(ILogger logger, HazelcastProperties properties) {
        this.logger = logger;
        this.finestVerboseEnabled = properties.getBoolean(VERBOSE_FINEST_LOGGING);
    }

    public void finestVerbose(String message) {
        if (this.finestVerboseEnabled) {
            this.logger.finest(message);
        }
    }

    public void finestVerbose(String template, Object arg) {
        if (this.finestVerboseEnabled && this.logger.isFinestEnabled()) {
            this.logger.finest(String.format(template, arg));
        }
    }

    public void finest(String message) {
        this.logger.finest(message);
    }

    public void finest(String template, Object arg) {
        if (this.logger.isFinestEnabled()) {
            this.finest(String.format(template, arg));
        }
    }

    public void finest(String template, Object arg1, Object arg2) {
        if (this.logger.isFinestEnabled()) {
            this.finest(String.format(template, arg1, arg2));
        }
    }

    public void finest(String template, Object arg1, Object arg2, Object arg3) {
        if (this.logger.isFinestEnabled()) {
            this.finest(String.format(template, arg1, arg2, arg3));
        }
    }

    public void finest(String template, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (this.logger.isFinestEnabled()) {
            this.finest(String.format(template, arg1, arg2, arg3, arg4));
        }
    }

    public void finest(String template, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        if (this.logger.isFinestEnabled()) {
            this.finest(String.format(template, arg1, arg2, arg3, arg4, arg5));
        }
    }

    public void finest(String template, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6) {
        if (this.logger.isFinestEnabled()) {
            this.finest(String.format(template, arg1, arg2, arg3, arg4, arg5, arg6));
        }
    }

    public void fine(String message) {
        this.logger.fine(message);
    }

    public void fine(String template, Object arg1) {
        if (this.logger.isFineEnabled()) {
            this.fine(String.format(template, arg1));
        }
    }

    public void fine(String template, Object arg1, Object arg2) {
        if (this.logger.isFineEnabled()) {
            this.fine(String.format(template, arg1, arg2));
        }
    }

    public void fine(String template, Object arg1, Object arg2, Object arg3) {
        if (this.logger.isFineEnabled()) {
            this.fine(String.format(template, arg1, arg2, arg3));
        }
    }

    public void fine(String template, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (this.logger.isFineEnabled()) {
            this.fine(String.format(template, arg1, arg2, arg3, arg4));
        }
    }

    public void fine(String template, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        if (this.logger.isFineEnabled()) {
            this.fine(String.format(template, arg1, arg2, arg3, arg4, arg5));
        }
    }

    public void fine(String template, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8) {
        if (this.logger.isFineEnabled()) {
            this.fine(String.format(template, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8));
        }
    }

    public void info(String message) {
        this.logger.info(message);
    }

    public void warning(String message) {
        this.logger.warning(message);
    }

    public void warning(String message, Throwable thrown) {
        this.logger.warning(message, thrown);
    }

    public void severe(String message) {
        this.logger.severe(message);
    }

    public void severe(String message, Throwable thrown) {
        this.logger.severe(message, thrown);
    }

    boolean isFinestVerboseEnabled() {
        return this.finestVerboseEnabled && this.logger.isFinestEnabled();
    }
}

