/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.gc;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.hotrestart.impl.di.Inject;
import com.hazelcast.internal.hotrestart.impl.gc.ChunkManager;
import com.hazelcast.internal.hotrestart.impl.gc.GcHelper;
import com.hazelcast.internal.hotrestart.impl.gc.GcLogger;
import com.hazelcast.internal.hotrestart.impl.io.DefaultCopyStrategy;
import com.hazelcast.internal.hotrestart.impl.io.FileCopyStrategy;
import com.hazelcast.internal.hotrestart.impl.io.HardLinkCopyStrategy;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.persistence.BackupTaskState;
import java.io.File;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public class BackupTask
implements Runnable {
    public static final String IN_PROGRESS_FILE = "inprogress";
    public static final String FAILURE_FILE = "failure";
    private static final String PROPERTY_BACKUP_USE_HARD_LINKS = "hazelcast.hotrestart.backup.useHardLinks";
    private final File targetDir;
    private final long[] stableTombChunkSeqs;
    private final long[] stableValChunkSeqs;
    private final long maxChunkSeq;
    private final boolean useHardLinks;
    private final String storeName;
    @Inject
    private GcLogger logger;
    @Inject
    private GcHelper gcHelper;
    @Inject
    private ChunkManager chunkManager;
    private FileCopyStrategy copyStrategy;
    private volatile BackupTaskState state = BackupTaskState.NOT_STARTED;

    BackupTask(File targetDir, String storeName, long[] stableValChunkSeqs, long[] stableTombChunkSeqs) {
        Arrays.sort(stableValChunkSeqs);
        Arrays.sort(stableTombChunkSeqs);
        long maxValChunkSeq = stableValChunkSeqs.length > 0 ? stableValChunkSeqs[stableValChunkSeqs.length - 1] : Long.MIN_VALUE;
        long maxTombChunkSeq = stableTombChunkSeqs.length > 0 ? stableTombChunkSeqs[stableTombChunkSeqs.length - 1] : Long.MIN_VALUE;
        this.targetDir = targetDir;
        this.stableValChunkSeqs = stableValChunkSeqs;
        this.stableTombChunkSeqs = stableTombChunkSeqs;
        this.maxChunkSeq = Math.max(maxValChunkSeq, maxTombChunkSeq);
        String useHardLinksStr = System.getProperty(PROPERTY_BACKUP_USE_HARD_LINKS);
        this.useHardLinks = useHardLinksStr == null || Boolean.parseBoolean(useHardLinksStr);
        this.storeName = storeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.state = BackupTaskState.IN_PROGRESS;
        long start = System.nanoTime();
        File inProgressFile = new File(this.targetDir, IN_PROGRESS_FILE);
        try {
            if (!inProgressFile.createNewFile()) {
                throw new IllegalStateException("Hot restart backup is currently not running but the inprogress file exists. Changing the file to mark failed backup");
            }
            this.copyOrMoveChunks(this.stableValChunkSeqs, true);
            this.copyOrMoveChunks(this.stableTombChunkSeqs, false);
            this.completedBackup(inProgressFile);
            this.state = BackupTaskState.SUCCESS;
        }
        catch (Throwable e) {
            this.state = BackupTaskState.FAILURE;
            this.failedBackup(inProgressFile, e);
        }
        finally {
            Thread.interrupted();
        }
        this.chunkManager.deletePendingChunks();
        long durationMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
        this.logger.info("Backup of hot restart store " + this.storeName + " finished in " + durationMillis + " ms");
    }

    private void copyOrMoveChunks(long[] seqs, boolean areValChunks) {
        for (long seq : seqs) {
            if (Thread.currentThread().isInterrupted()) break;
            File chunkSourceFile = this.stableChunkFile(seq, areValChunks);
            File chunkTargetDir = this.ensureDirectory(chunkSourceFile, this.targetDir);
            if (this.chunkManager.isChunkPendingDeletion(seq, areValChunks)) {
                IOUtil.rename(chunkSourceFile, new File(chunkTargetDir, chunkSourceFile.getName()));
                this.chunkManager.removeChunkPendingDeletion(seq, areValChunks);
                continue;
            }
            if (this.copyStrategy == null && !this.useHardLinks) {
                this.copyStrategy = new DefaultCopyStrategy();
            }
            if (this.copyStrategy != null) {
                this.copyStrategy.copy(chunkSourceFile, chunkTargetDir);
                continue;
            }
            try {
                this.copyStrategy = new HardLinkCopyStrategy();
                this.copyStrategy.copy(chunkSourceFile, chunkTargetDir);
            }
            catch (Exception e) {
                this.logger.finest("Failed to use hard links for file copy : " + e.getMessage() + ", cause: " + ExceptionUtil.toString(e));
                this.copyStrategy = new DefaultCopyStrategy();
                this.copyStrategy.copy(chunkSourceFile, chunkTargetDir);
            }
        }
    }

    private void completedBackup(File inProgressFile) {
        IOUtil.deleteQuietly(inProgressFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failedBackup(File inProgressFile, Throwable e) {
        this.logger.warning("Hot restart store backup failed", e);
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(inProgressFile, "UTF-8");
            e.printStackTrace(writer);
        }
        catch (Throwable ex) {
            try {
                this.logger.warning("Error occurred while generating backup error file", ex);
            }
            catch (Throwable throwable) {
                IOUtil.closeResource(writer);
                throw throwable;
            }
            IOUtil.closeResource(writer);
        }
        IOUtil.closeResource(writer);
        IOUtil.rename(inProgressFile, new File(inProgressFile.getParentFile(), FAILURE_FILE));
    }

    private File ensureDirectory(File chunkFile, File targetBase) {
        File targetDir = BackupTask.getTargetDir(chunkFile, targetBase);
        if (!targetDir.exists() && !targetDir.mkdirs()) {
            throw new HazelcastException("Could not create the target directory " + targetDir);
        }
        return targetDir;
    }

    private static File getTargetDir(File chunkFile, File targetBase) {
        File bucket = chunkFile.getParentFile();
        File base = bucket.getParentFile();
        return new File(new File(targetBase, base.getName()), bucket.getName());
    }

    private File stableChunkFile(long seq, boolean valChunk) {
        String baseDir = valChunk ? "value" : "tombstone";
        File file = this.gcHelper.chunkFile(baseDir, seq, ".chunk", false);
        if (file.exists()) {
            return file;
        }
        throw new IllegalStateException("Could not find stable chunk file for chunk " + seq);
    }

    public BackupTaskState getBackupState() {
        return this.state;
    }

    public long getMaxChunkSeq() {
        return this.maxChunkSeq;
    }
}

