/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl;

import com.hazelcast.internal.hotrestart.HotRestartKey;
import com.hazelcast.internal.hotrestart.KeyHandle;
import com.hazelcast.internal.util.HashUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigInteger;
import java.util.Arrays;

public class KeyOnHeap
implements HotRestartKey,
KeyHandle {
    private final long prefix;
    private final byte[] bytes;
    private final int hashCode;

    @SuppressFBWarnings(value={"EI"}, justification="bytes is an effectively immutable array (it is illegal to change its contents)")
    public KeyOnHeap(long prefix, byte[] bytes) {
        this.prefix = prefix;
        this.bytes = bytes;
        this.hashCode = (int)(37L * prefix + (long)HashUtil.MurmurHash3_x86_32(bytes, 0, bytes.length));
    }

    @Override
    public long prefix() {
        return this.prefix;
    }

    @Override
    @SuppressFBWarnings(value={"EI"}, justification="bytes is an effectively immutable array (it is illegal to change its contents)")
    public byte[] bytes() {
        return this.bytes;
    }

    @Override
    public KeyHandle handle() {
        return this;
    }

    public int hashCode() {
        return this.hashCode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof KeyOnHeap)) return false;
        KeyOnHeap that = (KeyOnHeap)obj;
        if (this.prefix != that.prefix) return false;
        if (!Arrays.equals(this.bytes, that.bytes)) return false;
        return true;
    }

    public String toString() {
        return this.prefix + ":" + new BigInteger(this.bytes).toString(36);
    }
}

