/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.cluster;

import com.hazelcast.cluster.Address;
import com.hazelcast.internal.cluster.impl.operations.JoinOperation;
import com.hazelcast.internal.hotrestart.HotRestartIntegrationService;
import com.hazelcast.internal.hotrestart.cluster.ClusterMetadataManager;
import com.hazelcast.internal.hotrestart.cluster.HotRestartClusterSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;

public class TriggerForceStartOnMasterOperation
extends Operation
implements JoinOperation {
    private boolean partialStart;

    public TriggerForceStartOnMasterOperation() {
    }

    public TriggerForceStartOnMasterOperation(boolean partialStart) {
        this.partialStart = partialStart;
    }

    @Override
    public void run() throws Exception {
        Address caller = this.getCallerAddress();
        this.getLogger().warning("Received " + (this.partialStart ? "partial" : "force") + " start request from: " + caller);
        HotRestartIntegrationService service = (HotRestartIntegrationService)this.getService();
        ClusterMetadataManager clusterMetadataManager = service.getClusterMetadataManager();
        if (this.partialStart) {
            clusterMetadataManager.handlePartialStartRequest();
        } else {
            clusterMetadataManager.handleForceStartRequest();
        }
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public String getServiceName() {
        return "hz:ee:internalHotRestartService";
    }

    @Override
    public int getFactoryId() {
        return HotRestartClusterSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 4;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeBoolean(this.partialStart);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.partialStart = in.readBoolean();
    }
}

