/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.cluster;

import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.internal.cluster.impl.operations.JoinOperation;
import com.hazelcast.internal.hotrestart.HotRestartIntegrationService;
import com.hazelcast.internal.hotrestart.cluster.ClusterMetadataManager;
import com.hazelcast.internal.hotrestart.cluster.HotRestartClusterSerializerHook;
import com.hazelcast.internal.hotrestart.cluster.MemberClusterStartInfo;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.Operation;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;

public class SendMemberClusterStartInfoOperation
extends Operation
implements JoinOperation {
    private MemberClusterStartInfo memberClusterStartInfo;

    public SendMemberClusterStartInfoOperation() {
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public SendMemberClusterStartInfoOperation(MemberClusterStartInfo memberClusterStartInfo) {
        this.memberClusterStartInfo = memberClusterStartInfo;
    }

    @Override
    public void run() throws Exception {
        HotRestartIntegrationService service = (HotRestartIntegrationService)this.getService();
        ClusterMetadataManager clusterMetadataManager = service.getClusterMetadataManager();
        ClusterService clusterService = this.getNodeEngine().getClusterService();
        MemberImpl member = clusterService.getMember(this.getCallerAddress(), this.getCallerUuid());
        if (member == null) {
            this.getLogger().warning("An unknown member sent MemberClusterStartInfo. Address: " + this.getCallerAddress() + ", UUID: " + this.getCallerUuid());
            return;
        }
        clusterMetadataManager.receiveClusterStartInfoFromMember(member, this.memberClusterStartInfo);
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public String getServiceName() {
        return "hz:ee:internalHotRestartService";
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeObject(this.memberClusterStartInfo);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.memberClusterStartInfo = (MemberClusterStartInfo)in.readObject();
    }

    @Override
    public int getFactoryId() {
        return HotRestartClusterSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 3;
    }
}

