/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.cluster;

import com.hazelcast.internal.cluster.impl.operations.JoinOperation;
import com.hazelcast.internal.hotrestart.InternalHotRestartService;
import com.hazelcast.internal.hotrestart.cluster.HotRestartClusterSerializerHook;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

public class SendExcludedMemberUuidsOperation
extends Operation
implements JoinOperation {
    private Set<UUID> excludedMemberUuids;

    public SendExcludedMemberUuidsOperation() {
    }

    public SendExcludedMemberUuidsOperation(Set<UUID> excludedMemberUuids) {
        this.excludedMemberUuids = excludedMemberUuids != null ? excludedMemberUuids : Collections.emptySet();
    }

    @Override
    public void run() {
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        InternalHotRestartService hotRestartService = nodeEngine.getNode().getNodeExtension().getInternalHotRestartService();
        hotRestartService.handleExcludedMemberUuids(this.getCallerAddress(), this.excludedMemberUuids);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.excludedMemberUuids.size());
        for (UUID uuid : this.excludedMemberUuids) {
            UUIDSerializationUtil.writeUUID(out, uuid);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int size = in.readInt();
        HashSet<UUID> excludedMemberUuids = new HashSet<UUID>();
        for (int i = 0; i < size; ++i) {
            excludedMemberUuids.add(UUIDSerializationUtil.readUUID(in));
        }
        this.excludedMemberUuids = Collections.unmodifiableSet(excludedMemberUuids);
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public int getFactoryId() {
        return HotRestartClusterSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 6;
    }
}

