/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.cluster;

import com.hazelcast.internal.hotrestart.cluster.AbstractMetadataWriter;
import com.hazelcast.internal.partition.InternalPartition;
import com.hazelcast.internal.partition.PartitionReplica;
import com.hazelcast.internal.partition.PartitionTableView;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

final class PartitionTableWriter
extends AbstractMetadataWriter<PartitionTableView> {
    static final String FILE_NAME = "partitions.bin";

    PartitionTableWriter(File homeDir) {
        super(homeDir);
    }

    @Override
    void doWrite(DataOutput out, PartitionTableView partitionTable) throws IOException {
        PartitionTableWriter.writePartitionTable(out, partitionTable);
    }

    @Override
    String getFilename() {
        return FILE_NAME;
    }

    static void writePartitionTable(DataOutput out, PartitionTableView partitionTable) throws IOException {
        out.writeInt(partitionTable.length());
        LinkedHashMap<PartitionReplica, Integer> replicaIdToIndexes = PartitionTableWriter.createReplicaIdToIndexMap(partitionTable);
        PartitionTableWriter.writeAllReplicas(out, replicaIdToIndexes.keySet());
        PartitionTableWriter.writePartitionTable(partitionTable, replicaIdToIndexes, out);
    }

    private static void writePartitionTable(PartitionTableView partitionTable, Map<PartitionReplica, Integer> replicaIdToIndexes, DataOutput out) throws IOException {
        for (int partitionId = 0; partitionId < partitionTable.length(); ++partitionId) {
            InternalPartition partition = partitionTable.getPartition(partitionId);
            out.writeInt(partition.version());
            for (int replicaIndex = 0; replicaIndex < 7; ++replicaIndex) {
                PartitionReplica replica = partition.getReplica(replicaIndex);
                if (replica == null) {
                    out.writeInt(-1);
                    continue;
                }
                int index = replicaIdToIndexes.get(replica);
                out.writeInt(index);
            }
        }
    }

    static LinkedHashMap<PartitionReplica, Integer> createReplicaIdToIndexMap(PartitionTableView partitionTable) {
        LinkedHashMap<PartitionReplica, Integer> map = new LinkedHashMap<PartitionReplica, Integer>();
        int addressIndex = 0;
        for (int partitionId = 0; partitionId < partitionTable.length(); ++partitionId) {
            for (int replicaIndex = 0; replicaIndex < 7; ++replicaIndex) {
                PartitionReplica replica = partitionTable.getReplica(partitionId, replicaIndex);
                if (replica == null || map.containsKey(replica)) continue;
                map.put(replica, addressIndex++);
            }
        }
        return map;
    }

    static void writeAllReplicas(DataOutput out, Set<PartitionReplica> replicas) throws IOException {
        out.writeInt(replicas.size());
        for (PartitionReplica replica : replicas) {
            PartitionTableWriter.writeAddress(out, replica.address());
            UUIDSerializationUtil.writeUUID(out, replica.uuid());
        }
    }
}

