/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.cluster;

import com.hazelcast.cluster.Address;
import com.hazelcast.internal.hotrestart.cluster.AbstractMetadataReader;
import com.hazelcast.internal.partition.InternalPartition;
import com.hazelcast.internal.partition.PartitionReplica;
import com.hazelcast.internal.partition.PartitionTableView;
import com.hazelcast.internal.partition.ReadonlyInternalPartition;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.util.UUID;

class PartitionTableReader
extends AbstractMetadataReader {
    private final int partitionCount;
    private PartitionTableView partitionTable;

    PartitionTableReader(File homeDir, int partitionCount) {
        super(homeDir);
        this.partitionCount = partitionCount;
        InternalPartition[] partitions = new InternalPartition[partitionCount];
        for (int i = 0; i < partitionCount; ++i) {
            partitions[i] = new ReadonlyInternalPartition(new PartitionReplica[7], i, 0);
        }
        this.partitionTable = new PartitionTableView(partitions);
    }

    @Override
    final void doRead(DataInput in) throws IOException {
        PartitionTableView pt = PartitionTableReader.readPartitionTable(in);
        if (pt.length() != this.partitionCount) {
            throw new IOException("Invalid partition count! Expected: " + this.partitionCount + ", Actual: " + pt.length());
        }
        this.partitionTable = pt;
    }

    static PartitionTableView readPartitionTable(DataInput in) throws IOException {
        PartitionReplica[] allReplicas;
        int partitionCount;
        try {
            partitionCount = in.readInt();
        }
        catch (IOException e) {
            throw new IOException("Cannot read partition count!", e);
        }
        try {
            int len = in.readInt();
            allReplicas = new PartitionReplica[len];
            for (int i = 0; i < len; ++i) {
                Address address = PartitionTableReader.readAddress(in);
                UUID uuid = UUIDSerializationUtil.readUUID(in);
                allReplicas[i] = new PartitionReplica(address, uuid);
            }
        }
        catch (IOException e) {
            throw new IOException("Cannot read partition table replicas!", e);
        }
        InternalPartition[] partitions = new InternalPartition[partitionCount];
        for (int partitionId = 0; partitionId < partitionCount; ++partitionId) {
            int version = in.readInt();
            PartitionReplica[] replicas = new PartitionReplica[7];
            for (int replicaIndex = 0; replicaIndex < 7; ++replicaIndex) {
                int index = in.readInt();
                if (index == -1) continue;
                PartitionReplica replica = allReplicas[index];
                assert (replica != null);
                replicas[replicaIndex] = replica;
            }
            partitions[partitionId] = new ReadonlyInternalPartition(replicas, partitionId, version);
        }
        return new PartitionTableView(partitions);
    }

    @Override
    String getFilename() {
        return "partitions.bin";
    }

    PartitionTableView getPartitionTable() {
        return this.partitionTable;
    }
}

