/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart;

import com.hazelcast.hotrestart.HotRestartException;
import com.hazelcast.internal.hotrestart.ConfigDescriptor;
import com.hazelcast.internal.hotrestart.LoadedConfigurationListener;
import com.hazelcast.internal.nio.Bits;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.impl.ObjectDataInputStream;
import com.hazelcast.internal.serialization.impl.ObjectDataOutputStream;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PersistentConfigDescriptors {
    private static final String CONFIG_FOLDER = "configs";
    private static final String CONFIG_SUFFIX = ".config";
    private static final String TMP_SUFFIX = ".tmp";
    private final Map<String, ConfigDescriptor> nameToDesc = new ConcurrentHashMap<String, ConfigDescriptor>();
    private final Map<Integer, ConfigDescriptor> idToDesc = new ConcurrentHashMap<Integer, ConfigDescriptor>();
    private final File configsDir;
    private volatile int cacheIdSeq;

    public PersistentConfigDescriptors(File instanceHome) {
        this.configsDir = new File(instanceHome, CONFIG_FOLDER);
        this.ensureConfigDirectoryExists();
    }

    private void ensureConfigDirectoryExists() {
        if (!this.configsDir.exists() && !this.configsDir.mkdirs()) {
            throw new HotRestartException("Cannot create config directory: " + this.configsDir.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"JLM_JSR166_UTILCONCURRENT_MONITORENTER"})
    public void reset() {
        Map<String, ConfigDescriptor> map = this.nameToDesc;
        synchronized (map) {
            this.nameToDesc.clear();
            this.idToDesc.clear();
            this.cacheIdSeq = 0;
        }
        this.ensureConfigDirectoryExists();
    }

    public long getPrefix(String serviceName, String name, int partitionId) {
        String key = PersistentConfigDescriptors.toCacheKey(serviceName, name);
        ConfigDescriptor desc = this.nameToDesc.get(key);
        if (desc == null) {
            throw new IllegalArgumentException("Unknown name! " + key);
        }
        return Bits.combineToLong(desc.getClassId(), partitionId);
    }

    public ConfigDescriptor getDescriptor(long prefix) {
        return this.idToDesc.get(Bits.extractInt(prefix, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"JLM_JSR166_UTILCONCURRENT_MONITORENTER"})
    public void ensureHas(InternalSerializationService serializationService, String serviceName, String name, Object config) {
        String cacheKey = PersistentConfigDescriptors.toCacheKey(serviceName, name);
        if (this.nameToDesc.get(cacheKey) != null) {
            return;
        }
        Map<String, ConfigDescriptor> map = this.nameToDesc;
        synchronized (map) {
            if (this.nameToDesc.get(cacheKey) != null) {
                return;
            }
            int id = ++this.cacheIdSeq;
            ConfigDescriptor desc = new ConfigDescriptor(serviceName, name, id);
            ObjectDataOutputStream out = null;
            try {
                String configFileName = PersistentConfigDescriptors.configFileName(serviceName, name);
                File configFile = PersistentConfigDescriptors.newFile(this.configsDir, configFileName);
                File tmpFile = PersistentConfigDescriptors.newFile(this.configsDir, configFileName + TMP_SUFFIX);
                FileOutputStream fileOut = new FileOutputStream(tmpFile);
                out = SerializationUtil.createObjectDataOutputStream(fileOut, serializationService);
                out.writeString(serviceName);
                out.writeInt(id);
                out.writeString(name);
                out.writeObject(config);
                this.idToDesc.put(id, desc);
                this.nameToDesc.put(cacheKey, desc);
                out.flush();
                fileOut.getFD().sync();
                out.close();
                IOUtil.rename(tmpFile, configFile);
            }
            catch (IOException e) {
                try {
                    throw ExceptionUtil.rethrow(e);
                }
                catch (Throwable throwable) {
                    IOUtil.closeResource(out);
                    throw throwable;
                }
            }
            IOUtil.closeResource(out);
        }
    }

    private static File newFile(File parent, String name) {
        File file = new File(parent, name);
        if (file.exists()) {
            throw new IllegalArgumentException(file + " already exists!");
        }
        return file;
    }

    private static String configFileName(String serviceName, String name) {
        return IOUtil.toFileName(serviceName) + '-' + IOUtil.toFileName(name) + CONFIG_SUFFIX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"JLM_JSR166_UTILCONCURRENT_MONITORENTER"})
    void restore(InternalSerializationService serializationService, List<LoadedConfigurationListener> loadedConfigurationListeners) {
        if (this.cacheIdSeq != 0) {
            return;
        }
        Map<String, ConfigDescriptor> map = this.nameToDesc;
        synchronized (map) {
            if (this.cacheIdSeq != 0) {
                return;
            }
            File[] configFiles = this.configsDir.listFiles((file, name) -> name.endsWith(CONFIG_SUFFIX));
            if (configFiles == null) {
                return;
            }
            int maxId = 0;
            for (File configFile : configFiles) {
                ConfigDescriptor desc;
                Object config;
                ObjectDataInputStream in = null;
                try {
                    in = SerializationUtil.createObjectDataInputStream(new FileInputStream(configFile), serializationService);
                    String serviceName = in.readString();
                    int id = in.readInt();
                    String name2 = in.readString();
                    config = in.readObject();
                    desc = new ConfigDescriptor(serviceName, name2, id);
                }
                catch (IOException e) {
                    try {
                        throw ExceptionUtil.rethrow(e);
                    }
                    catch (Throwable throwable) {
                        IOUtil.closeResource(in);
                        throw throwable;
                    }
                }
                IOUtil.closeResource(in);
                maxId = Math.max(maxId, desc.getClassId());
                String key = PersistentConfigDescriptors.toCacheKey(desc.getServiceName(), desc.getName());
                this.nameToDesc.put(key, desc);
                this.idToDesc.put(desc.getClassId(), desc);
                if (config == null) continue;
                this.notifyListeners(loadedConfigurationListeners, desc, config);
            }
            this.cacheIdSeq = maxId;
        }
    }

    private void notifyListeners(List<LoadedConfigurationListener> loadedConfigurationListeners, ConfigDescriptor desc, Object config) {
        for (LoadedConfigurationListener listener : loadedConfigurationListeners) {
            listener.onConfigurationLoaded(desc.getServiceName(), desc.getName(), config);
        }
    }

    private static String toCacheKey(String serviceName, String name) {
        return serviceName + "::" + name;
    }

    public static int toPartitionId(long prefix) {
        return Bits.extractInt(prefix, true);
    }

    public void backup(File targetDir) {
        IOUtil.copy(this.configsDir, targetDir);
    }

    static boolean isValidHotRestartDir(File homeDir) {
        File configDir = new File(homeDir, CONFIG_FOLDER);
        return configDir.exists() && configDir.isDirectory();
    }
}

