/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Member;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.hotrestart.HotRestartService;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.hotrestart.HotRestartIntegrationService;
import com.hazelcast.internal.hotrestart.backup.HotRestartBackupInterruptOperation;
import com.hazelcast.internal.hotrestart.backup.HotRestartBackupTransactionLogRecord;
import com.hazelcast.internal.services.TransactionalService;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.LockGuard;
import com.hazelcast.persistence.BackupTaskStatus;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionOptions;
import com.hazelcast.transaction.TransactionalObject;
import com.hazelcast.transaction.impl.Transaction;
import com.hazelcast.transaction.impl.TransactionManagerServiceImpl;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class HotBackupService
implements HotRestartService,
TransactionalService {
    public static final String SERVICE_NAME = "hz:ee:internalHotBackupService";
    private static final TransactionOptions DEFAULT_TX_OPTIONS = new TransactionOptions().setDurability(1).setTimeout(1L, TimeUnit.MINUTES).setTransactionType(TransactionOptions.TransactionType.TWO_PHASE);
    private static final long LOCK_LEASE_EXTENSION_MILLIS = TimeUnit.SECONDS.toMillis(20L);
    private final Node node;
    private final Lock serviceLock = new ReentrantLock();
    private final AtomicReference<LockGuard> lockGuardRef = new AtomicReference<LockGuard>(LockGuard.NOT_LOCKED);
    private final HotRestartIntegrationService hotRestartService;

    public HotBackupService(Node node, HotRestartIntegrationService hotRestartService) {
        this.node = node;
        this.hotRestartService = hotRestartService;
    }

    @Override
    public void backup() {
        this.backup(this.node.getClusterService().getClusterClock().getClusterTime());
    }

    @Override
    public void backup(long backupSeq) {
        NodeEngineImpl nodeEngine = this.node.getNodeEngine();
        TransactionManagerServiceImpl txManagerService = (TransactionManagerServiceImpl)nodeEngine.getTransactionManagerService();
        Transaction tx = txManagerService.newAllowedDuringPassiveStateTransaction(DEFAULT_TX_OPTIONS);
        tx.begin();
        try {
            this.addTransactionRecords(backupSeq, tx, this.node.getClusterService().getMembers());
            tx.prepare();
        }
        catch (Throwable e) {
            tx.rollback();
            throw ExceptionUtil.rethrow(e);
        }
        try {
            tx.commit();
        }
        catch (Throwable e) {
            if (e instanceof TargetNotMemberException || e.getCause() instanceof MemberLeftException) {
                return;
            }
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public BackupTaskStatus getBackupTaskStatus() {
        return this.hotRestartService.getBackupTaskStatus();
    }

    @Override
    public void interruptLocalBackupTask() {
        this.hotRestartService.interruptBackupTask();
    }

    @Override
    public void interruptBackupTask() {
        this.broadcast(new HotRestartBackupInterruptOperation());
        this.interruptLocalBackupTask();
    }

    @Override
    public boolean isHotBackupEnabled() {
        return true;
    }

    @Override
    public boolean isBackupEnabled() {
        return true;
    }

    @Override
    public String getBackupDirectory() {
        return this.node.getConfig().getHotRestartPersistenceConfig().getBackupDir().getAbsolutePath();
    }

    private void broadcast(Operation operation) {
        OperationServiceImpl operationService = this.node.getNodeEngine().getOperationService();
        for (Member member : this.node.getClusterService().getMembers()) {
            Address target = member.getAddress();
            if (this.node.getThisAddress().equals(target)) continue;
            operationService.send(operation, target);
        }
    }

    private void addTransactionRecords(long backupSeq, Transaction tx, Collection<Member> members) {
        long leaseTime = Math.min(tx.getTimeoutMillis(), LOCK_LEASE_EXTENSION_MILLIS);
        for (Member member : members) {
            tx.add(new HotRestartBackupTransactionLogRecord(backupSeq, this.node.getThisAddress(), member.getAddress(), tx.getTxnId(), leaseTime));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareBackup(Address initiator, UUID txnId, long leaseTime) {
        this.serviceLock.lock();
        try {
            if (!this.hotRestartService.isHotRestartHomeValid()) {
                throw new IllegalStateException("Persistence metadata has been corrupted! Unable to create backup from persistent data!");
            }
            if (this.hotRestartService.isBackupInProgress()) {
                throw new IllegalStateException("Another backup is currently in progress, aborting backup request");
            }
            LockGuard backupGuard = this.getBackupGuard();
            this.checkForExistingTransaction(backupGuard.allowsLock(txnId), initiator, backupGuard);
            this.lockGuardRef.set(new LockGuard(initiator, txnId, leaseTime));
        }
        finally {
            this.serviceLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitBackup(long backupSeq, Address initiator, UUID txnId) {
        this.serviceLock.lock();
        try {
            if (this.hotRestartService.isBackupInProgress()) {
                this.lockGuardRef.set(LockGuard.NOT_LOCKED);
                throw new IllegalStateException("Another backup is currently in progress, aborting backup request");
            }
            LockGuard backupGuard = this.getBackupGuard();
            this.checkForExistingTransaction(backupGuard.allowsUnlock(txnId), initiator, backupGuard);
            this.hotRestartService.backup(backupSeq);
            this.lockGuardRef.set(LockGuard.NOT_LOCKED);
        }
        finally {
            this.serviceLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rollbackBackup(UUID txnId) {
        this.serviceLock.lock();
        try {
            LockGuard backupGuard = this.getBackupGuard();
            if (!backupGuard.allowsUnlock(txnId)) {
                boolean bl = false;
                return bl;
            }
            this.lockGuardRef.set(LockGuard.NOT_LOCKED);
            boolean bl = true;
            return bl;
        }
        finally {
            this.serviceLock.unlock();
        }
    }

    private void checkForExistingTransaction(boolean check, Address initiator, LockGuard backupGuard) {
        if (!check) {
            throw new TransactionException("Hot restart backup failed for " + initiator + " because a backup request from " + backupGuard.getLockOwner() + " is in progress");
        }
    }

    private LockGuard getBackupGuard() {
        LockGuard lockGuard = this.lockGuardRef.get();
        while (lockGuard.isLeaseExpired()) {
            if (this.lockGuardRef.compareAndSet(lockGuard, LockGuard.NOT_LOCKED)) {
                lockGuard = LockGuard.NOT_LOCKED;
                break;
            }
            lockGuard = this.lockGuardRef.get();
        }
        return lockGuard;
    }

    @Override
    public <T extends TransactionalObject> T createTransactionalObject(String name, Transaction transaction) {
        throw new UnsupportedOperationException("hz:ee:internalHotBackupService does not support TransactionalObjects!");
    }

    @Override
    public void rollbackTransaction(UUID transactionId) {
        this.rollbackBackup(transactionId);
    }
}

