/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hidensity.impl;

import com.hazelcast.internal.hidensity.HiDensityStorageInfo;
import com.hazelcast.internal.memory.HazelcastMemoryManager;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.memory.MemoryBlockProcessor;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.DataType;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import com.hazelcast.map.impl.record.HDJsonMetadataRecord;
import com.hazelcast.map.impl.record.HDJsonMetadataRecordAccessor;

public class HDJsonMetadataRecordProcessor
implements MemoryBlockProcessor<HDJsonMetadataRecord> {
    protected final HazelcastMemoryManager memoryManager;
    protected final HiDensityStorageInfo storageInfo;
    private final EnterpriseSerializationService ess;
    private final HDJsonMetadataRecordAccessor recordAccessor;

    public HDJsonMetadataRecordProcessor(EnterpriseSerializationService ess, HDJsonMetadataRecordAccessor recordAccessor, HiDensityStorageInfo storageInfo) {
        this.ess = ess;
        this.recordAccessor = recordAccessor;
        this.memoryManager = ess.getMemoryManager();
        this.storageInfo = storageInfo;
    }

    public HDJsonMetadataRecord newRecord() {
        return this.recordAccessor.newRecord();
    }

    @Override
    public boolean isEqual(long address, HDJsonMetadataRecord value) {
        return this.recordAccessor.isEqual(address, value);
    }

    @Override
    public boolean isEqual(long address1, long address2) {
        return this.recordAccessor.isEqual(address1, address2);
    }

    @Override
    public HDJsonMetadataRecord read(long address) {
        return this.recordAccessor.read(address);
    }

    @Override
    public long dispose(HDJsonMetadataRecord record) {
        long size = this.recordAccessor.dispose(record);
        this.storageInfo.removeUsedMemory(size);
        return size;
    }

    @Override
    public long dispose(long address) {
        long size = this.recordAccessor.dispose(address);
        this.storageInfo.removeUsedMemory(size);
        return size;
    }

    public long disposeMetadataKeyValue(HDJsonMetadataRecord record) {
        long size = this.recordAccessor.disposeMetadataKeyValue(record);
        this.storageInfo.removeUsedMemory(size);
        return size;
    }

    public long disposeMetadataKeyValue(HDJsonMetadataRecord record, boolean isKey) {
        long size = this.recordAccessor.disposeMetadataKeyValue(record, isKey);
        this.storageInfo.removeUsedMemory(size);
        return size;
    }

    @Override
    public Data toData(Object obj, DataType dataType) {
        Object data = dataType == DataType.NATIVE ? this.ess.toNativeData(obj, this.memoryManager) : this.ess.toData(obj, dataType);
        if (data instanceof NativeMemoryData && data != obj) {
            this.storageInfo.addUsedMemory(this.recordAccessor.getSize((NativeMemoryData)data));
        }
        return data;
    }

    @Override
    public Object toObject(Object data) {
        return this.ess.toObject(data, this.memoryManager);
    }

    @Override
    public Data convertData(Data data, DataType dataType) {
        Object convertedData = dataType == DataType.NATIVE ? this.ess.convertToNativeData(data, this.memoryManager) : this.ess.convertData(data, dataType);
        if (convertedData instanceof NativeMemoryData && convertedData != data) {
            this.storageInfo.addUsedMemory(this.recordAccessor.getSize((NativeMemoryData)convertedData));
        }
        return convertedData;
    }

    @Override
    public void disposeData(Data data) {
        long size = 0L;
        if (data instanceof NativeMemoryData) {
            size = this.recordAccessor.getSize((NativeMemoryData)data);
        }
        this.ess.disposeData(data, this.memoryManager);
        this.storageInfo.removeUsedMemory(size);
    }

    @Override
    public long allocate(long size) {
        long address = this.memoryManager.allocate(size);
        this.storageInfo.addUsedMemory(this.recordAccessor.getSize(address, size));
        return address;
    }

    @Override
    public void free(long address, long size) {
        long disposedSize = this.recordAccessor.getSize(address, size);
        this.memoryManager.free(address, size);
        this.storageInfo.removeUsedMemory(disposedSize);
    }

    public HazelcastMemoryManager getMemoryManager() {
        return this.memoryManager;
    }

    @Override
    public MemoryAllocator unwrapMemoryAllocator() {
        return this.memoryManager.getSystemAllocator();
    }
}

