/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.elastic.tree;

import com.hazelcast.internal.elastic.tree.OffHeapComparator;
import com.hazelcast.internal.memory.MemoryBlock;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.HeapData;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import com.hazelcast.query.impl.Comparables;

public class ComparableComparator
implements OffHeapComparator {
    private final EnterpriseSerializationService ess;
    private final ThreadLocal<NativeMemoryData> leftDataHolder = new ThreadLocal<NativeMemoryData>(){

        @Override
        protected NativeMemoryData initialValue() {
            return new NativeMemoryData();
        }
    };
    private final ThreadLocal<NativeMemoryData> rightDataHolder = new ThreadLocal<NativeMemoryData>(){

        @Override
        protected NativeMemoryData initialValue() {
            return new NativeMemoryData();
        }
    };

    public ComparableComparator(EnterpriseSerializationService ess) {
        this.ess = ess;
    }

    @Override
    public int compare(MemoryBlock lBlob, MemoryBlock rBlob) {
        NativeMemoryData leftData = this.leftDataHolder.get();
        NativeMemoryData rightData = this.rightDataHolder.get();
        leftData.reset(lBlob.address(), lBlob.size());
        rightData.reset(rBlob.address(), rBlob.size());
        if (leftData.equals(rightData)) {
            return 0;
        }
        Comparable left = null;
        if (leftData.totalSize() > 0) {
            left = (Comparable)this.ess.toObject(leftData);
        }
        Comparable right = null;
        if (rightData.totalSize() > 0) {
            right = (Comparable)this.ess.toObject(rightData);
        }
        if (left != null && right != null) {
            return Comparables.compare(left, right);
        }
        if (left == null) {
            return 1;
        }
        return -1;
    }

    @Override
    public int compare(byte[] lBlob, byte[] rBlob) {
        HeapData leftData = new HeapData(lBlob);
        HeapData rightData = new HeapData(rBlob);
        if (((Object)leftData).equals(rightData)) {
            return 0;
        }
        if (leftData.totalSize() > 0 && rightData.totalSize() > 0) {
            Comparable left = (Comparable)this.ess.toObject(leftData);
            Comparable right = (Comparable)this.ess.toObject(rightData);
            return Comparables.compare(left, right);
        }
        if (leftData.totalSize() > 0) {
            return 1;
        }
        return -1;
    }
}

