/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.elastic.queue;

import com.hazelcast.internal.elastic.LongIterator;
import com.hazelcast.internal.elastic.queue.LongQueue;
import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.memory.MemoryAllocator;
import java.util.NoSuchElementException;

public final class LongLinkedQueue
implements LongQueue {
    private static final long NULL_PTR = 0L;
    private static final int NODE_SIZE = 16;
    private static final int NEXT_OFFSET = 8;
    private final MemoryAllocator malloc;
    private final long nullItem;
    private final int capacity;
    private final boolean hasCapacity;
    private long head;
    private long tail;
    private int size;

    public LongLinkedQueue(MemoryAllocator malloc, int capacity, long nullValue) {
        this.malloc = malloc;
        this.capacity = capacity;
        this.hasCapacity = capacity < Integer.MAX_VALUE;
        this.nullItem = nullValue;
        this.tail = this.head = this.newNode(this.nullItem);
    }

    public LongLinkedQueue(MemoryAllocator memoryAllocator, long nullValue) {
        this(memoryAllocator, Integer.MAX_VALUE, nullValue);
    }

    private long newNode(long e) {
        long address = this.malloc.allocate(16L);
        GlobalMemoryAccessorRegistry.AMEM.putLong(null, address, e);
        GlobalMemoryAccessorRegistry.AMEM.putLong(null, address + 8L, 0L);
        return address;
    }

    private static long getItem(long node) {
        assert (node != 0L);
        return GlobalMemoryAccessorRegistry.AMEM.getLong(node);
    }

    private static long getNextNode(long node) {
        assert (node != 0L);
        return GlobalMemoryAccessorRegistry.AMEM.getLong(node + 8L);
    }

    private static void setNextNode(long node, long value) {
        assert (node != 0L);
        GlobalMemoryAccessorRegistry.AMEM.putLong(node + 8L, value);
    }

    @Override
    public boolean offer(long value) {
        if (this.tail == 0L) {
            throw new IllegalStateException("Queue is already destroyed! " + this.toString());
        }
        if (value == this.nullItem) {
            throw new IllegalArgumentException();
        }
        if (this.hasCapacity && this.size == this.capacity) {
            return false;
        }
        long node = this.newNode(value);
        LongLinkedQueue.setNextNode(this.tail, node);
        this.tail = node;
        ++this.size;
        return true;
    }

    @Override
    public long poll() {
        this.ensureMemory();
        if (this.size == 0) {
            return this.nullItem;
        }
        long node = this.head;
        long newHead = LongLinkedQueue.getNextNode(node);
        if (newHead == 0L) {
            return this.nullItem;
        }
        long item = LongLinkedQueue.getItem(newHead);
        this.head = newHead;
        --this.size;
        this.malloc.free(node, 16L);
        return item;
    }

    @Override
    public long peek() {
        this.ensureMemory();
        if (this.size == 0) {
            return this.nullItem;
        }
        long first = LongLinkedQueue.getNextNode(this.head);
        if (first == 0L) {
            return this.nullItem;
        }
        return LongLinkedQueue.getItem(first);
    }

    @Override
    public int size() {
        long c = this.size;
        return c < Integer.MAX_VALUE ? (int)c : Integer.MAX_VALUE;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public int remainingCapacity() {
        return this.hasCapacity ? this.capacity - this.size() : Integer.MAX_VALUE;
    }

    @Override
    public void clear() {
        while (this.poll() != this.nullItem) {
        }
    }

    @Override
    public void dispose() {
        if (this.head != 0L) {
            this.clear();
            assert (this.head == this.tail);
            if (this.head != 0L) {
                this.malloc.free(this.head, 16L);
            }
            this.head = 0L;
            this.tail = 0L;
        }
    }

    @Override
    public long nullItem() {
        return this.nullItem;
    }

    @Override
    public LongIterator iterator() {
        this.ensureMemory();
        return new Iter();
    }

    private void ensureMemory() {
        if (this.head == 0L) {
            throw new IllegalStateException("Queue is already destroyed! " + this.toString());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("LongLinkedQueue{");
        sb.append("nullItem=").append(this.nullItem);
        sb.append(", capacity=").append(this.capacity);
        sb.append(", head=").append(this.head);
        sb.append(", tail=").append(this.tail);
        sb.append(", size=").append(this.size);
        sb.append('}');
        return sb.toString();
    }

    private final class Iter
    implements LongIterator {
        long currentNode;

        private Iter() {
            this.reset();
        }

        @Override
        public boolean hasNext() {
            return this.currentNode != 0L;
        }

        @Override
        public long next() {
            if (this.currentNode == 0L) {
                throw new NoSuchElementException();
            }
            LongLinkedQueue.this.ensureMemory();
            long item = LongLinkedQueue.getItem(this.currentNode);
            this.currentNode = LongLinkedQueue.getNextNode(this.currentNode);
            return item;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reset() {
            this.currentNode = LongLinkedQueue.getNextNode(LongLinkedQueue.this.head);
        }
    }
}

