/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.dynamicconfig.rewrite;

import com.hazelcast.internal.dynamicconfig.rewrite.RewriteChunk;
import com.hazelcast.internal.dynamicconfig.rewrite.RewriteChunkXml;
import com.hazelcast.internal.dynamicconfig.rewrite.RewritePositionFinder;
import com.hazelcast.internal.dynamicconfig.rewrite.RewritePositionFinderXml;
import com.hazelcast.internal.dynamicconfig.rewrite.RewritePositionFinderYaml;
import com.hazelcast.internal.dynamicconfig.rewrite.RewriteUtil;
import java.io.IOException;

public class Rewriter {
    private final String documentAsString;
    private final RewriteChunk rewriteChunk;
    private final boolean configIsXml;

    public Rewriter(String documentAsString, RewriteChunk rewriteChunk) {
        this.documentAsString = documentAsString;
        this.rewriteChunk = rewriteChunk;
        this.configIsXml = Rewriter.isConfigIsXml(rewriteChunk);
    }

    public String rewrite() throws IOException {
        RewritePositionFinder rewritePositionFinder = this.configIsXml ? new RewritePositionFinderXml(this.documentAsString, this.rewriteChunk.path) : new RewritePositionFinderYaml(this.documentAsString, this.rewriteChunk.path);
        rewritePositionFinder.setPositions();
        this.rewriteChunk.formatAndExtend(rewritePositionFinder.differencePath, rewritePositionFinder.shouldTrim, RewriteUtil.configFileUsesUnixLineSeparator(this.documentAsString));
        String rewrittenOutput = this.documentAsString.substring(0, rewritePositionFinder.startPosition) + this.rewriteChunk.chunk;
        rewrittenOutput = rewrittenOutput + this.documentAsString.substring(rewritePositionFinder.endPosition);
        return rewrittenOutput;
    }

    private static boolean isConfigIsXml(RewriteChunk rewriteChunk) {
        return rewriteChunk instanceof RewriteChunkXml;
    }
}

