/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.dynamicconfig.rewrite;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.dynamicconfig.rewrite.NameSegment;
import com.hazelcast.internal.dynamicconfig.rewrite.Segment;
import com.hazelcast.internal.dynamicconfig.rewrite.TypeSegment;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.Objects;

class RewritePath {
    private final Deque<Segment> pathAsDeque;

    RewritePath() {
        this.pathAsDeque = new ArrayDeque<Segment>();
    }

    RewritePath(RewritePath path) {
        this.pathAsDeque = ((ArrayDeque)path.pathAsDeque).clone();
    }

    RewritePath addTypeSegment(String rawSegment) {
        this.pathAsDeque.addLast(new TypeSegment(rawSegment));
        return this;
    }

    RewritePath addNameSegment(String rawSegment) {
        this.pathAsDeque.addLast(new NameSegment(rawSegment));
        return this;
    }

    void removeLastTypeSegment() {
        if (this.pathAsDeque.removeLast() instanceof NameSegment) {
            this.pathAsDeque.removeLast();
        }
    }

    String removeLastSegment() {
        return this.pathAsDeque.removeLast().rawSegment;
    }

    boolean removeFirstIfSegmentMatches(String rawSegment) {
        assert (this.pathAsDeque.peekFirst() != null);
        if (rawSegment.equals(this.pathAsDeque.peekFirst().rawSegment)) {
            this.pathAsDeque.removeFirst();
            return true;
        }
        return false;
    }

    int typeSegmentCount() {
        int size = 0;
        for (Segment segment : this.pathAsDeque) {
            if (!(segment instanceof TypeSegment)) continue;
            ++size;
        }
        return size;
    }

    int segmentCount() {
        return this.pathAsDeque.size();
    }

    boolean isChildOf(RewritePath parentPath) {
        if (parentPath.pathAsDeque.size() > this.pathAsDeque.size()) {
            return false;
        }
        Iterator<Segment> childIterator = this.pathAsDeque.iterator();
        for (Segment segment : parentPath.pathAsDeque) {
            if (segment.equals(childIterator.next())) continue;
            return false;
        }
        return true;
    }

    RewritePath calculateDifferenceToExtendForXml(RewritePath shortPath) {
        assert (shortPath.pathAsDeque.size() <= this.pathAsDeque.size());
        RewritePath differencePath = new RewritePath();
        int skipCount = shortPath.pathAsDeque.size();
        for (Segment segment : this.pathAsDeque) {
            if (skipCount > 0) {
                --skipCount;
                continue;
            }
            differencePath.pathAsDeque.addLast(segment);
        }
        if (differencePath.pathAsDeque.isEmpty()) {
            return differencePath;
        }
        differencePath.removeLastTypeSegment();
        RewritePath.checkPathOnlyContainsTypeSegments(differencePath);
        return differencePath;
    }

    static void checkPathOnlyContainsTypeSegments(RewritePath rewritePath) {
        for (Segment segment : rewritePath.pathAsDeque) {
            if (!(segment instanceof NameSegment)) continue;
            throw new HazelcastException("There is a name present in path, but not in declarative configuration.");
        }
    }

    public String toString() {
        StringBuilder path = new StringBuilder();
        for (Segment segment : this.pathAsDeque) {
            path.append(segment);
        }
        return path.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RewritePath that = (RewritePath)o;
        Iterator<Segment> thisIt = this.pathAsDeque.iterator();
        Iterator<Segment> thatIt = that.pathAsDeque.iterator();
        while (thisIt.hasNext()) {
            if (thatIt.hasNext() && thisIt.next().equals(thatIt.next())) continue;
            return false;
        }
        return !thatIt.hasNext();
    }

    public int hashCode() {
        return Objects.hash(this.pathAsDeque);
    }
}

